/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.codeInspection.export.InspectionTreeHtmlExportResources;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.ui.ExcludedInspectionTreeNodesManager;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionTreeTailRenderer;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementAndDescriptorAware;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class InspectionTreeHtmlWriter {
    private static final String ERROR_COLOR = "ffabab";
    private static final String WARNING_COLOR = "f2f794";
    private final InspectionTree myTree;
    private final String myOutputDir;
    private final StringBuffer myBuilder = new StringBuffer();
    private final InspectionProfile myProfile;
    private final RefManager myManager;
    private final ExcludedInspectionTreeNodesManager myExcludedManager;

    public InspectionTreeHtmlWriter(InspectionResultsView view, String outputDir) {
        this.myTree = view.getTree();
        this.myOutputDir = outputDir;
        this.myProfile = view.getCurrentProfile();
        this.myManager = view.getGlobalInspectionContext().getRefManager();
        this.myExcludedManager = view.getExcludedManager();
        this.serializeTreeToHtml();
    }

    private void traverseInspectionTree(InspectionTreeNode node, Consumer<InspectionTreeNode> preAction, Consumer<InspectionTreeNode> postAction) {
        if (node.isExcluded(this.myExcludedManager)) {
            return;
        }
        preAction.accept(node);
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            this.traverseInspectionTree((InspectionTreeNode)node.getChildAt(i2), preAction, postAction);
        }
        postAction.accept(node);
    }

    private void serializeTreeToHtml() {
        this.appendHeader();
        this.appendTree(builder -> {
            InspectionTreeTailRenderer tailRenderer = new InspectionTreeTailRenderer(this.myTree.getContext(), (StringBuffer)builder){
                final /* synthetic */ StringBuffer val$builder;
                {
                    this.val$builder = stringBuffer;
                    super(context);
                }

                @Override
                protected void appendText(String text, SimpleTextAttributes attributes) {
                    this.val$builder.append(InspectionTreeHtmlWriter.escapeNonBreakingSymbols(text));
                }

                @Override
                protected void appendText(String text) {
                    this.val$builder.append(InspectionTreeHtmlWriter.escapeNonBreakingSymbols(text));
                }
            };
            this.traverseInspectionTree(this.myTree.getRoot(), n -> {
                RefEntity e;
                int nodeId = System.identityHashCode(n);
                builder.append("<li><label for=\"").append(nodeId).append("\">").append(this.convertNodeToHtml((InspectionTreeNode)n)).append("&nbsp;<span class=\"grayout\">");
                tailRenderer.appendTailText((InspectionTreeNode)n);
                builder.append("</span></label><input type=\"checkbox\" ");
                if (n instanceof InspectionRootNode) {
                    builder.append("checked");
                }
                builder.append(" onclick=\"navigate(").append(nodeId).append(")\" ");
                builder.append(" id=\"").append(nodeId).append("\" />");
                if (n instanceof RefElementAndDescriptorAware && (e = ((RefElementAndDescriptorAware)((Object)n)).getElement()) != null) {
                    builder.append("<div id=\"d").append(nodeId).append("\" style=\"display:none\">");
                    ((RefElementAndDescriptorAware)((Object)n)).getPresentation().getComposer().compose((StringBuffer)builder, e);
                    builder.append("</div>");
                }
                builder.append("<ol class=\"tree\">");
            }, n -> builder.append("</ol></li>"));
        });
        HTMLExportUtil.writeFile(this.myOutputDir, "index.html", this.myBuilder, this.myTree.getContext().getProject());
        InspectionTreeHtmlExportResources.copyInspectionReportResources(this.myOutputDir);
    }

    private String convertNodeToHtml(InspectionTreeNode node) {
        if (node instanceof InspectionRootNode) {
            return "<b>'" + InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node) + "' project</b>";
        }
        if (node instanceof ProblemDescriptionNode) {
            CommonProblemDescriptor descriptor = ((ProblemDescriptionNode)node).getDescriptor();
            String warningLevelName = "";
            String color = null;
            if (descriptor instanceof ProblemDescriptorBase) {
                InspectionToolWrapper tool = ((ProblemDescriptionNode)node).getToolWrapper();
                HighlightDisplayKey key2 = HighlightDisplayKey.find((String)tool.getShortName());
                HighlightSeverity severity = this.myProfile.getErrorLevel(key2, ((ProblemDescriptorBase)descriptor).getStartElement()).getSeverity();
                HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                if (HighlightDisplayLevel.ERROR.equals(level)) {
                    color = ERROR_COLOR;
                } else if (HighlightDisplayLevel.WARNING.equals(level)) {
                    color = WARNING_COLOR;
                }
                warningLevelName = level.getName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<span style=\"margin:1px;");
            if (color != null) {
                sb.append("background:#");
                sb.append(color);
            }
            sb.append("\">");
            sb.append(warningLevelName);
            sb.append("</span>&nbsp;");
            sb.append(InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node));
            return sb.toString();
        }
        if (node instanceof RefElementNode) {
            String type2 = this.myManager.getType((RefEntity)node.getUserObject());
            return type2 + "&nbsp;<b>" + node.toString() + "</b>";
        }
        if (node instanceof InspectionNode) {
            return "<b>" + InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node) + "</b>&nbsp;inspection";
        }
        if (node instanceof InspectionGroupNode) {
            return "<b>" + InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node) + "</b>&nbsp;group";
        }
        return InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node);
    }

    private void appendHeader() {
        String title = ApplicationNamesInfo.getInstance().getFullProductName() + " inspection report";
        this.myBuilder.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\"><meta name=\"author\" content=\"JetBrains\"><script type=\"text/javascript\" src=\"script.js\"></script><link rel=\"stylesheet\" type=\"text/css\" href=\"styles.css\"/><title>").append(title).append("</title></head><body><h3>").append(title).append(":</h3>");
    }

    private void appendTree(Consumer<StringBuffer> treeRenderer) {
        this.myBuilder.append("<div style=\"width:100%;\"><div style=\"float:left; width:50%;\"><h4>Inspection tree:</h4>");
        treeRenderer.accept(this.myBuilder);
        this.myBuilder.append("</div><div style=\"float:left; width:50%;\"><h4>Problem description:</h4><div id=\"preview\">Select a problem element in tree</div></div><div></body></html>");
    }

    private static String escapeNonBreakingSymbols(@NotNull Object source) {
        return StringUtil.replace((String)StringUtil.escapeXml((String)source.toString()), (String[])new String[]{" ", "-"}, (String[])new String[]{"&nbsp;", "&#8209;"});
    }
}

