/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityInferrer {
    private static final int MAX_PASSES = 10;
    public static final String NOTHING_FOUND_TO_INFER = "Nothing found to infer";
    private int numAnnotationsAdded;
    private final List<SmartPsiElementPointer<? extends PsiModifierListOwner>> myNotNullSet = new ArrayList<SmartPsiElementPointer<? extends PsiModifierListOwner>>();
    private final List<SmartPsiElementPointer<? extends PsiModifierListOwner>> myNullableSet = new ArrayList<SmartPsiElementPointer<? extends PsiModifierListOwner>>();
    private final boolean myAnnotateLocalVariables;
    private final SmartPointerManager myPointerManager;

    public NullityInferrer(boolean annotateLocalVariables, Project project2) {
        this.myAnnotateLocalVariables = annotateLocalVariables;
        this.myPointerManager = SmartPointerManager.getInstance((Project)project2);
    }

    private boolean expressionIsNeverNull(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        ExpressionIsNeverNullVisitor visitor = new ExpressionIsNeverNullVisitor();
        expression2.accept((PsiElementVisitor)visitor);
        return visitor.isNeverNull();
    }

    private boolean expressionIsSometimesNull(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        ExpressionIsSometimesNullVisitor visitor = new ExpressionIsSometimesNullVisitor();
        expression2.accept((PsiElementVisitor)visitor);
        return visitor.isSometimesNull();
    }

    private boolean methodNeverReturnsNull(@NotNull PsiMethod method2) {
        MethodNeverReturnsNullVisitor visitor = new MethodNeverReturnsNullVisitor();
        method2.accept((PsiElementVisitor)visitor);
        return visitor.getNeverReturnsNull();
    }

    private boolean variableNeverAssignedNull(@NotNull PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null ? !this.expressionIsNeverNull(initializer) : !variable.hasModifierProperty("final")) {
            return false;
        }
        Query references = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment = (PsiAssignmentExpression)parent).getLExpression().equals(element) || this.expressionIsNeverNull(assignment.getRExpression())) continue;
            return false;
        }
        return true;
    }

    private boolean variableSometimesAssignedNull(@NotNull PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && this.expressionIsSometimesNull(initializer)) {
            return true;
        }
        Query references = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment = (PsiAssignmentExpression)parent).getLExpression().equals(element) || !this.expressionIsSometimesNull(assignment.getRExpression())) continue;
            return true;
        }
        return false;
    }

    public void collect(@NotNull PsiFile file2) {
        int prevNumAnnotationsAdded;
        int pass = 0;
        do {
            NullityInferrerVisitor visitor = new NullityInferrerVisitor();
            prevNumAnnotationsAdded = this.numAnnotationsAdded;
            file2.accept((PsiElementVisitor)visitor);
        } while (prevNumAnnotationsAdded < this.numAnnotationsAdded && ++pass < 10);
    }

    public void apply(Project project2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> pointer : this.myNullableSet) {
            NullityInferrer.annotateNullable(project2, manager, (PsiModifierListOwner)pointer.getElement());
        }
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> pointer : this.myNotNullSet) {
            NullityInferrer.annotateNotNull(project2, manager, (PsiModifierListOwner)pointer.getElement());
        }
        if (this.myNullableSet.isEmpty() && this.myNotNullSet.isEmpty()) {
            throw new RuntimeException(NOTHING_FOUND_TO_INFER);
        }
    }

    public static void nothingFoundMessage(Project project2) {
        SwingUtilities.invokeLater(() -> Messages.showInfoMessage((Project)project2, (String)"No places found to infer @Nullable/@NotNull", (String)"Infer Nullity Results"));
    }

    private static void annotateNotNull(Project project2, NullableNotNullManager manager, PsiModifierListOwner element) {
        if (element != null) {
            if (element instanceof PsiField && ((PsiField)element).hasInitializer() && element.hasModifierProperty("final")) {
                return;
            }
            NullityInferrer.invoke(project2, element, manager.getDefaultNotNull(), manager.getDefaultNullable());
        }
    }

    private static void annotateNullable(Project project2, NullableNotNullManager manager, PsiModifierListOwner element) {
        if (element != null) {
            NullityInferrer.invoke(project2, element, manager.getDefaultNullable(), manager.getDefaultNotNull());
        }
    }

    private static void invoke(Project project2, PsiModifierListOwner element, String fqn, String toRemove) {
        new AddAnnotationFix(fqn, element, toRemove).invoke(project2, null, element.getContainingFile());
    }

    public int getCount() {
        return this.myNotNullSet.size() + this.myNullableSet.size();
    }

    public static void apply(Project project2, NullableNotNullManager manager, UsageInfo info) {
        if (info instanceof NullableUsageInfo) {
            NullityInferrer.annotateNullable(project2, manager, (PsiModifierListOwner)info.getElement());
        } else if (info instanceof NotNullUsageInfo) {
            NullityInferrer.annotateNotNull(project2, manager, (PsiModifierListOwner)info.getElement());
        }
    }

    private boolean shouldIgnore(PsiModifierListOwner element) {
        if (!this.myAnnotateLocalVariables) {
            if (element instanceof PsiLocalVariable) {
                return true;
            }
            if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement) {
                return true;
            }
        }
        return false;
    }

    private void registerNullableAnnotation(@NotNull PsiModifierListOwner method2) {
        this.registerAnnotation(method2, true);
    }

    private void registerNotNullAnnotation(@NotNull PsiModifierListOwner method2) {
        this.registerAnnotation(method2, false);
    }

    private void registerAnnotation(@NotNull PsiModifierListOwner method2, boolean isNullable) {
        SmartPsiElementPointer methodPointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)method2);
        if (isNullable) {
            this.myNullableSet.add((SmartPsiElementPointer<? extends PsiModifierListOwner>)methodPointer);
        } else {
            this.myNotNullSet.add((SmartPsiElementPointer<? extends PsiModifierListOwner>)methodPointer);
        }
        ++this.numAnnotationsAdded;
    }

    public void collect(List<UsageInfo> usages) {
        this.collect(usages, true);
        this.collect(usages, false);
    }

    private void collect(List<UsageInfo> usages, boolean nullable) {
        List<SmartPsiElementPointer<? extends PsiModifierListOwner>> set2 = nullable ? this.myNullableSet : this.myNotNullSet;
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> elementPointer : set2) {
            PsiModifierListOwner element = (PsiModifierListOwner)elementPointer.getElement();
            if (element == null || this.shouldIgnore(element)) continue;
            usages.add(nullable ? new NullableUsageInfo((PsiElement)element) : new NotNullUsageInfo((PsiElement)element));
        }
    }

    private static boolean trunkImpossibleBrunch(PsiExpression condition2, PsiExpression elseExpression2, PsiExpression rOperand, PsiExpression lOperand) {
        PsiElement resolve2;
        return rOperand instanceof PsiLiteralExpression && "null".equals(rOperand.getText()) && lOperand instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)lOperand).resolve()) instanceof PsiVariable && ((PsiBinaryExpression)condition2).getOperationTokenType() == JavaTokenType.EQEQ && elseExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)elseExpression2).resolve() == resolve2;
    }

    private static boolean canTrunkImpossibleBrunch(PsiExpression condition2, PsiExpression elseExpression2) {
        PsiExpression lOperand;
        PsiExpression rOperand;
        return condition2 instanceof PsiBinaryExpression && (NullityInferrer.trunkImpossibleBrunch(condition2, elseExpression2, rOperand = ((PsiBinaryExpression)condition2).getROperand(), lOperand = ((PsiBinaryExpression)condition2).getLOperand()) || NullityInferrer.trunkImpossibleBrunch(condition2, elseExpression2, lOperand, rOperand));
    }

    private boolean isNotNull(PsiModifierListOwner owner) {
        if (NullableNotNullManager.isNotNull((PsiModifierListOwner)owner)) {
            return true;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner);
        return this.myNotNullSet.contains(pointer);
    }

    private boolean isNullable(PsiModifierListOwner owner) {
        if (NullableNotNullManager.isNullable((PsiModifierListOwner)owner)) {
            return true;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner);
        return this.myNullableSet.contains(pointer);
    }

    private class NullityInferrerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private NullityInferrerVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            super.visitMethod(method2);
            if (method2.isConstructor() || method2.getReturnType() instanceof PsiPrimitiveType) {
                return;
            }
            Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method2).findAll();
            for (PsiMethod overridingMethod : overridingMethods) {
                if (!NullityInferrer.this.isNullable((PsiModifierListOwner)overridingMethod)) continue;
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method2);
                return;
            }
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method2.getProject());
            if (!manager.isNotNull((PsiModifierListOwner)method2, false) && manager.isNotNull((PsiModifierListOwner)method2, true)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method2);
                return;
            }
            if (NullityInferrer.this.isNotNull((PsiModifierListOwner)method2) || NullityInferrer.this.isNullable((PsiModifierListOwner)method2)) {
                return;
            }
            PsiCodeBlock body2 = method2.getBody();
            if (body2 != null) {
                final boolean[] sometimesReturnsNull = new boolean[1];
                body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitLambdaExpression(PsiLambdaExpression expression2) {
                    }

                    public void visitElement(PsiElement element) {
                        if (sometimesReturnsNull[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReturnStatement(PsiReturnStatement statement2) {
                        super.visitReturnStatement(statement2);
                        PsiExpression value2 = statement2.getReturnValue();
                        if (NullityInferrer.this.expressionIsSometimesNull(value2)) {
                            sometimesReturnsNull[0] = true;
                        }
                    }
                });
                if (sometimesReturnsNull[0]) {
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method2);
                    return;
                }
            }
            if (NullityInferrer.this.methodNeverReturnsNull(method2)) {
                for (PsiMethod overridingMethod : overridingMethods) {
                    if (NullityInferrer.this.isNotNull((PsiModifierListOwner)overridingMethod)) continue;
                    return;
                }
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method2);
            }
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (variable.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)variable) || NullityInferrer.this.isNullable((PsiModifierListOwner)variable)) {
                return;
            }
            if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)variable)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
            }
            if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)variable)) {
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)variable);
            }
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            super.visitParameter(parameter);
            if (parameter.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)parameter) || NullityInferrer.this.isNullable((PsiModifierListOwner)parameter)) {
                return;
            }
            PsiElement grandParent = parameter.getDeclarationScope();
            if (grandParent instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)grandParent;
                if (method2.getBody() != null) {
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)method2))) {
                        PsiElement place = reference.getElement();
                        if (!(place instanceof PsiReferenceExpression)) continue;
                        PsiReferenceExpression expr = (PsiReferenceExpression)place;
                        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class});
                        if (this.processParameter(parameter, expr, parent)) {
                            return;
                        }
                        if (!NullityInferrer.this.isNotNull((PsiModifierListOwner)method2)) continue;
                        PsiElement toReturn = parent;
                        if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != expr) {
                            toReturn = parent.getParent();
                        }
                        if (!(toReturn instanceof PsiReturnStatement)) continue;
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return;
                    }
                }
            } else if (grandParent instanceof PsiForeachStatement) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(grandParent))) {
                    PsiElement parent;
                    PsiReferenceExpression expr;
                    PsiElement place = reference.getElement();
                    if (!(place instanceof PsiReferenceExpression) || !this.processParameter(parameter, expr = (PsiReferenceExpression)place, parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) continue;
                    return;
                }
            } else {
                if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)parameter)) {
                    NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                }
                if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)parameter)) {
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)parameter);
                }
            }
        }

        private boolean processParameter(PsiParameter parameter, PsiReferenceExpression expr, PsiElement parent) {
            PsiParameter resolvedToParam;
            PsiParameter[] parameters2;
            PsiMethod resolvedMethod;
            Object[] args;
            int idx;
            PsiExpressionList argumentList;
            PsiCall call;
            if (PsiUtil.isAccessedForWriting((PsiExpression)expr)) {
                return true;
            }
            if (parent instanceof PsiBinaryExpression) {
                PsiExpression opposite = null;
                PsiExpression lOperand = ((PsiBinaryExpression)parent).getLOperand();
                PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
                if (lOperand == expr) {
                    opposite = rOperand;
                } else if (rOperand == expr) {
                    opposite = lOperand;
                }
                if (opposite != null && opposite.getType() == PsiType.NULL) {
                    if (parent.getParent() instanceof PsiAssertStatement && ((PsiBinaryExpression)parent).getOperationTokenType() == JavaTokenType.NE) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)parameter);
                    return true;
                }
            } else {
                if (parent instanceof PsiInstanceOfExpression) {
                    return true;
                }
                if (parent instanceof PsiReferenceExpression) {
                    PsiExpression qualifierExpression2 = ((PsiReferenceExpression)parent).getQualifierExpression();
                    if (qualifierExpression2 == expr) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                    PsiElement exprParent = expr.getParent();
                    while (exprParent instanceof PsiTypeCastExpression || exprParent instanceof PsiParenthesizedExpression) {
                        if (qualifierExpression2 == exprParent) {
                            NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                            return true;
                        }
                        exprParent = exprParent.getParent();
                    }
                } else if (parent instanceof PsiAssignmentExpression) {
                    PsiVariable localVar;
                    PsiElement resolve2;
                    PsiExpression expression2;
                    if (((PsiAssignmentExpression)parent).getRExpression() == expr && (expression2 = ((PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable && NullityInferrer.this.isNotNull((PsiModifierListOwner)(localVar = (PsiVariable)resolve2))) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                } else if (parent instanceof PsiForeachStatement) {
                    if (((PsiForeachStatement)parent).getIteratedValue() == expr) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return true;
                    }
                } else if (parent instanceof PsiSwitchStatement && ((PsiSwitchStatement)parent).getExpression() == expr) {
                    NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                    return true;
                }
            }
            if ((call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiCall.class)) != null && (argumentList = call.getArgumentList()) != null && (idx = ArrayUtil.find((Object[])(args = argumentList.getExpressions()), (Object)expr)) >= 0 && (resolvedMethod = call.resolveMethod()) != null && idx < (parameters2 = resolvedMethod.getParameterList().getParameters()).length && NullityInferrer.this.isNotNull((PsiModifierListOwner)(resolvedToParam = parameters2[idx])) && !resolvedToParam.isVarArgs()) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                return true;
            }
            return false;
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (field instanceof PsiEnumConstant) {
                return;
            }
            if (field.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)field) || NullityInferrer.this.isNullable((PsiModifierListOwner)field)) {
                return;
            }
            if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)field)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)field);
            }
            if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)field)) {
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)field);
            }
        }
    }

    private class MethodNeverReturnsNullVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean neverReturnsNull = true;

        private MethodNeverReturnsNullVisitor() {
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
            super.visitReturnStatement(statement2);
            PsiExpression value2 = statement2.getReturnValue();
            if (NullityInferrer.this.expressionIsNeverNull(value2)) {
                return;
            }
            if (value2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)value2;
                PsiMethod method2 = methodCallExpression.resolveMethod();
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value2, PsiMethod.class);
                if (method2 != null && method2.equals(containingMethod)) {
                    return;
                }
            }
            this.neverReturnsNull = false;
        }

        private boolean getNeverReturnsNull() {
            return this.neverReturnsNull;
        }
    }

    private class ExpressionIsSometimesNullVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean sometimesNull;

        private ExpressionIsSometimesNullVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (this.sometimesNull) {
                return;
            }
            super.visitElement(element);
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            this.sometimesNull = "null".equals(expression2.getText());
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(expression2.getRExpression());
        }

        public void visitAssertStatement(PsiAssertStatement statement2) {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
            PsiExpression condition2 = expression2.getCondition();
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (NullityInferrer.canTrunkImpossibleBrunch(condition2, elseExpression2)) {
                this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(thenExpression2);
                return;
            }
            this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(thenExpression2) || NullityInferrer.this.expressionIsSometimesNull(elseExpression2);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiVariable var;
            PsiElement referent = expression2.resolve();
            if (referent instanceof PsiVariable && NullityInferrer.this.isNullable((PsiModifierListOwner)(var = (PsiVariable)referent))) {
                this.sometimesNull = true;
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 != null) {
                this.sometimesNull = NullityInferrer.this.isNullable((PsiModifierListOwner)method2);
            }
        }

        private boolean isSometimesNull() {
            return this.sometimesNull;
        }
    }

    private class ExpressionIsNeverNullVisitor
    extends JavaElementVisitor {
        private boolean neverNull = true;

        private ExpressionIsNeverNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            this.neverNull = !"null".equals(expression2.getText());
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(expression2.getRExpression());
        }

        public void visitAssertStatement(PsiAssertStatement statement2) {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
            PsiExpression condition2 = expression2.getCondition();
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (NullityInferrer.canTrunkImpossibleBrunch(condition2, elseExpression2)) {
                this.neverNull = NullityInferrer.this.expressionIsNeverNull(thenExpression2);
                return;
            }
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(thenExpression2) || NullityInferrer.this.expressionIsNeverNull(elseExpression2);
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression2) {
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(expression2.getExpression());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            this.neverNull = false;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiVariable var;
            PsiElement referent = expression2.resolve();
            if (referent instanceof PsiVariable && ((var = (PsiVariable)referent) instanceof PsiEnumConstant || NullityInferrer.this.isNotNull((PsiModifierListOwner)var))) {
                this.neverNull = true;
                return;
            }
            this.neverNull = false;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiMethod method2 = expression2.resolveMethod();
            this.neverNull = method2 != null && NullityInferrer.this.isNotNull((PsiModifierListOwner)method2);
        }

        private boolean isNeverNull() {
            return this.neverNull;
        }
    }

    private static class NotNullUsageInfo
    extends UsageInfo {
        private NotNullUsageInfo(@NotNull PsiElement element) {
            super(element);
        }
    }

    private static class NullableUsageInfo
    extends UsageInfo {
        private NullableUsageInfo(@NotNull PsiElement element) {
            super(element);
        }
    }
}

