/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inheritance;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ChangeSuperClassFix
implements LocalQuickFix {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myNewSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myOldSuperClass;
    private final int myPercent;
    @NotNull
    private final String myNewSuperName;

    public ChangeSuperClassFix(@NotNull PsiClass newSuperClass, int percent, @NotNull PsiClass oldSuperClass) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)newSuperClass.getProject());
        this.myNewSuperName = (String)ObjectUtils.notNull((Object)newSuperClass.getQualifiedName());
        this.myNewSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)newSuperClass);
        this.myOldSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)oldSuperClass);
        this.myPercent = percent;
    }

    @NotNull
    public PsiClass getNewSuperClass() {
        return (PsiClass)ObjectUtils.notNull((Object)this.myNewSuperClass.getElement());
    }

    public int getPercent() {
        return this.myPercent;
    }

    @NotNull
    public String getName() {
        return String.format("Make extends '%s' - %s%%", this.myNewSuperName, this.myPercent);
    }

    @NotNull
    public String getFamilyName() {
        return GroupNames.INHERITANCE_GROUP_NAME;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
        PsiClass oldSuperClass = (PsiClass)this.myOldSuperClass.getElement();
        PsiClass newSuperClass = (PsiClass)this.myNewSuperClass.getElement();
        if (oldSuperClass == null || newSuperClass == null) {
            return;
        }
        ChangeSuperClassFix.changeSuperClass((PsiClass)problemDescriptor.getPsiElement(), oldSuperClass, newSuperClass);
    }

    private static void changeSuperClass(@NotNull PsiClass aClass, @NotNull PsiClass oldSuperClass, @NotNull PsiClass newSuperClass) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        if (aClass instanceof PsiAnonymousClass) {
            ((PsiAnonymousClass)aClass).getBaseClassReference().replace((PsiElement)factory.createClassReferenceElement(newSuperClass));
        } else if (oldSuperClass.isInterface()) {
            PsiReferenceList extendsList;
            PsiReferenceList interfaceList = aClass.getImplementsList();
            if (interfaceList != null) {
                for (PsiJavaCodeReferenceElement interfaceRef : interfaceList.getReferenceElements()) {
                    PsiElement aInterface = interfaceRef.resolve();
                    if (aInterface == null || !aInterface.isEquivalentTo((PsiElement)oldSuperClass)) continue;
                    interfaceRef.delete();
                }
            }
            if ((extendsList = aClass.getExtendsList()) != null) {
                PsiJavaCodeReferenceElement newClassReference = factory.createClassReferenceElement(newSuperClass);
                if (extendsList.getReferenceElements().length == 0) {
                    extendsList.add((PsiElement)newClassReference);
                }
            }
        } else {
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && extendsList.getReferenceElements().length == 1) {
                extendsList.getReferenceElements()[0].delete();
                PsiElement ref = extendsList.add((PsiElement)factory.createClassReferenceElement(newSuperClass));
                JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(ref);
            }
        }
    }

    public static class LowPriority
    extends ChangeSuperClassFix
    implements LowPriorityAction {
        public LowPriority(@NotNull PsiClass newSuperClass, int percent, @NotNull PsiClass oldSuperClass) {
            super(newSuperClass, percent, oldSuperClass);
        }
    }
}

