/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inheritance.search;

import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;

class InheritorsCountData
implements Comparable<InheritorsCountData> {
    @NotNull
    private final PsiClass myPsiClass;
    private final int myInheritorsCount;

    public InheritorsCountData(@NotNull PsiClass psiClass, int inheritorsCount) {
        this.myPsiClass = psiClass;
        this.myInheritorsCount = inheritorsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof InheritorsCountData)) {
            return false;
        }
        InheritorsCountData data = (InheritorsCountData)o;
        return this.myInheritorsCount == data.myInheritorsCount && this.myPsiClass.equals(data.myPsiClass);
    }

    @NotNull
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    public int getInheritorsCount() {
        return this.myInheritorsCount;
    }

    public int hashCode() {
        String name = this.myPsiClass.getName();
        int result2 = name != null ? name.hashCode() : 0;
        return 31 * result2 + this.myInheritorsCount;
    }

    @Override
    public int compareTo(@NotNull InheritorsCountData that) {
        int sub = -this.myInheritorsCount + that.myInheritorsCount;
        if (sub != 0) {
            return sub;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(this.myPsiClass.getName(), that.myPsiClass.getName());
    }

    public String toString() {
        return String.format("%s:%d", this.myPsiClass, this.myInheritorsCount);
    }
}

