/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class Java8ListSortInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiClass containingClass;
                PsiMethod method2;
                super.visitMethodCallExpression(expression2);
                PsiElement nameElement = expression2.getMethodExpression().getReferenceNameElement();
                if (nameElement != null && expression2.getArgumentList().getExpressions().length == 2 && "sort".equals(nameElement.getText()) && (method2 = expression2.resolveMethod()) != null && (containingClass = method2.getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
                    holder.registerProblem(nameElement, QuickFixBundle.message("java.8.list.sort.inspection.description", new Object[0]), new LocalQuickFix[]{new ReplaceWithListSortFix()});
                }
            }
        };
    }

    private static class ReplaceWithListSortFix
    implements LocalQuickFix {
        private ReplaceWithListSortFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("java.8.list.sort.inspection.fix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression[] args;
            PsiElement element = descriptor.getStartElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (args = methodCallExpression.getArgumentList().getExpressions()).length == 2) {
                PsiExpression list = args[0];
                PsiExpression comparator2 = args[1];
                String replacement = ParenthesesUtils.getText(list, 2) + ".sort(" + comparator2.getText() + ")";
                methodCallExpression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(replacement, (PsiElement)methodCallExpression));
            }
        }
    }
}

