/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8MapApiInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8MapApiInspection.class);
    public static final String SHORT_NAME = "Java8MapApi";
    public boolean mySuggestMapGetOrDefault = true;
    public boolean mySuggestMapComputeIfAbsent = true;
    public boolean mySuggestMapPutIfAbsent = true;
    public boolean mySuggestMapMerge = true;
    public boolean myTreatGetNullAsContainsKey = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Suggest conversion to Map.computeIfAbsent", "mySuggestMapComputeIfAbsent");
        panel2.addCheckbox("Suggest conversion to Map.getOrDefault", "mySuggestMapGetOrDefault");
        panel2.addCheckbox("Suggest conversion to Map.putIfAbsent", "mySuggestMapPutIfAbsent");
        panel2.addCheckbox("Suggest conversion to Map.merge", "mySuggestMapMerge");
        panel2.addCheckbox("Treat 'get(k) != null' the same as 'containsKey(k)' (may change semantics)", "myTreatGetNullAsContainsKey");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                MapCheckCondition condition2 = Java8MapApiInspection.fromConditional((PsiElement)expression2, Java8MapApiInspection.this.myTreatGetNullAsContainsKey);
                if (condition2 == null || condition2.hasVariable()) {
                    return;
                }
                PsiExpression existsBranch = condition2.getExistsBranch(expression2.getThenExpression(), expression2.getElseExpression());
                PsiExpression noneBranch = condition2.getNoneBranch(expression2.getThenExpression(), expression2.getElseExpression());
                this.processGetPut(condition2, (PsiElement)existsBranch, (PsiElement)existsBranch, (PsiElement)noneBranch);
            }

            public void visitIfStatement(PsiIfStatement statement2) {
                MapCheckCondition condition2 = Java8MapApiInspection.fromConditional((PsiElement)statement2, Java8MapApiInspection.this.myTreatGetNullAsContainsKey);
                if (condition2 == null) {
                    return;
                }
                PsiStatement existsBranch = ControlFlowUtils.stripBraces(condition2.getExistsBranch(statement2.getThenBranch(), statement2.getElseBranch()));
                PsiStatement noneBranch = ControlFlowUtils.stripBraces(condition2.getNoneBranch(statement2.getThenBranch(), statement2.getElseBranch()));
                if (existsBranch == null) {
                    this.processSingleBranch(condition2, noneBranch);
                } else {
                    if (Java8MapApiInspection.this.mySuggestMapMerge && condition2.isGetNull()) {
                        this.processMerge(condition2, existsBranch, noneBranch);
                    }
                    if (condition2.hasVariable()) {
                        return;
                    }
                    EquivalenceChecker.Decision decision = EquivalenceChecker.getCanonicalPsiEquivalence().statementsAreEquivalentDecision(noneBranch, existsBranch);
                    this.processGetPut(condition2, (PsiElement)existsBranch, decision.getRightDiff(), decision.getLeftDiff());
                }
            }

            private void processMerge(MapCheckCondition condition2, PsiStatement existsBranch, PsiStatement noneBranch) {
                if (noneBranch instanceof PsiExpressionStatement && existsBranch instanceof PsiExpressionStatement) {
                    PsiElement[] mapRefs;
                    PsiExpression absentValue = Java8MapApiInspection.extractPutValue(condition2, noneBranch);
                    if (absentValue == null) {
                        return;
                    }
                    PsiExpression presentValue = Java8MapApiInspection.extractPutValue(condition2, existsBranch);
                    if (presentValue == null || !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)presentValue)) {
                        return;
                    }
                    if (!PsiTreeUtil.processElements((PsiElement)absentValue, e -> !condition2.isMap(e))) {
                        return;
                    }
                    boolean hasVariable = condition2.hasVariable();
                    if (hasVariable) {
                        if (PsiTreeUtil.collectElements((PsiElement)presentValue, condition2::isValueReference).length == 0) {
                            return;
                        }
                    }
                    if (hasVariable ^ (mapRefs = PsiTreeUtil.collectElements((PsiElement)presentValue, condition2::isMap)).length == 0) {
                        return;
                    }
                    for (PsiElement mapRef : mapRefs) {
                        PsiElement parent = mapRef.getParent();
                        if (parent instanceof PsiReferenceExpression && condition2.extractGetCall(parent.getParent()) != null) continue;
                        return;
                    }
                    if (PsiTreeUtil.collectElements((PsiElement)presentValue, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue)).length == 0) {
                        return;
                    }
                    condition2.register(holder, new ReplaceWithSingleMapOperation("merge", (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)absentValue, PsiMethodCallExpression.class), presentValue, (PsiElement)noneBranch));
                }
            }

            private void processGetPut(MapCheckCondition condition2, PsiElement result2, PsiElement exists, PsiElement none) {
                PsiMethodCallExpression getCall = condition2.extractGetCall(exists);
                if (getCall == null) {
                    return;
                }
                if (!(none instanceof PsiExpression)) {
                    return;
                }
                PsiExpression noneExpression = (PsiExpression)none;
                PsiMethodCallExpression putCall = Java8MapApiInspection.extractMapMethodCall(noneExpression, "put");
                if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && putCall != null && condition2.isGetNull() && condition2.isMap((PsiElement)putCall.getMethodExpression().getQualifierExpression())) {
                    PsiExpression[] putArgs = putCall.getArgumentList().getExpressions();
                    if (putArgs.length != 2 || !condition2.isKey((PsiElement)putArgs[0]) || !ExpressionUtils.isSimpleExpression(putArgs[1])) {
                        return;
                    }
                    condition2.register(holder, new ReplaceWithSingleMapOperation("putIfAbsent", getCall, putArgs[1], result2));
                }
                if (Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition2.isContainsKey() && ExpressionUtils.isSimpleExpression(noneExpression) && condition2.isMapValueType(noneExpression.getType())) {
                    condition2.register(holder, new ReplaceWithSingleMapOperation("getOrDefault", getCall, noneExpression, result2));
                }
            }

            private void processSingleBranch(MapCheckCondition condition2, PsiStatement noneBranch) {
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)noneBranch);
                if (assignment != null && Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition2.isContainsKey()) {
                    PsiExpression rValue = assignment.getRExpression();
                    if (ExpressionUtils.isSimpleExpression(rValue) && condition2.isValueReference((PsiElement)assignment.getLExpression()) && !condition2.isValueReference((PsiElement)rValue) && condition2.isMapValueType(rValue.getType())) {
                        condition2.register(holder, ReplaceWithSingleMapOperation.fromIf("getOrDefault", condition2, rValue));
                    }
                } else if (condition2.isGetNull()) {
                    PsiExpression expression2;
                    PsiExpression lambdaCandidate = Java8MapApiInspection.extractLambdaCandidate(condition2, noneBranch);
                    if (lambdaCandidate != null && Java8MapApiInspection.this.mySuggestMapComputeIfAbsent) {
                        condition2.register(holder, ReplaceWithSingleMapOperation.fromIf("computeIfAbsent", condition2, lambdaCandidate));
                    }
                    if (lambdaCandidate == null && (expression2 = Java8MapApiInspection.extractPutValue(condition2, noneBranch)) != null) {
                        String replacement = null;
                        if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && ExpressionUtils.isSimpleExpression(expression2) && !condition2.isValueReference((PsiElement)expression2)) {
                            replacement = "putIfAbsent";
                        } else if (Java8MapApiInspection.this.mySuggestMapComputeIfAbsent && !condition2.hasVariable()) {
                            replacement = "computeIfAbsent";
                        }
                        if (replacement != null) {
                            if (condition2.hasVariable()) {
                                condition2.register(holder, ReplaceWithSingleMapOperation.fromIf(replacement, condition2, expression2));
                            } else {
                                PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class);
                                LOG.assertTrue(call != null);
                                condition2.register(holder, new ReplaceWithSingleMapOperation(replacement, call, expression2, (PsiElement)noneBranch));
                            }
                        }
                    }
                }
            }
        };
    }

    @Nullable
    static PsiExpression extractLambdaCandidate(MapCheckCondition condition2, PsiStatement statement2) {
        PsiAssignmentExpression assignment;
        PsiExpression putValue = Java8MapApiInspection.extractPutValue(condition2, statement2);
        if (putValue != null) {
            assignment = ExpressionUtils.getAssignment((PsiElement)putValue);
        } else {
            if (!(statement2 instanceof PsiBlockStatement)) {
                return null;
            }
            PsiStatement[] statements = ((PsiBlockStatement)statement2).getCodeBlock().getStatements();
            if (statements.length != 2) {
                return null;
            }
            putValue = Java8MapApiInspection.extractPutValue(condition2, statements[1]);
            if (!condition2.isValueReference((PsiElement)putValue)) {
                return null;
            }
            assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
        }
        if (assignment == null) {
            return null;
        }
        PsiExpression lambdaCandidate = assignment.getRExpression();
        if (lambdaCandidate == null || !condition2.isValueReference((PsiElement)assignment.getLExpression())) {
            return null;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaCandidate)) {
            return null;
        }
        return lambdaCandidate;
    }

    @Contract(value="null, _ -> null")
    static PsiMethodCallExpression extractMapMethodCall(PsiExpression expression2, @NotNull String expectedName) {
        if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        if (!expectedName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return null;
        }
        Object[] superMethods = method2.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            superMethods = new PsiMethod[]{method2};
        }
        return ((StreamEx)StreamEx.of((Object[])superMethods).map(PsiMember::getContainingClass).nonNull()).map(PsiClass::getQualifiedName).has((Object)"java.util.Map") ? methodCallExpression : null;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static PsiExpression extractPutValue(MapCheckCondition condition2, PsiStatement statement2) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiMethodCallExpression putCall = Java8MapApiInspection.extractMapMethodCall(((PsiExpressionStatement)statement2).getExpression(), "put");
        if (putCall == null) {
            return null;
        }
        PsiExpression[] putArguments = putCall.getArgumentList().getExpressions();
        return putArguments.length == 2 && condition2.isMap((PsiElement)putCall.getMethodExpression().getQualifierExpression()) && condition2.isKey((PsiElement)putArguments[0]) ? putArguments[1] : null;
    }

    @Nullable
    @Contract(value="_, null -> null")
    static PsiMethodCallExpression tryExtractMapGetCall(PsiReferenceExpression target, PsiElement element) {
        PsiExpression lValue;
        PsiElement lastDeclaration;
        PsiDeclarationStatement declaration2;
        PsiElement[] elements;
        if (element instanceof PsiDeclarationStatement && (elements = (declaration2 = (PsiDeclarationStatement)element).getDeclaredElements()).length > 0 && (lastDeclaration = elements[elements.length - 1]) instanceof PsiLocalVariable && target.isReferenceTo(lastDeclaration)) {
            PsiLocalVariable var = (PsiLocalVariable)lastDeclaration;
            return Java8MapApiInspection.extractMapMethodCall(var.getInitializer(), "get");
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && (lValue = assignment.getLExpression()) instanceof PsiReferenceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)target, lValue)) {
            return Java8MapApiInspection.extractMapMethodCall(assignment.getRExpression(), "get");
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    static MapCheckCondition fromConditional(PsiElement conditional, boolean treatGetNullAsContainsKey) {
        if (conditional instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)conditional;
            return Java8MapApiInspection.tryExtract(ifStatement.getCondition(), (PsiStatement)ifStatement, treatGetNullAsContainsKey);
        }
        if (conditional instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)conditional;
            PsiElement parent = ternary.getParent().getParent();
            return Java8MapApiInspection.tryExtract(ternary.getCondition(), parent instanceof PsiStatement ? (PsiStatement)parent : null, treatGetNullAsContainsKey);
        }
        return null;
    }

    @Nullable
    private static MapCheckCondition tryExtract(PsiExpression fullCondition, @Nullable PsiStatement statement2, boolean treatGetNullAsContainsKey) {
        PsiMethodCallExpression call;
        PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)fullCondition);
        boolean negated = false;
        while (condition2 != null && BoolUtils.isNegation(condition2)) {
            negated ^= true;
            condition2 = BoolUtils.getNegated(condition2);
        }
        if (condition2 == null) {
            return null;
        }
        PsiReferenceExpression valueReference = null;
        boolean containsKey = false;
        if (condition2 instanceof PsiBinaryExpression) {
            negated ^= ((PsiBinaryExpression)condition2).getOperationTokenType().equals(JavaTokenType.EQEQ);
            PsiExpression value2 = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)condition2);
            if (value2 instanceof PsiReferenceExpression && statement2 != null) {
                valueReference = (PsiReferenceExpression)value2;
                PsiElement previous = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                call = Java8MapApiInspection.tryExtractMapGetCall(valueReference, previous);
            } else {
                call = Java8MapApiInspection.extractMapMethodCall(value2, "get");
            }
        } else {
            call = Java8MapApiInspection.extractMapMethodCall(condition2, "containsKey");
            containsKey = true;
        }
        if (call == null) {
            return null;
        }
        PsiExpression mapExpression = call.getMethodExpression().getQualifierExpression();
        if (mapExpression == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression keyExpression = args[0];
        return new MapCheckCondition(valueReference, mapExpression, keyExpression, fullCondition, negated, containsKey, treatGetNullAsContainsKey);
    }

    @NotNull
    static String getNameCandidate(String name) {
        if ((name = name.replaceFirst("^[_\\d]+", "")).isEmpty()) {
            return "k";
        }
        String nameCandidate = name.substring(0, 1);
        for (int pos = name.length() - 1; pos > 0; --pos) {
            if (!Character.isUpperCase(name.charAt(pos))) continue;
            if (pos == name.length() - 1) break;
            nameCandidate = name.substring(pos, pos + 1);
            break;
        }
        return nameCandidate.toLowerCase(Locale.ENGLISH);
    }

    static class MapCheckCondition {
        @Nullable
        private final PsiReferenceExpression myValueReference;
        private final PsiExpression myMapExpression;
        private final PsiExpression myKeyExpression;
        private final PsiExpression myFullCondition;
        private final boolean myNegated;
        private final boolean myContainsKey;
        private final boolean myTreatGetNullAsContainsKey;

        private MapCheckCondition(@Nullable PsiReferenceExpression valueReference, PsiExpression mapExpression, PsiExpression keyExpression, PsiExpression fullCondition, boolean negated, boolean containsKey, boolean treatGetNullAsContainsKey) {
            this.myValueReference = valueReference;
            this.myMapExpression = mapExpression;
            this.myKeyExpression = keyExpression;
            this.myFullCondition = fullCondition;
            this.myNegated = negated;
            this.myContainsKey = containsKey;
            this.myTreatGetNullAsContainsKey = treatGetNullAsContainsKey;
        }

        boolean isContainsKey() {
            return this.myContainsKey || this.myTreatGetNullAsContainsKey;
        }

        boolean isGetNull() {
            return !this.myContainsKey || this.myTreatGetNullAsContainsKey;
        }

        @Contract(value="null -> false")
        boolean isMap(PsiElement element) {
            return element != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myMapExpression, (PsiElement)element);
        }

        @Contract(value="null -> false")
        boolean isKey(PsiElement element) {
            return element != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myKeyExpression, (PsiElement)element);
        }

        PsiMethodCallExpression extractGetCall(PsiElement element) {
            if (!(element instanceof PsiExpression)) {
                return null;
            }
            PsiMethodCallExpression getCall = Java8MapApiInspection.extractMapMethodCall((PsiExpression)element, "get");
            if (getCall == null) {
                return null;
            }
            PsiExpression[] args = getCall.getArgumentList().getExpressions();
            return args.length == 1 && this.isKey((PsiElement)args[0]) && this.isMap((PsiElement)getCall.getMethodExpression().getQualifierExpression()) ? getCall : null;
        }

        @Contract(value="null -> false")
        boolean isValueReference(PsiElement element) {
            return element != null && this.myValueReference != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)this.myValueReference);
        }

        <T extends PsiElement> T getExistsBranch(T thenBranch, T elseBranch) {
            return this.myNegated ? elseBranch : thenBranch;
        }

        <T extends PsiElement> T getNoneBranch(T thenBranch, T elseBranch) {
            return this.myNegated ? thenBranch : elseBranch;
        }

        PsiVariable extractDeclaration() {
            if (this.myValueReference == null) {
                return null;
            }
            return (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)this.myKeyExpression, PsiVariable.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
        }

        boolean hasVariable() {
            if (this.myValueReference == null) {
                return false;
            }
            PsiVariable var = this.extractDeclaration();
            return var == null || ReferencesSearch.search((PsiElement)var).findAll().size() != 1;
        }

        PsiMethodCallExpression getCheckCall() {
            return (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myMapExpression, PsiMethodCallExpression.class);
        }

        public PsiExpression getFullCondition() {
            return this.myFullCondition;
        }

        public void register(ProblemsHolder holder, ReplaceWithSingleMapOperation fix) {
            holder.registerProblem((PsiElement)this.getFullCondition(), QuickFixBundle.message("java.8.map.api.inspection.description", fix.myMethodName), new LocalQuickFix[]{fix});
        }

        public boolean isMapValueType(PsiType type2) {
            PsiType mapExpressionType = this.myMapExpression.getType();
            PsiType valueTypeParameter = PsiUtil.substituteTypeParameter((PsiType)mapExpressionType, (String)"java.util.Map", (int)1, (boolean)false);
            return valueTypeParameter != null && valueTypeParameter.isAssignableFrom(type2);
        }
    }

    private static class ReplaceWithSingleMapOperation
    implements LocalQuickFix {
        private final String myMethodName;
        private final SmartPsiElementPointer<PsiMethodCallExpression> myCallPointer;
        private final SmartPsiElementPointer<PsiExpression> myValuePointer;
        private final SmartPsiElementPointer<PsiElement> myResultPointer;

        ReplaceWithSingleMapOperation(String methodName, PsiMethodCallExpression call, PsiExpression value2, PsiElement result2) {
            this.myMethodName = methodName;
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)value2.getProject());
            this.myCallPointer = manager.createSmartPsiElementPointer((PsiElement)call);
            this.myValuePointer = manager.createSmartPsiElementPointer((PsiElement)value2);
            this.myResultPointer = manager.createSmartPsiElementPointer(result2);
        }

        @NotNull
        static ReplaceWithSingleMapOperation fromIf(String methodName, MapCheckCondition condition2, PsiExpression value2) {
            PsiMethodCallExpression call = condition2.getCheckCall();
            PsiStatement result2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiStatement.class);
            LOG.assertTrue(result2 != null);
            return new ReplaceWithSingleMapOperation(methodName, call, value2, (PsiElement)result2);
        }

        @Nls
        @NotNull
        public String getName() {
            return QuickFixBundle.message("java.8.map.api.inspection.fix.text", this.myMethodName);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("java.8.map.api.inspection.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression replacement;
            PsiElement conditional = PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class});
            if (conditional == null) {
                return;
            }
            MapCheckCondition condition2 = Java8MapApiInspection.fromConditional(conditional, true);
            if (condition2 == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)this.myCallPointer.getElement();
            if (call == null) {
                return;
            }
            PsiExpressionList argsList = call.getArgumentList();
            PsiExpression[] args = argsList.getExpressions();
            if (args.length == 0) {
                return;
            }
            if (this.myMethodName.equals("merge") && args.length != 2) {
                return;
            }
            PsiExpression value2 = (PsiExpression)this.myValuePointer.getElement();
            if (value2 == null) {
                return;
            }
            PsiElement result2 = this.myResultPointer.getElement();
            if (result2 == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo(call, this.myMethodName);
            if (this.myMethodName.equals("computeIfAbsent")) {
                PsiMethod method2;
                PsiExpression key2 = args[0];
                List refs = Collections.emptyList();
                String nameCandidate = "k";
                if (key2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)key2).getQualifier() == null && (method2 = call.resolveMethod()) != null) {
                    PsiType argType = method2.getParameterList().getParameters()[0].getType();
                    PsiType mapKeyType = call.resolveMethodGenerics().getSubstitutor().substitute(argType);
                    PsiType keyType = key2.getType();
                    if (mapKeyType != null && keyType != null && keyType.isAssignableFrom(mapKeyType)) {
                        PsiElement target = ((PsiReferenceExpression)key2).resolve();
                        refs = ((StreamEx)StreamEx.of((Collection)PsiTreeUtil.collectElementsOfType((PsiElement)value2, (Class[])new Class[]{PsiReferenceExpression.class})).filter(ref -> ref.getQualifierExpression() == null && ref.isReferenceTo(target))).toList();
                        if (!refs.isEmpty()) {
                            nameCandidate = Java8MapApiInspection.getNameCandidate(((PsiReferenceExpression)key2).getReferenceName());
                        }
                    }
                }
                String varName = JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName(nameCandidate, (PsiElement)value2, true);
                for (PsiReferenceExpression ref2 : refs) {
                    ExpressionUtils.bindReferenceTo(ref2, varName);
                }
                replacement = factory.createExpressionFromText(varName + " -> " + ct.text((PsiElement)value2), (PsiElement)value2);
            } else if (this.myMethodName.equals("merge")) {
                PsiExpression absentValue = args[1];
                String aVar = JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName("a", (PsiElement)value2, true);
                String bVar = JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName("b", (PsiElement)value2, true);
                for (PsiElement e2 : PsiTreeUtil.collectElements((PsiElement)value2, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue))) {
                    ct.replace(e2, (PsiElement)factory.createIdentifier(bVar));
                }
                for (PsiElement e2 : PsiTreeUtil.collectElements((PsiElement)value2, e -> condition2.extractGetCall(e) != null || condition2.isValueReference(e))) {
                    ct.replace(e2, (PsiElement)factory.createIdentifier(aVar));
                }
                replacement = factory.createExpressionFromText("(" + aVar + "," + bVar + ") -> " + ct.text((PsiElement)value2), (PsiElement)value2);
            } else {
                replacement = ct.markUnchanged(value2);
            }
            PsiElement newArg = args.length == 2 && !this.myMethodName.equals("merge") ? ct.replace((PsiElement)args[1], (PsiElement)replacement) : argsList.add((PsiElement)replacement);
            if (newArg instanceof PsiLambdaExpression) {
                LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)newArg);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)conditional, (PsiElement)result2, (boolean)true)) {
                result2 = ct.replaceAndRestoreComments(conditional, ct.markUnchanged(result2));
            } else {
                ct.deleteAndRestoreComments(conditional);
            }
            PsiVariable variable = condition2.extractDeclaration();
            if (variable != null && !PsiTreeUtil.isAncestor((PsiElement)result2, (PsiElement)variable, (boolean)true) && ReferencesSearch.search((PsiElement)variable).findFirst() == null) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)variable);
            }
            CodeStyleManager.getInstance((Project)project2).reformat(result2);
        }
    }
}

