/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.AddJavadocIntention;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspection
extends JavaDocLocalInspectionBase {
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    protected LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        return isOnTheFly ? new AddJavadocFix(nameIdentifier) : null;
    }

    @Override
    protected LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value2, boolean isOnTheFly) {
        return new AddMissingTagFix(tag, value2);
    }

    @Override
    protected LocalQuickFix createAddMissingParamTagFix(@NotNull String name, boolean isOnTheFly) {
        return new AddMissingParamTagFix(name);
    }

    @Override
    protected LocalQuickFix createRegisterTagFix(@NotNull String tag, boolean isOnTheFly) {
        return new AddUnknownTagToCustoms(this, tag);
    }

    private static class AddUnknownTagToCustoms
    implements LocalQuickFix {
        private final JavaDocLocalInspectionBase myInspection;
        private final String myTag;

        public AddUnknownTagToCustoms(@NotNull JavaDocLocalInspectionBase inspection, @NotNull String tag) {
            this.myInspection = inspection;
            this.myTag = tag;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            this.myInspection.registerAdditionalTag(this.myTag);
            ProjectInspectionProfileManager.getInstance(project2).fireProfileChanged();
        }

        @NotNull
        public String getName() {
            return QuickFixBundle.message("add.docTag.to.custom.tags", this.myTag);
        }

        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("fix.javadoc.family", new Object[0]);
        }
    }

    private static class AddMissingParamTagFix
    extends AddMissingTagFix {
        private final String myName;

        public AddMissingParamTagFix(String name) {
            super("param", name);
            this.myName = name;
        }

        @Override
        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PsiDocComment)) {
                return null;
            }
            PsiDocComment docComment = (PsiDocComment)parent;
            PsiJavaDocumentedElement owner = docComment.getOwner();
            if (!(owner instanceof PsiMethod)) {
                return null;
            }
            Object[] parameters2 = ((PsiMethod)owner).getParameterList().getParameters();
            PsiParameter myParam = (PsiParameter)ContainerUtil.find((Object[])parameters2, psiParameter -> this.myName.equals(psiParameter.getName()));
            if (myParam == null) {
                return null;
            }
            PsiDocTag[] tags = docComment.findTagsByName("param");
            if (tags.length == 0) {
                tags = docComment.getTags();
                if (tags.length == 0) {
                    return null;
                }
                return tags[0];
            }
            PsiParameter nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (nextParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(nextParam, tag)) continue;
                    return tag;
                }
                nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextParam, PsiParameter.class);
            }
            PsiParameter prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (prevParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(prevParam, tag)) continue;
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, PsiDocTag.class);
                }
                prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevParam, PsiParameter.class);
            }
            return null;
        }

        private static boolean matches(PsiParameter param, PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            String name = param.getName();
            return valueElement != null && name != null && valueElement.getText().trim().startsWith(name);
        }

        @Override
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag", (Object[])new Object[]{this.myName});
        }
    }

    private static class AddMissingTagFix
    implements LocalQuickFix {
        private final String myTag;
        private final String myValue;

        public AddMissingTagFix(@NotNull String tag, @NotNull String value2) {
            this.myTag = tag;
            this.myValue = value2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiDocComment.class);
            if (docComment != null) {
                PsiDocTag tag = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createDocTagFromText("@" + this.myTag + " " + this.myValue);
                PsiElement anchor = this.getAnchor(descriptor);
                PsiElement addedTag = anchor != null ? docComment.addBefore((PsiElement)tag, anchor) : docComment.add((PsiElement)tag);
                AddMissingTagFix.moveCaretAfter(addedTag);
            }
        }

        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            return null;
        }

        private static void moveCaretAfter(PsiElement newCaretPosition) {
            PsiElement sibling = newCaretPosition.getNextSibling();
            if (sibling != null) {
                ((Navigatable)sibling).navigate(true);
            }
        }

        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag", (Object[])new Object[]{this.myTag, this.myValue});
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag.family", (Object[])new Object[0]);
        }
    }

    private static class AddJavadocFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final AddJavadocIntention myIntention = new AddJavadocIntention();

        public AddJavadocFix(PsiElement nameIdentifier) {
            super(nameIdentifier);
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            this.myIntention.invoke(project2, editor, startElement);
        }

        @NotNull
        public String getText() {
            return this.myIntention.getText();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return this.myIntention.getFamilyName();
        }
    }

    private class OptionsPanel
    extends JPanel {
        public OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0);
            String title = InspectionsBundle.message((String)"inspection.javadoc.dialog.title", (Object[])new Object[0]);
            FieldPanel additionalTagsPanel = new FieldPanel(InspectionsBundle.message((String)"inspection.javadoc.label.text", (Object[])new Object[0]), title, null, null);
            additionalTagsPanel.setPreferredSize(new Dimension(150, additionalTagsPanel.getPreferredSize().height));
            additionalTagsPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    try {
                        String text = document.getText(0, document.getLength());
                        if (text != null) {
                            JavaDocLocalInspection.this.myAdditionalJavadocTags = text.trim();
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getInstance(JavaDocLocalInspection.class).error((Throwable)ex);
                    }
                }
            });
            additionalTagsPanel.setText(JavaDocLocalInspection.this.myAdditionalJavadocTags);
            this.add((Component)additionalTagsPanel, gc);
            JBTabbedPane tabs = new JBTabbedPane(3);
            String[] tags = new String[]{"@author", "@version", "@since"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.package", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public"}, tags, JavaDocLocalInspection.this.PACKAGE_OPTIONS));
            tags = new String[]{"@author", "@version", "@since", "@param"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "package"}, tags, JavaDocLocalInspection.this.TOP_LEVEL_CLASS_OPTIONS));
            tags = new String[]{"@return", "@param", InspectionsBundle.message((String)"inspection.javadoc.throws.or.exception.option", (Object[])new Object[0])};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.method", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, tags, JavaDocLocalInspection.this.METHOD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.field", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.FIELD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.inner.class", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.INNER_CLASS_OPTIONS));
            this.add((Component)tabs, gc);
            JCheckBox checkBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.deprecated", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_DEPRECATED);
            checkBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_DEPRECATED = checkBox.isSelected();
            });
            gc.gridwidth = 1;
            this.add((Component)checkBox, gc);
            JCheckBox periodCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.period", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD);
            periodCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD = periodCheckBox.isSelected();
            });
            this.add((Component)periodCheckBox, gc);
            JCheckBox ignoreDuplicateThrowsCheckBox = new JCheckBox("Ignore duplicate throws tag", JavaDocLocalInspection.this.isIgnoreDuplicatedThrows());
            ignoreDuplicateThrowsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreDuplicatedThrows(ignoreDuplicateThrowsCheckBox.isSelected()));
            this.add((Component)ignoreDuplicateThrowsCheckBox, gc);
            JCheckBox ignorePointToItselfCheckBox = new JCheckBox("Ignore javadoc pointing to itself", JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF);
            ignorePointToItselfCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF = ignorePointToItselfCheckBox.isSelected();
            });
            this.add((Component)ignorePointToItselfCheckBox, gc);
            JCheckBox ignoreSimpleAccessorsCheckBox = new JCheckBox("Ignore simple property accessors", JavaDocLocalInspection.this.isIgnoreSimpleAccessors());
            ignoreSimpleAccessorsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreSimpleAccessors(ignoreSimpleAccessorsCheckBox.isSelected()));
            this.add((Component)ignoreSimpleAccessorsCheckBox, gc);
        }

        private JPanel createOptionsPanel(String[] modifiers, String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel pane = new JPanel(new GridLayout(1, tags == null ? 1 : 2));
            pane.add(this.createScopePanel(modifiers, options));
            if (tags != null) {
                pane.add(this.createTagsPanel(tags, options));
            }
            pane.validate();
            return pane;
        }

        private JPanel createScopePanel(String[] modifiers, JavaDocLocalInspectionBase.Options options) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.scope.for.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i = 0; i < modifiers.length; ++i) {
                sliderLabels.put(i + 1, new JLabel(modifiers[i]));
            }
            JSlider slider = new JSlider(1, 1, modifiers.length, 1);
            slider.setLabelTable(sliderLabels);
            slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            slider.setPreferredSize((Dimension)JBUI.size((int)80, (int)50));
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(e -> {
                int value2 = slider.getValue();
                options.ACCESS_JAVADOC_REQUIRED_FOR = modifiers[value2 - 1];
                for (Integer key2 : sliderLabels.keySet()) {
                    ((JComponent)sliderLabels.get(key2)).setForeground((Color)(key2 <= value2 ? JBColor.BLACK : Gray._100));
                }
            });
            JBColor fore = JBColor.BLACK;
            for (int i = 0; i < modifiers.length; ++i) {
                ((JComponent)sliderLabels.get(i + 1)).setForeground((Color)fore);
                if (!modifiers[i].equals(options.ACCESS_JAVADOC_REQUIRED_FOR)) continue;
                slider.setValue(i + 1);
                fore = Gray._100;
            }
            panel2.add((Component)slider, "West");
            return panel2;
        }

        private JPanel createTagsPanel(String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel panel2 = new JPanel(new GridBagLayout());
            panel2.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.javadoc.required.tags.option.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            for (int i = 0; i < tags.length; ++i) {
                JCheckBox box = new JCheckBox(tags[i]);
                gc.gridy = i;
                if (i == tags.length - 1) {
                    gc.weighty = 1.0;
                }
                panel2.add((Component)box, gc);
                box.setSelected(JavaDocLocalInspectionBase.isTagRequired(options, tags[i]));
                box.addChangeListener(new MyChangeListener(box, options, tags[i]));
            }
            return panel2;
        }

        private class MyChangeListener
        implements ChangeListener {
            private final JCheckBox myCheckBox;
            private final JavaDocLocalInspectionBase.Options myOptions;
            private final String myTagName;

            public MyChangeListener(JCheckBox checkBox, JavaDocLocalInspectionBase.Options options, String tagName) {
                this.myCheckBox = checkBox;
                this.myOptions = options;
                this.myTagName = tagName;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myCheckBox.isSelected()) {
                    if (!JavaDocLocalInspectionBase.isTagRequired(this.myOptions, this.myTagName)) {
                        this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS + this.myTagName;
                    }
                } else {
                    this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS.replaceAll(this.myTagName, "");
                }
            }
        }
    }
}

