/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericsInspectionToolBase
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file2 = holder.getFile();
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return super.buildVisitor(holder, isOnTheFly);
    }

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (initializers.length == 0) {
            return null;
        }
        ArrayList descriptors = new ArrayList();
        for (PsiClassInitializer initializer : initializers) {
            Object[] localDescriptions = this.getDescriptions((PsiElement)initializer, manager, isOnTheFly);
            if (localDescriptions == null) continue;
            ContainerUtil.addAll(descriptors, (Object[])localDescriptions);
        }
        if (descriptors.isEmpty()) {
            return null;
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            return this.getDescriptions((PsiElement)initializer, manager, isOnTheFly);
        }
        if (field instanceof PsiEnumConstant) {
            return this.getDescriptions((PsiElement)field, manager, isOnTheFly);
        }
        return null;
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiCodeBlock body2 = psiMethod.getBody();
        if (body2 != null) {
            return this.getDescriptions((PsiElement)body2, manager, isOnTheFly);
        }
        return null;
    }

    @Nullable
    public abstract ProblemDescriptor[] getDescriptions(@NotNull PsiElement var1, @NotNull InspectionManager var2, boolean var3);
}

