/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawTypeCanBeGenericInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitVariable(PsiVariable variable) {
                PsiType type2;
                super.visitVariable(variable);
                PsiTypeElement variableTypeElement = variable.getTypeElement();
                if (variableTypeElement != null && (type2 = RawTypeCanBeGenericInspection.getSuggestedType(variable)) != null) {
                    String typeText = type2.getPresentableText();
                    String message2 = InspectionsBundle.message((String)"inspection.raw.variable.type.can.be.generic.quickfix", (Object[])new Object[]{variable.getName(), typeText});
                    PsiElement beforeInitializer = PsiTreeUtil.skipSiblingsBackward((PsiElement)variable.getInitializer(), (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                    ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor((PsiElement)variableTypeElement, (PsiElement)(beforeInitializer != null ? beforeInitializer : variableTypeElement), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{new MyLocalQuickFix(message2)});
                    holder.registerProblem(descriptor);
                }
            }
        };
    }

    @Nullable
    private static PsiType getSuggestedType(@NotNull PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiType variableType = variable.getType();
        PsiType initializerType = initializer.getType();
        if (!(variableType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType variableClassType = (PsiClassType)variableType;
        if (!variableClassType.isRaw()) {
            return null;
        }
        if (!(initializerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType initializerClassType = (PsiClassType)initializerType;
        if (initializerClassType.isRaw()) {
            return null;
        }
        PsiClassType.ClassResolveResult variableResolveResult = variableClassType.resolveGenerics();
        PsiClassType.ClassResolveResult initializerResolveResult = initializerClassType.resolveGenerics();
        if (initializerResolveResult.getElement() == null) {
            return null;
        }
        PsiClass variableResolved = variableResolveResult.getElement();
        if (variableResolved == null) {
            return null;
        }
        PsiSubstitutor targetSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)variableResolved, (PsiClass)initializerResolveResult.getElement(), (PsiSubstitutor)initializerResolveResult.getSubstitutor());
        if (targetSubstitutor == null) {
            return null;
        }
        PsiClassType type2 = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory().createType(variableResolved, targetSubstitutor);
        if (variableType.equals(type2)) {
            return null;
        }
        return type2;
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private String myName;

        public MyLocalQuickFix(@NotNull String name) {
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.raw.variable.type.can.be.generic.family.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiType type2;
            PsiVariable variable;
            PsiTypeElement typeElement;
            PsiElement element = descriptor.getStartElement().getParent();
            if (element instanceof PsiVariable && (typeElement = (variable = (PsiVariable)element).getTypeElement()) != null && (type2 = RawTypeCanBeGenericInspection.getSuggestedType(variable)) != null) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
                typeElement.replace((PsiElement)factory.createTypeElement(type2));
            }
        }
    }
}

