/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import org.jetbrains.annotations.NotNull;

class ChangeNullableDefaultsFix
implements LocalQuickFix {
    private final NullableNotNullManager myManager;
    private final String myNotNullName;
    private final String myNullableName;

    public ChangeNullableDefaultsFix(PsiAnnotation notNull, PsiAnnotation nullable, NullableNotNullManager manager) {
        this.myNotNullName = notNull != null ? notNull.getQualifiedName() : null;
        this.myNullableName = nullable != null ? nullable.getQualifiedName() : null;
        this.myManager = manager;
    }

    ChangeNullableDefaultsFix(String notNull, String nullable, NullableNotNullManager manager) {
        this.myManager = manager;
        this.myNotNullName = notNull;
        this.myNullableName = nullable;
    }

    @NotNull
    public String getFamilyName() {
        return "Make \"" + (this.myNotNullName != null ? this.myNotNullName : this.myNullableName) + "\" default annotation";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (this.myNotNullName != null) {
            this.myManager.setDefaultNotNull(this.myNotNullName);
        } else {
            this.myManager.setDefaultNullable(this.myNullableName);
        }
    }
}

