/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.ChangeNullableDefaultsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableStuffInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean IGNORE_EXTERNAL_SUPER_NOTNULL;
    public boolean REQUIRE_NOTNULL_FIELDS_INITIALIZED = true;
    public boolean REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.nullable.NullableStuffInspectionBase");

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name = child.getAttributeValue("name");
            String value2 = child.getAttributeValue("value");
            if (!("IGNORE_EXTERNAL_SUPER_NOTNULL".equals(name) && "false".equals(value2) || "REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED".equals(name) && "false".equals(value2) || "REQUIRE_NOTNULL_FIELDS_INITIALIZED".equals(name) && "true".equals(value2)) && (!"REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER".equals(name) || !"true".equals(value2))) continue;
            node.removeContent((Content)child);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file2 = holder.getFile();
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2) || NullableStuffInspectionBase.nullabilityAnnotationsNotAvailable(file2)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method2) {
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method2, holder, isOnTheFly);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                NullableStuffInspectionBase.this.checkMethodReference(expression2, holder);
            }

            public void visitField(PsiField field) {
                PsiType type2 = field.getType();
                Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)field, holder, type2);
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2)) {
                    return;
                }
                Project project2 = holder.getProject();
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    String anno = annotated.isDeclaredNotNull ? manager.getDefaultNotNull() : manager.getDefaultNullable();
                    List annoToRemove = annotated.isDeclaredNotNull ? manager.getNullables() : manager.getNotNulls();
                    NullableStuffInspectionBase.this.checkAccessors(field, annotated, project2, manager, anno, annoToRemove, holder);
                    NullableStuffInspectionBase.this.checkConstructorParameters(field, annotated, manager, anno, annoToRemove, holder);
                }
                if (NullableStuffInspectionBase.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED && !annotated.isDeclaredNullable) {
                    NullableStuffInspectionBase.checkNotNullFieldsInitialized(field, manager, holder);
                }
            }

            public void visitParameter(PsiParameter parameter) {
                NullableStuffInspectionBase.check((PsiModifierListOwner)parameter, holder, parameter.getType());
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                if (!"org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiAnnotationMemberValue value2 = annotation.findDeclaredAttributeValue("exception");
                if (value2 instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiClassObjectAccessExpression)value2).getOperand().getType())) != null && !this.hasStringConstructor(psiClass)) {
                    holder.registerProblem((PsiElement)value2, "Custom exception class should have a constructor with a single message parameter of String type", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean hasStringConstructor(PsiClass aClass) {
                for (PsiMethod method2 : aClass.getConstructors()) {
                    PsiParameterList list = method2.getParameterList();
                    if (list.getParametersCount() != 1 || !list.getParameters()[0].getType().equalsToText("java.lang.String")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private void checkMethodReference(PsiMethodReferenceExpression expression2, @NotNull ProblemsHolder holder) {
        PsiMethod superMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression2);
        PsiMethod targetMethod = (PsiMethod)ObjectUtils.tryCast((Object)expression2.resolve(), PsiMethod.class);
        if (superMethod == null || targetMethod == null) {
            return;
        }
        PsiElement refName = expression2.getReferenceNameElement();
        assert (refName != null);
        if (this.isNullableOverridingNotNull(NullableStuffInspectionBase.check((PsiModifierListOwner)targetMethod, holder, expression2.getType()), superMethod)) {
            holder.registerProblem(refName, InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)targetMethod), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (this.isNonAnnotatedOverridingNotNull(targetMethod, superMethod)) {
            holder.registerProblem(refName, "Not annotated method is used as an override for a method annotated with " + NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createFixForNonAnnotatedOverridesNotNull(targetMethod, superMethod)});
        }
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private static boolean nullabilityAnnotationsNotAvailable(PsiFile file2) {
        Project project2 = file2.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        return ContainerUtil.find((Iterable)NullableNotNullManager.getInstance((Project)project2).getNullables(), s -> facade.findClass(s, scope) != null) == null;
    }

    private static boolean checkNonStandardAnnotations(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, @NotNull ProblemsHolder holder) {
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)field, (String)anno)) {
            PsiAnnotation annotation;
            PsiAnnotation notNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNotNulls());
            PsiAnnotation nullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNullables());
            String message2 = "Not '";
            if (annotated.isDeclaredNullable) {
                message2 = message2 + nullable.getQualifiedName();
                annotation = nullable;
            } else {
                message2 = message2 + notNull.getQualifiedName();
                annotation = notNull;
            }
            message2 = message2 + "' but '" + anno + "' would be used for code generation.";
            PsiJavaCodeReferenceElement annotationNameReferenceElement = annotation.getNameReferenceElement();
            holder.registerProblem((PsiElement)(annotationNameReferenceElement != null && annotationNameReferenceElement.isPhysical() ? annotationNameReferenceElement : field.getNameIdentifier()), message2, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeNullableDefaultsFix(notNull, nullable, manager)});
            return false;
        }
        return true;
    }

    private void checkAccessors(PsiField field, Annotated annotated, Project project2, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod setter;
        PsiIdentifier nameIdentifier;
        String propName = JavaCodeStyleManager.getInstance((Project)project2).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false);
        PsiIdentifier psiIdentifier = nameIdentifier = getter == null ? null : getter.getNameIdentifier();
        if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.isSimpleGetter((PsiMethod)getter)) {
            AnnotateMethodFix getterAnnoFix = new AnnotateMethodFix(anno, ArrayUtil.toStringArray(annoToRemove)){

                @Override
                public int shouldAnnotateBaseMethod(PsiMethod method2, PsiMethod superMethod, Project project2) {
                    return 1;
                }
            };
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)getter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)getter.getReturnType())) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
            if (annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)getter, false) || annotated.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)getter, false, false)) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)getter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
        }
        if ((setter = PropertyUtil.findPropertySetter((PsiClass)(containingClass = field.getContainingClass()), (String)propName, (boolean)isStatic, (boolean)false)) != null && setter.isPhysical()) {
            PsiIdentifier nameIdentifier1;
            PsiParameter[] parameters2 = setter.getParameterList().getParameters();
            assert (parameters2.length == 1) : setter.getText();
            PsiParameter parameter = parameters2[0];
            LOG.assertTrue(parameter != null, (Object)setter.getText());
            AddAnnotationPsiFix addAnnoFix = NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter);
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
            if (PropertyUtil.isSimpleSetter((PsiMethod)setter) && annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false)) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
        }
    }

    @NotNull
    private static AddAnnotationPsiFix createAddAnnotationFix(String anno, List<String> annoToRemove, PsiParameter parameter) {
        return new AddAnnotationPsiFix(anno, (PsiModifierListOwner)parameter, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray(annoToRemove));
    }

    private static void assertValidElement(PsiMethod setter, PsiParameter parameter, PsiIdentifier nameIdentifier1) {
        LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), (Object)setter.getText());
        LOG.assertTrue(parameter.isPhysical(), (Object)setter.getText());
    }

    private static void checkNotNullFieldsInitialized(PsiField field, NullableNotNullManager manager, @NotNull ProblemsHolder holder) {
        PsiAnnotation annotation = manager.getNotNullAnnotation((PsiModifierListOwner)field, false);
        if (annotation == null || HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return;
        }
        boolean byDefault = manager.isContainerAnnotation(annotation);
        PsiJavaCodeReferenceElement name = annotation.getNameReferenceElement();
        holder.registerProblem((PsiElement)(annotation.isPhysical() && !byDefault ? annotation : field.getNameIdentifier()), (byDefault && name != null ? "@" + name.getReferenceName() : "Not-null") + " fields must be initialized", new LocalQuickFix[0]);
    }

    private void checkConstructorParameters(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
        if (initializers.isEmpty()) {
            return;
        }
        ArrayList notNullParams = ContainerUtil.newArrayList();
        boolean isFinal = field.hasModifierProperty("final");
        for (PsiExpression rhs : initializers) {
            PsiIdentifier nameIdentifier;
            PsiElement target;
            if (!(rhs instanceof PsiReferenceExpression) || !NullableStuffInspectionBase.isConstructorParameter(target = ((PsiReferenceExpression)rhs).resolve()) || !target.isPhysical()) continue;
            PsiParameter parameter = (PsiParameter)target;
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType()) && (nameIdentifier = parameter.getNameIdentifier()) != null && nameIdentifier.isPhysical()) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter)});
                continue;
            }
            if (!isFinal || !annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) continue;
            notNullParams.add(parameter);
        }
        if (notNullParams.size() != initializers.size()) {
            return;
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        if (nameIdentifier.isPhysical()) {
            holder.registerProblem((PsiElement)nameIdentifier, "@" + NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field) + " field is always initialized not-null", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddNotNullAnnotationFix((PsiModifierListOwner)field)});
        }
    }

    private static boolean isConstructorParameter(@Nullable PsiElement parameter) {
        return parameter instanceof PsiParameter && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true))).accepts((Object)parameter.getParent());
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        HashSet names = ContainerUtil.newHashSet((Iterable)manager.getNullables());
        names.addAll(manager.getNotNulls());
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)owner, (Set)names);
        if (annotation != null) {
            return NullableStuffInspectionBase.getPresentableAnnoName(annotation);
        }
        String anno = manager.getNotNull(owner);
        return StringUtil.getShortName((String)(anno != null ? anno : StringUtil.notNullize((String)manager.getNullable(owner), (String)"???")));
    }

    public static String getPresentableAnnoName(@NotNull PsiAnnotation annotation) {
        return StringUtil.getShortName((String)StringUtil.notNullize((String)annotation.getQualifiedName(), (String)"???"));
    }

    private static Annotated check(PsiModifierListOwner parameter, ProblemsHolder holder, PsiType type2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)holder.getProject());
        PsiAnnotation isDeclaredNotNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNotNulls());
        PsiAnnotation isDeclaredNullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNullables());
        if (isDeclaredNullable != null && isDeclaredNotNull != null) {
            NullableStuffInspectionBase.reportNullableNotNullConflict(holder, parameter, isDeclaredNullable, isDeclaredNotNull);
        }
        if ((isDeclaredNotNull != null || isDeclaredNullable != null) && type2 != null && TypeConversionUtil.isPrimitive((String)type2.getCanonicalText())) {
            PsiAnnotation annotation = isDeclaredNotNull == null ? isDeclaredNullable : isDeclaredNotNull;
            NullableStuffInspectionBase.reportPrimitiveType(holder, (PsiElement)annotation, annotation, parameter);
        }
        return new Annotated(isDeclaredNotNull != null, isDeclaredNullable != null);
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiElement psiElement, PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        holder.registerProblem(psiElement.isPhysical() ? psiElement : listOwner.getNavigationElement(), InspectionsBundle.message((String)"inspection.nullable.problems.primitive.type.annotation", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, listOwner)});
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.nullable.problems.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.BUGS_GROUP_NAME;
    }

    @NotNull
    public String getShortName() {
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method2, ProblemsHolder holder, boolean isOnFly) {
        Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)method2, holder, method2.getReturnType());
        List superMethods = ContainerUtil.map((Collection)method2.findSuperMethodSignaturesIncludingStatic(true), signature -> signature.getMethod());
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance((Project)holder.getProject());
        this.checkSupers(method2, holder, annotated, superMethods);
        this.checkParameters(method2, holder, superMethods, nullableManager, isOnFly);
        this.checkOverriders(method2, holder, annotated, nullableManager);
    }

    private void checkSupers(PsiMethod method2, ProblemsHolder holder, Annotated annotated, List<PsiMethod> superMethods) {
        for (PsiMethod superMethod : superMethods) {
            if (this.isNullableOverridingNotNull(annotated, superMethod)) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method2, (Collection)this.getNullityManager(method2).getNullables(), (boolean)true);
                holder.registerProblem((PsiElement)(annotation != null ? annotation : method2.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)method2), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                break;
            }
            if (!this.isNonAnnotatedOverridingNotNull(method2, superMethod)) continue;
            holder.registerProblem((PsiElement)method2.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createFixForNonAnnotatedOverridesNotNull(method2, superMethod)});
            break;
        }
    }

    private NullableNotNullManager getNullityManager(PsiMethod method2) {
        return NullableNotNullManager.getInstance((Project)method2.getProject());
    }

    private LocalQuickFix createFixForNonAnnotatedOverridesNotNull(PsiMethod method2, PsiMethod superMethod) {
        NullableNotNullManager nullableManager = this.getNullityManager(method2);
        String defaultNotNull = nullableManager.getDefaultNotNull();
        String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
        return AnnotationUtil.isAnnotatingApplicable((PsiElement)method2, (String)defaultNotNull) ? this.createAnnotateMethodFix(defaultNotNull, annotationsToRemove) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superMethod);
    }

    private boolean isNullableOverridingNotNull(Annotated methodInfo, PsiMethod superMethod) {
        return this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && methodInfo.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, false);
    }

    private boolean isNonAnnotatedOverridingNotNull(PsiMethod method2, PsiMethod superMethod) {
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !(method2.getReturnType() instanceof PsiPrimitiveType) && !method2.isConstructor() && !this.getNullityManager(method2).hasNullability((PsiModifierListOwner)method2) && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)superMethod);
    }

    private static boolean hasInheritableNotNull(PsiModifierListOwner owner) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"javax.annotation.constraints.NotNull", (boolean)true);
    }

    private void checkParameters(PsiMethod method2, ProblemsHolder holder, List<PsiMethod> superMethods, NullableNotNullManager nullableManager, boolean isOnFly) {
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter parameter = parameters2[i2];
            ArrayList superParameters = ContainerUtil.newArrayList();
            for (PsiMethod superMethod : superMethods) {
                PsiParameter[] _superParameters = superMethod.getParameterList().getParameters();
                if (_superParameters.length != parameters2.length) continue;
                superParameters.add(_superParameters[i2]);
            }
            if (this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE) {
                for (PsiParameter superParameter : superParameters) {
                    if (!NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)superParameter, false)) continue;
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)nullableManager.getNotNulls(), (boolean)true);
                    holder.registerProblem((PsiElement)(annotation != null ? annotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.Nullable", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    break;
                }
            }
            if (this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability((PsiModifierListOwner)parameter) || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superParameter, false, this.IGNORE_EXTERNAL_SUPER_NOTNULL) || NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)superParameter)) continue;
                    AddNotNullAnnotationFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter, (String)nullableManager.getDefaultNotNull()) ? new AddNotNullAnnotationFix((PsiModifierListOwner)parameter) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superParameter);
                    holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.parameter.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                    break;
                }
            }
            if (this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability((PsiModifierListOwner)superParameter) || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) continue;
                    PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation((PsiModifierListOwner)parameter, false);
                    assert (notNullAnnotation != null);
                    boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)notNullAnnotation, (boolean)true);
                    RemoveAnnotationQuickFix fix = physical ? new RemoveAnnotationQuickFix(notNullAnnotation, (PsiModifierListOwner)parameter) : null;
                    holder.registerProblem((PsiElement)(physical ? notNullAnnotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                    break;
                }
            }
            this.checkNullLiteralArgumentOfNotNullParameterUsages(method2, holder, nullableManager, isOnFly, i2, parameter);
        }
    }

    private void checkNullLiteralArgumentOfNotNullParameterUsages(PsiMethod method2, ProblemsHolder holder, NullableNotNullManager nullableManager, boolean isOnFly, int parameterIdx, PsiParameter parameter) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && isOnFly && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) {
            PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation((PsiModifierListOwner)parameter, false);
            if (JavaNullMethodArgumentUtil.hasNullArgument(method2, parameterIdx)) {
                boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)notNullAnnotation, (boolean)true);
                holder.registerProblem((PsiElement)(physical ? notNullAnnotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.receives.null.literal", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createNavigateToNullParameterUsagesFix(parameter)});
            }
        }
    }

    private void checkOverriders(PsiMethod method2, ProblemsHolder holder, Annotated annotated, NullableNotNullManager nullableManager) {
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean[] parameterAnnotated = new boolean[parameters2.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters2.length];
            boolean hasAnnotatedParameter = false;
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiParameter parameter = parameters2[i2];
                parameterAnnotated[i2] = NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)parameter);
                hasAnnotatedParameter |= parameterAnnotated[i2];
            }
            if (hasAnnotatedParameter || annotated.isDeclaredNotNull && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)method2)) {
                PsiManager manager = method2.getManager();
                String defaultNotNull = nullableManager.getDefaultNotNull();
                boolean superMethodApplicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)method2, (String)defaultNotNull);
                PsiMethod[] overridings = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method2).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    if (!manager.isInProject((PsiElement)overriding)) continue;
                    boolean applicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)overriding, (String)defaultNotNull);
                    if (!(methodQuickFixSuggested || !annotated.isDeclaredNotNull || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)overriding, false, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, false) && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, true))) {
                        method2.getNameIdentifier();
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method2, (Collection)nullableManager.getNotNulls());
                        String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
                        LocalQuickFix fix = applicable ? new MyAnnotateMethodFix(defaultNotNull, annotationsToRemove) : (superMethodApplicable ? null : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)method2));
                        PsiAnnotation psiElement = annotation;
                        if (!annotation.isPhysical() && (psiElement = method2.getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.methods.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i3 = 0; i3 < psiParameters.length; ++i3) {
                        PsiAnnotation annotation;
                        if (parameterQuickFixSuggested[i3]) continue;
                        PsiParameter parameter = psiParameters[i3];
                        if (!parameterAnnotated[i3] || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) || NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false)) continue;
                        parameters2[i3].getNameIdentifier();
                        PsiAnnotation psiElement = annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameters2[i3], (Collection)nullableManager.getNotNulls());
                        if ((annotation == null || !annotation.isPhysical()) && (psiElement = parameters2[i3].getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.method.parameters.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{!applicable ? NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)parameters2[i3]) : new AnnotateOverriddenMethodParameterFix(defaultNotNull, nullableManager.getDefaultNullable())});
                        parameterQuickFixSuggested[i3] = true;
                    }
                }
            }
        }
    }

    private static boolean isNotNullNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal) {
        Project project2 = owner.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (!manager.isNotNull(owner, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNotNullAnnotation(owner, checkBases);
        if (anno == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) {
            return false;
        }
        return !skipExternal || !AnnotationUtil.isExternalAnnotation((PsiAnnotation)anno);
    }

    public static boolean isNullableNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        Project project2 = owner.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (!manager.isNullable(owner, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNullableAnnotation(owner, checkBases);
        return anno == null || !AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno);
    }

    private static LocalQuickFix createChangeDefaultNotNullFix(NullableNotNullManager nullableManager, PsiModifierListOwner modifierListOwner) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (Collection)nullableManager.getNotNulls());
        if (annotation != null && (referenceElement = annotation.getNameReferenceElement()) != null && referenceElement.resolve() != null) {
            return new ChangeNullableDefaultsFix(annotation.getQualifiedName(), null, nullableManager);
        }
        return null;
    }

    protected AnnotateMethodFix createAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
        return new AnnotateMethodFix(defaultNotNull, annotationsToRemove);
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        String bothNullableNotNullMessage = InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.NotNull.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName(declaredNullable), NullableStuffInspectionBase.getPresentableAnnoName(declaredNotNull)});
        holder.registerProblem((PsiElement)(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNotNull, listOwner)});
        holder.registerProblem((PsiElement)(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNullable, listOwner)});
    }

    public JComponent createOptionsPanel() {
        throw new RuntimeException("No UI in headless mode");
    }

    private static class MyAnnotateMethodFix
    extends AnnotateMethodFix {
        public MyAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
            super(defaultNotNull, annotationsToRemove);
        }

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        public int shouldAnnotateBaseMethod(PsiMethod method2, PsiMethod superMethod, Project project2) {
            return 1;
        }

        @Override
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"annotate.overridden.methods.as.notnull", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;

        private Annotated(boolean isDeclaredNotNull, boolean isDeclaredNullable) {
            this.isDeclaredNotNull = isDeclaredNotNull;
            this.isDeclaredNullable = isDeclaredNullable;
        }
    }
}

