/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OfflineDescriptorResolveResult {
    private RefEntity myResolvedEntity;
    private CommonProblemDescriptor myResolvedDescriptor;

    public OfflineDescriptorResolveResult(RefEntity resolvedEntity, CommonProblemDescriptor resolvedDescriptor) {
        this.myResolvedEntity = resolvedEntity;
        this.myResolvedDescriptor = resolvedDescriptor;
    }

    @Nullable
    public RefEntity getResolvedEntity() {
        return this.myResolvedEntity;
    }

    @Nullable
    public CommonProblemDescriptor getResolvedDescriptor() {
        return this.myResolvedDescriptor;
    }

    @NotNull
    static OfflineDescriptorResolveResult resolve(@NotNull OfflineProblemDescriptor descriptor, @NotNull InspectionToolWrapper wrapper, @NotNull InspectionToolPresentation presentation) {
        RefEntity element = descriptor.getRefElement(presentation.getContext().getRefManager());
        CommonProblemDescriptor resolvedDescriptor = (CommonProblemDescriptor)ReadAction.compute(() -> OfflineDescriptorResolveResult.createDescriptor(element, descriptor, wrapper, presentation));
        return new OfflineDescriptorResolveResult(element, resolvedDescriptor);
    }

    @Nullable
    private static CommonProblemDescriptor createDescriptor(@Nullable RefEntity element, @NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            CommonProblemDescriptor descriptor;
            LocalInspectionToolWrapper localTool = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
            if (localTool != null && (descriptor = OfflineDescriptorResolveResult.createDescriptor(element, offlineDescriptor, localTool, presentation)) != null) {
                return descriptor;
            }
            return OfflineDescriptorResolveResult.createRerunGlobalToolDescriptor((GlobalInspectionToolWrapper)toolWrapper, element);
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)presentation.getContext().getProject());
        OfflineProblemDescriptor offlineProblemDescriptor = offlineDescriptor;
        if (element instanceof RefElement) {
            ProblemDescriptor descriptor;
            PsiElement psiElement = ((RefElement)element).getElement();
            if (psiElement != null && (descriptor = (ProblemDescriptor)ProgressManager.getInstance().runProcess(() -> OfflineDescriptorResolveResult.runLocalTool(psiElement, inspectionManager, offlineProblemDescriptor, (LocalInspectionToolWrapper)toolWrapper), (ProgressIndicator)new DaemonProgressIndicator())) != null) {
                return descriptor;
            }
            return null;
        }
        List hints = offlineProblemDescriptor.getHints();
        CommonProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), new QuickFix[]{null});
        LocalQuickFix[] quickFixes = OfflineDescriptorResolveResult.getFixes(descriptor, hints, presentation);
        if (quickFixes != null) {
            descriptor = inspectionManager.createProblemDescriptor(offlineProblemDescriptor.getDescription(), (QuickFix[])quickFixes);
        }
        return descriptor;
    }

    private static ProblemDescriptor runLocalTool(@NotNull PsiElement psiElement, @NotNull InspectionManager inspectionManager, @NotNull OfflineProblemDescriptor offlineProblemDescriptor, @NotNull LocalInspectionToolWrapper toolWrapper) {
        PsiElement[] elementsInRange;
        PsiFile containingFile = psiElement.getContainingFile();
        ProblemsHolder holder = new ProblemsHolder(inspectionManager, containingFile, false);
        LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
        int startOffset = psiElement.getTextRange().getStartOffset();
        int endOffset = psiElement.getTextRange().getEndOffset();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(containingFile, startOffset, endOffset);
        PsiElementVisitor visitor = localTool.buildVisitor(holder, false, session2);
        localTool.inspectionStarted(session2, false);
        for (PsiElement element : elementsInRange = OfflineDescriptorResolveResult.getElementsIntersectingRange(containingFile, startOffset, endOffset)) {
            element.accept(visitor);
        }
        localTool.inspectionFinished(session2, holder);
        if (holder.hasResults()) {
            List list = holder.getResults();
            int idx = offlineProblemDescriptor.getProblemIndex();
            int curIdx = 0;
            for (ProblemDescriptor descriptor : list) {
                PsiNamedElement member = localTool.getProblemElement(descriptor.getPsiElement());
                if (!(psiElement instanceof PsiFile) && (member == null || !member.equals(psiElement))) continue;
                if (curIdx == idx) {
                    return descriptor;
                }
                ++curIdx;
            }
        }
        return null;
    }

    private static PsiElement[] getElementsIntersectingRange(PsiFile file2, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file2.getViewProvider();
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            result2.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        return PsiUtilCore.toPsiElementArray(result2);
    }

    @Nullable
    private static LocalQuickFix[] getFixes(@NotNull CommonProblemDescriptor descriptor, List<String> hints, InspectionToolPresentation presentation) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(hints == null ? 1 : hints.size());
        if (hints == null) {
            OfflineDescriptorResolveResult.addFix(descriptor, fixes, null, presentation);
        } else {
            for (String hint : hints) {
                OfflineDescriptorResolveResult.addFix(descriptor, fixes, hint, presentation);
            }
        }
        return fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    private static void addFix(@NotNull CommonProblemDescriptor descriptor, List<LocalQuickFix> fixes, String hint, InspectionToolPresentation presentation) {
        IntentionAction intentionAction = presentation.findQuickFixes(descriptor, hint);
        if (intentionAction instanceof QuickFixWrapper) {
            fixes.add(((QuickFixWrapper)intentionAction).getFix());
        }
    }

    private static CommonProblemDescriptor createRerunGlobalToolDescriptor(final @NotNull GlobalInspectionToolWrapper wrapper, final @Nullable RefEntity entity) {
        return new CommonProblemDescriptorImpl(new QuickFix[]{new QuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                return "Rerun '" + wrapper.getDisplayName() + "' inspection";
            }

            public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor) {
                VirtualFile file2 = null;
                if (entity != null && entity.isValid() && entity instanceof RefElement) {
                    file2 = ((RefElement)entity).getPointer().getVirtualFile();
                }
                PsiFile psiFile = null;
                if (file2 != null) {
                    psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
                }
                RunInspectionAction.runInspection(project2, wrapper.getShortName(), file2, null, psiFile);
            }
        }}, "Problem detected by global inspection '" + wrapper.getDisplayName() + "'");
    }
}

