/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineInspectionRVContentProvider
extends InspectionRVContentProvider {
    private final Map<String, Map<String, Set<OfflineProblemDescriptor>>> myContent;
    private final Map<String, Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult>> myResolvedDescriptor = new FactoryMap<String, Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult>>(){

        @Nullable
        protected Map<OfflineProblemDescriptor, OfflineDescriptorResolveResult> create(String key2) {
            return new THashMap();
        }
    };

    public OfflineInspectionRVContentProvider(@NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> content, @NotNull Project project2) {
        super(project2);
        this.myContent = content;
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        Map<String, Set<OfflineProblemDescriptor>> content = this.getFilteredContent(context, toolWrapper);
        return content != null && !content.values().isEmpty();
    }

    @Override
    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return Collections.singletonList(tools.getDefaultState());
    }

    @Override
    @Nullable
    public QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            return QuickFixAction.EMPTY;
        }
        ArrayList selectedElements = new ArrayList();
        HashMap<RefEntity, CommonProblemDescriptor[]> actions = new HashMap<RefEntity, CommonProblemDescriptor[]>();
        for (TreePath selectionPath : treePaths) {
            TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), node -> {
                if (!((InspectionTreeNode)node).isValid()) {
                    return true;
                }
                if (node instanceof OfflineProblemDescriptorNode) {
                    CommonProblemDescriptor[] commonProblemDescriptorArray;
                    if (((OfflineProblemDescriptorNode)node).isQuickFixAppliedFromView()) {
                        return true;
                    }
                    OfflineProblemDescriptorNode descriptorNode = (OfflineProblemDescriptorNode)node;
                    RefEntity element = descriptorNode.getElement();
                    selectedElements.add(element);
                    CommonProblemDescriptor[] descriptors = (CommonProblemDescriptor[])actions.get(element);
                    CommonProblemDescriptor descriptor = descriptorNode.getDescriptor();
                    if (descriptor == null) {
                        commonProblemDescriptorArray = CommonProblemDescriptor.EMPTY_ARRAY;
                    } else {
                        CommonProblemDescriptor[] commonProblemDescriptorArray2 = new CommonProblemDescriptor[1];
                        commonProblemDescriptorArray = commonProblemDescriptorArray2;
                        commonProblemDescriptorArray2[0] = descriptor;
                    }
                    CommonProblemDescriptor[] descriptorAsArray = commonProblemDescriptorArray;
                    actions.put(element, descriptors == null ? descriptorAsArray : DefaultInspectionToolPresentation.mergeDescriptors(descriptors, descriptorAsArray));
                } else if (node instanceof RefElementNode) {
                    selectedElements.add(((RefElementNode)node).getElement());
                }
                return true;
            });
        }
        if (selectedElements.isEmpty()) {
            return null;
        }
        RefEntity[] selectedRefElements = selectedElements.toArray(new RefEntity[selectedElements.size()]);
        GlobalInspectionContextImpl context = tree.getContext();
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        return presentation.extractActiveFixes(selectedRefElements, actions, tree.getSelectedDescriptors());
    }

    @Override
    public boolean isContentLoaded() {
        return false;
    }

    @Override
    public InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Map<RefEntity, CommonProblemDescriptor[]> problems) {
        InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
        Map filteredContent = this.getFilteredContent(context, toolWrapper);
        if (filteredContent != null && !filteredContent.values().isEmpty()) {
            parentNode.insertByOrder(toolNode, false);
            this.buildTree(context, filteredContent, false, toolWrapper, descriptor -> {
                RefEntity element = descriptor.getRefElement(context.getRefManager());
                return new InspectionRVContentProvider.RefEntityContainer<OfflineProblemDescriptor>(element, new OfflineProblemDescriptor[]{descriptor}){

                    @Override
                    @Nullable
                    public String getModule() {
                        String module2 = super.getModule();
                        return module2 == null ? descriptor.getModuleName() : module2;
                    }
                };
            }, showStructure, newChild -> {
                toolNode.insertByOrder((InspectionTreeNode)newChild, false);
                return newChild;
            });
        }
        return toolNode;
    }

    @Nullable
    private Map<String, Set<OfflineProblemDescriptor>> getFilteredContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        Map<String, Set<OfflineProblemDescriptor>> content = this.myContent.get(toolWrapper.getShortName());
        if (content == null) {
            return null;
        }
        if (context.getUIOptions().FILTER_RESOLVED_ITEMS) {
            HashMap<String, Set<OfflineProblemDescriptor>> current = new HashMap<String, Set<OfflineProblemDescriptor>>(content);
            content = null;
            InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
            for (RefEntity refEntity : presentation.getIgnoredRefElements()) {
                if (!(refEntity instanceof RefElement)) continue;
                OfflineInspectionRVContentProvider.excludeProblem(refEntity.getExternalName(), current);
            }
            return current;
        }
        return content;
    }

    private static void excludeProblem(String externalName, Map<String, Set<OfflineProblemDescriptor>> content) {
        Iterator<String> iter = content.keySet().iterator();
        while (iter.hasNext()) {
            String packageName = iter.next();
            HashSet excluded = new HashSet((Collection)content.get(packageName));
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                OfflineProblemDescriptor ex = (OfflineProblemDescriptor)it.next();
                if (!Comparing.strEqual((String)ex.getFQName(), (String)externalName)) continue;
                it.remove();
            }
            if (excluded.isEmpty()) {
                iter.remove();
                continue;
            }
            content.put(packageName, (Set<OfflineProblemDescriptor>)excluded);
        }
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.RefEntityContainer container, @NotNull InspectionTreeNode packageNode, boolean canPackageRepeat) {
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        RefElementNode elemNode = OfflineInspectionRVContentProvider.addNodeToParent(container, presentation, packageNode);
        for (OfflineProblemDescriptor descriptor : (OfflineProblemDescriptor[])container.getDescriptors()) {
            OfflineDescriptorResolveResult resolveResult = this.myResolvedDescriptor.get(toolWrapper.getShortName()).computeIfAbsent(descriptor, d -> OfflineDescriptorResolveResult.resolve(d, toolWrapper, presentation));
            elemNode.insertByOrder((InspectionTreeNode)ReadAction.compute(() -> OfflineProblemDescriptorNode.create(descriptor, resolveResult, toolWrapper, presentation)), true);
        }
    }
}

