/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import org.jetbrains.annotations.NotNull;

public class OfflineProblemDescriptorNode
extends ProblemDescriptionNode {
    private OfflineProblemDescriptorNode(RefEntity refEntity, CommonProblemDescriptor descriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation, @NotNull OfflineProblemDescriptor offlineDescriptor) {
        super(refEntity, descriptor, toolWrapper, presentation, false, () -> ((OfflineProblemDescriptor)offlineDescriptor).getLine());
        if (descriptor == null) {
            this.setUserObject(offlineDescriptor);
        }
        this.init(presentation.getContext().getProject());
    }

    static OfflineProblemDescriptorNode create(@NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull OfflineDescriptorResolveResult resolveResult, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        return new OfflineProblemDescriptorNode(resolveResult.getResolvedEntity(), resolveResult.getResolvedDescriptor(), toolWrapper, presentation, offlineDescriptor);
    }

    @Override
    public FileStatus getNodeStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        String presentableName = super.calculatePresentableName();
        return presentableName.isEmpty() && this.getUserObject() instanceof OfflineProblemDescriptor ? StringUtil.notNullize((String)((OfflineProblemDescriptor)this.getUserObject()).getDescription()) : presentableName;
    }

    @Override
    protected boolean calculateIsValid() {
        boolean isValid = super.calculateIsValid();
        if (!isValid && this.getDescriptor() == null && !(this.myToolWrapper instanceof LocalInspectionToolWrapper)) {
            isValid = this.myElement != null && this.myElement.isValid();
        }
        return isValid;
    }
}

