/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefDirectoryImpl
extends RefElementImpl
implements RefDirectory {
    private RefModule myRefModule;

    protected RefDirectoryImpl(PsiDirectory psiElement, RefManager refManager) {
        super(psiElement.getName(), (PsiElement)psiElement, refManager);
        RefElementImpl refElement;
        PsiDirectory parentDirectory = psiElement.getParentDirectory();
        if (parentDirectory != null && parentDirectory.getManager().isInProject((PsiElement)parentDirectory) && (refElement = (RefElementImpl)refManager.getReference((PsiElement)parentDirectory)) != null) {
            refElement.add(this);
            return;
        }
        this.myRefModule = refManager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
        if (this.myRefModule != null) {
            ((RefModuleImpl)this.myRefModule).add(this);
            return;
        }
        ((RefProjectImpl)refManager.getRefProject()).add(this);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        ApplicationManager.getApplication().runReadAction(() -> visitor.visitDirectory((RefDirectory)this));
    }

    @Override
    public boolean isValid() {
        if (this.isDeleted()) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.getRefManager().getProject().isDisposed()) {
                return false;
            }
            VirtualFile directory = this.getVirtualFile();
            return directory != null && directory.isValid();
        });
    }

    @Override
    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    @Override
    protected void initialize() {
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getExternalName() {
        PsiElement element = this.getElement();
        assert (element != null);
        return ((PsiDirectory)element).getVirtualFile().getPath();
    }
}

