/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefImplicitConstructorImpl
extends RefMethodImpl
implements RefImplicitConstructor {
    private final RefClass myOwnerClass;

    RefImplicitConstructorImpl(@NotNull RefClass ownerClass) {
        super(InspectionsBundle.message((String)"inspection.reference.implicit.constructor.name", (Object[])new Object[]{ownerClass.getName()}), ownerClass);
        this.myOwnerClass = ownerClass;
    }

    @Override
    public void buildReferences() {
        this.getRefManager().fireBuildReferences(this);
    }

    @Override
    public boolean isSuspicious() {
        return ((RefClassImpl)this.getOwnerClass()).isSuspicious();
    }

    @Override
    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"inspection.reference.implicit.constructor.name", (Object[])new Object[]{this.getOwnerClass().getName()});
    }

    @Override
    public String getExternalName() {
        return this.getOwnerClass().getExternalName();
    }

    @Override
    public boolean isValid() {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return RefImplicitConstructorImpl.this.getOwnerClass().isValid();
            }
        });
    }

    @Override
    public String getAccessModifier() {
        return this.getOwnerClass().getAccessModifier();
    }

    @Override
    public void setAccessModifier(String am) {
        RefJavaUtil.getInstance().setAccessModifier((RefJavaElement)this.getOwnerClass(), am);
    }

    @Override
    public PsiModifierListOwner getElement() {
        return this.getOwnerClass().getElement();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return ((RefClassImpl)this.getOwnerClass()).getContainingFile();
    }

    @Override
    public RefClass getOwnerClass() {
        return this.myOwnerClass;
    }
}

