/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaModuleImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import javax.swing.JButton;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaManagerImpl
extends RefJavaManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + RefJavaManagerImpl.class.getName()));
    private PsiMethod myAppMainPattern;
    private PsiMethod myAppPremainPattern;
    private PsiMethod myAppAgentmainPattern;
    private PsiClass myApplet;
    private PsiClass myServlet;
    private PsiClass myAndroidActivity;
    private PsiClass myAndroidService;
    private PsiClass myAndroidBackupAgent;
    private PsiClass myAndroidFragment;
    private PsiClass myAndroidV4Fragment;
    private PsiClass myAndroidContentProvider;
    private PsiClass myAndroidReceiver;
    private PsiClass myAndroidView;
    private PsiClass myAndroidActionProvider;
    private PsiClass myAndroidParcelable;
    private RefPackage myDefaultPackage;
    private THashMap<String, RefPackage> myPackages;
    private final RefManagerImpl myRefManager;
    private PsiElementVisitor myProjectIterator;
    private EntryPointsManager myEntryPointsManager;

    public RefJavaManagerImpl(@NotNull RefManagerImpl manager) {
        this.myRefManager = manager;
        Project project2 = manager.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        try {
            this.myAppMainPattern = factory.createMethodFromText("void main(String[] args);", null);
            this.myAppPremainPattern = factory.createMethodFromText("void premain(String[] args, java.lang.instrument.Instrumentation i);", null);
            this.myAppAgentmainPattern = factory.createMethodFromText("void agentmain(String[] args, java.lang.instrument.Instrumentation i);", null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
        this.myApplet = psiFacade.findClass("java.applet.Applet", scope);
        this.myServlet = psiFacade.findClass("javax.servlet.Servlet", scope);
        this.myAndroidActivity = psiFacade.findClass("android.app.Activity", scope);
        this.myAndroidService = psiFacade.findClass("android.app.Service", scope);
        this.myAndroidFragment = psiFacade.findClass("android.app.Fragment", scope);
        this.myAndroidV4Fragment = psiFacade.findClass("android.support.v4.app.Fragment", scope);
        this.myAndroidContentProvider = psiFacade.findClass("android.content.ContentProvider", scope);
        this.myAndroidReceiver = psiFacade.findClass("android.content.BroadcastReceiver", scope);
        this.myAndroidView = psiFacade.findClass("android.view.View", scope);
        this.myAndroidActionProvider = psiFacade.findClass("android.view.ActionProvider", scope);
        this.myAndroidParcelable = psiFacade.findClass("android.os.Parcelable", scope);
        this.myAndroidBackupAgent = psiFacade.findClass("android.app.backup.BackupAgent", scope);
    }

    public RefImplicitConstructor getImplicitConstructor(String classFQName) {
        RefEntity entity = this.getReference("class", classFQName);
        if (entity == null) {
            return null;
        }
        RefClass refClass = (RefClass)entity;
        return (RefImplicitConstructor)refClass.getDefaultConstructor();
    }

    public RefPackage getPackage(String packageName) {
        RefPackage refPackage;
        if (this.myPackages == null) {
            this.myPackages = new THashMap();
        }
        if ((refPackage = (RefPackage)this.myPackages.get((Object)packageName)) == null) {
            refPackage = new RefPackageImpl(packageName, this.myRefManager);
            this.myPackages.put((Object)packageName, (Object)refPackage);
            int dotIndex = packageName.lastIndexOf(46);
            if (dotIndex >= 0) {
                ((RefPackageImpl)this.getPackage(packageName.substring(0, dotIndex))).add((RefEntity)refPackage);
            } else {
                ((RefProjectImpl)this.myRefManager.getRefProject()).add((RefEntity)refPackage);
            }
        }
        return refPackage;
    }

    public boolean isEntryPoint(RefElement element) {
        UnusedDeclarationInspectionBase tool = this.getDeadCodeTool(element);
        return tool != null && tool.isEntryPoint(element) && RefJavaManagerImpl.isTestSource(tool, element);
    }

    private static boolean isTestSource(UnusedDeclarationInspectionBase tool, RefElement refElement) {
        if (tool.isTestEntryPoints()) {
            return true;
        }
        PsiElement element = refElement.getElement();
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file2 != null) {
            return !ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInTestSourceContent(file2);
        }
        return false;
    }

    @Nullable
    private UnusedDeclarationInspectionBase getDeadCodeTool(RefElement element) {
        PsiFile file2 = ((RefElementImpl)element).getContainingFile();
        if (file2 == null) {
            return null;
        }
        return this.getDeadCodeTool(file2.getContainingFile());
    }

    private UnusedDeclarationInspectionBase getDeadCodeTool(PsiFile file2) {
        Tools tools = ((GlobalInspectionContextBase)this.myRefManager.getContext()).getTools().get("unused");
        InspectionToolWrapper toolWrapper = tools == null ? null : tools.getEnabledTool((PsiElement)file2);
        InspectionProfileEntry tool = toolWrapper == null ? null : toolWrapper.getTool();
        return tool instanceof UnusedDeclarationInspectionBase ? (UnusedDeclarationInspectionBase)tool : null;
    }

    public RefPackage getDefaultPackage() {
        if (this.myDefaultPackage == null) {
            this.myDefaultPackage = this.getPackage(InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]));
        }
        return this.myDefaultPackage;
    }

    public PsiMethod getAppMainPattern() {
        return this.myAppMainPattern;
    }

    public PsiMethod getAppPremainPattern() {
        return this.myAppPremainPattern;
    }

    public PsiMethod getAppAgentmainPattern() {
        return this.myAppAgentmainPattern;
    }

    public PsiClass getApplet() {
        return this.myApplet;
    }

    public PsiClass getServlet() {
        return this.myServlet;
    }

    public PsiClass getAndroidActivity() {
        return this.myAndroidActivity;
    }

    public PsiClass getAndroidService() {
        return this.myAndroidService;
    }

    public PsiClass getAndroidBackupAgent() {
        return this.myAndroidBackupAgent;
    }

    public PsiClass getAndroidFragment(boolean support) {
        return support ? this.myAndroidV4Fragment : this.myAndroidFragment;
    }

    public PsiClass getAndroidContentProvider() {
        return this.myAndroidContentProvider;
    }

    public PsiClass getAndroidReceiver() {
        return this.myAndroidReceiver;
    }

    public PsiClass getAndroidView() {
        return this.myAndroidView;
    }

    public PsiClass getAndroidActionProvider() {
        return this.myAndroidActionProvider;
    }

    public PsiClass getAndroidParcelable() {
        return this.myAndroidParcelable;
    }

    public RefParameter getParameterReference(PsiParameter param, int index) {
        LOG.assertTrue(this.myRefManager.isValidPointForReference(), (Object)"References may become invalid after process is finished");
        return (RefParameter)this.myRefManager.getFromRefTableOrCache((PsiElement)param, () -> {
            RefParameterImpl ref = new RefParameterImpl(param, index, (RefManager)this.myRefManager);
            ref.initialize();
            return ref;
        });
    }

    public void iterate(@NotNull RefVisitor visitor) {
        if (this.myPackages != null) {
            for (RefPackage refPackage : this.myPackages.values()) {
                refPackage.accept(visitor);
            }
        }
        for (RefElement refElement : this.myRefManager.getSortedElements()) {
            RefClass refClass;
            RefMethod refDefaultConstructor;
            if (!(refElement instanceof RefClass) || !((refDefaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) instanceof RefImplicitConstructor)) continue;
            refClass.getDefaultConstructor().accept(visitor);
        }
    }

    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            Disposer.dispose((Disposable)this.myEntryPointsManager);
            this.myEntryPointsManager = null;
        }
        this.myPackages = null;
        this.myApplet = null;
        this.myAppMainPattern = null;
        this.myAppPremainPattern = null;
        this.myAppAgentmainPattern = null;
        this.myServlet = null;
        this.myAndroidActivity = null;
        this.myAndroidService = null;
        this.myAndroidBackupAgent = null;
        this.myAndroidFragment = null;
        this.myAndroidV4Fragment = null;
        this.myAndroidContentProvider = null;
        this.myAndroidReceiver = null;
        this.myAndroidView = null;
        this.myAndroidActionProvider = null;
        this.myAndroidParcelable = null;
        this.myDefaultPackage = null;
        this.myProjectIterator = null;
    }

    public void removeReference(@NotNull RefElement refElement) {
        if (refElement instanceof RefMethod) {
            RefParameter[] params;
            RefMethod refMethod = (RefMethod)refElement;
            for (RefParameter param : params = refMethod.getParameters()) {
                this.myRefManager.removeReference((RefElement)param);
            }
        }
    }

    @Nullable
    public RefElement createRefElement(PsiElement elem) {
        if (elem instanceof PsiClass) {
            return new RefClassImpl((PsiClass)elem, (RefManager)this.myRefManager);
        }
        if (elem instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)elem;
            RefElement ref = this.myRefManager.getReference((PsiElement)method2.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefMethodImpl((RefClass)ref, method2, (RefManager)this.myRefManager);
            }
        } else if (elem instanceof PsiField) {
            PsiField field = (PsiField)elem;
            RefElement ref = this.myRefManager.getReference((PsiElement)field.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefFieldImpl((RefClass)ref, field, (RefManager)this.myRefManager);
            }
        } else {
            if (elem instanceof PsiJavaFile) {
                return new RefJavaFileImpl((PsiJavaFile)elem, (RefManager)this.myRefManager);
            }
            if (elem instanceof PsiJavaModule) {
                return new RefJavaModuleImpl((PsiJavaModule)elem, this.myRefManager);
            }
        }
        return null;
    }

    @Nullable
    public RefEntity getReference(String type2, String fqName) {
        if ("implicit.constructor".equals(type2)) {
            return this.getImplicitConstructor(fqName);
        }
        if ("method".equals(type2)) {
            return RefMethodImpl.methodFromExternalName(this.myRefManager, fqName);
        }
        if ("class".equals(type2)) {
            return RefClassImpl.classFromExternalName(this.myRefManager, fqName);
        }
        if ("field".equals(type2)) {
            return RefFieldImpl.fieldFromExternalName(this.myRefManager, fqName);
        }
        if ("parameter".equals(type2)) {
            return RefParameterImpl.parameterFromExternalName(this.myRefManager, fqName);
        }
        if ("package".equals(type2)) {
            return RefPackageImpl.packageFromFQName(this.myRefManager, fqName);
        }
        return null;
    }

    @Nullable
    public String getType(RefEntity ref) {
        if (ref instanceof RefImplicitConstructor) {
            return "implicit.constructor";
        }
        if (ref instanceof RefMethod) {
            return "method";
        }
        if (ref instanceof RefClass) {
            return "class";
        }
        if (ref instanceof RefField) {
            return "field";
        }
        if (ref instanceof RefParameter) {
            return "parameter";
        }
        if (ref instanceof RefPackage) {
            return "package";
        }
        if (ref instanceof RefJavaModule) {
            return "java.module";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref instanceof RefImplicitConstructor) {
            return ((RefImplicitConstructor)ref).getOwnerClass();
        }
        return ref;
    }

    public void visitElement(PsiElement element) {
        if (this.myProjectIterator == null) {
            this.myProjectIterator = new MyJavaElementVisitor();
        }
        element.accept(this.myProjectIterator);
    }

    @Nullable
    public String getGroupName(RefEntity entity) {
        if (entity instanceof RefFile && !(entity instanceof RefJavaFileImpl)) {
            return null;
        }
        return RefJavaUtil.getInstance().getPackageName(entity);
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return !(psiElement instanceof PsiTypeParameter);
    }

    public void export(@NotNull RefEntity refEntity, @NotNull Element element) {
        PsiFile psiFile;
        SmartPsiElementPointer pointer;
        if (refEntity instanceof RefElement && (pointer = ((RefElement)refEntity).getPointer()) != null && (psiFile = pointer.getContainingFile()) instanceof PsiJavaFile) {
            RefJavaManagerImpl.appendPackageElement(element, ((PsiJavaFile)psiFile).getPackageName());
        }
    }

    public void onEntityInitialized(RefElement refElement, PsiElement psiElement) {
        if (this.myRefManager.isOfflineView()) {
            return;
        }
        if (this.isEntryPoint(refElement)) {
            this.getEntryPointsManager().addEntryPoint(refElement, false);
        }
    }

    private static void appendPackageElement(Element element, String packageName) {
        Element packageElement = new Element("package");
        packageElement.addContent(packageName.isEmpty() ? InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]) : packageName);
        element.addContent(packageElement);
    }

    public EntryPointsManager getEntryPointsManager() {
        if (this.myEntryPointsManager == null) {
            Project project2 = this.myRefManager.getProject();
            this.myEntryPointsManager = new EntryPointsManagerBase(project2){

                public void configureAnnotations() {
                }

                public JButton createConfigureAnnotationsBtn() {
                    return null;
                }
            };
            Disposer.register((Disposable)project2, (Disposable)this.myEntryPointsManager);
            ((EntryPointsManagerBase)this.myEntryPointsManager).addAllPersistentEntries(EntryPointsManagerBase.getInstance(project2));
        }
        return this.myEntryPointsManager;
    }

    private class MyJavaElementVisitor
    extends JavaElementVisitor {
        private final RefJavaUtil myRefUtil = RefJavaUtil.getInstance();

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitElement((PsiElement)expression2);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        }

        public void visitReferenceParameterList(PsiReferenceParameterList list) {
            PsiType[] typeArguments;
            PsiTypeParameterListOwner owner;
            super.visitReferenceParameterList(list);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)list, PsiMember.class);
            if (member instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)member).getOwner()) != null) {
                for (PsiType psiType : ((PsiTypeParameter)member).getExtendsListTypes()) {
                    this.myRefUtil.addTypeReference((PsiElement)owner, psiType, (RefManager)RefJavaManagerImpl.this.myRefManager);
                }
            }
            for (PsiType psiType : typeArguments = list.getTypeArguments()) {
                this.myRefUtil.addTypeReference((PsiElement)member, psiType, (RefManager)RefJavaManagerImpl.this.myRefManager);
            }
        }

        public void visitClass(PsiClass aClass) {
            if (!(aClass instanceof PsiTypeParameter)) {
                super.visitClass(aClass);
                RefElement refClass = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)aClass);
                if (refClass != null) {
                    ((RefClassImpl)refClass).buildReferences();
                }
            }
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)method2);
            if (refElement instanceof RefMethodImpl) {
                ((RefMethodImpl)refElement).buildReferences();
            }
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)field);
            if (refElement instanceof RefFieldImpl) {
                ((RefFieldImpl)refElement).buildReferences();
            }
        }

        public void visitDocComment(PsiDocComment comment) {
            PsiDocTag[] tags;
            super.visitDocComment(comment);
            for (PsiDocTag tag : tags = comment.getTags()) {
                RefElementImpl element;
                PsiModifierListOwner listOwner;
                PsiElement[] dataElements;
                if (!Comparing.strEqual((String)tag.getName(), (String)"noinspection") || (dataElements = tag.getDataElements()) == null || dataElements.length <= 0 || (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)comment, PsiModifierListOwner.class)) == null || (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) == null) continue;
                String suppression = "";
                for (PsiElement dataElement : dataElements) {
                    suppression = suppression + "," + dataElement.getText();
                }
                element.addSuppression(suppression);
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            RefElementImpl element;
            PsiModifierListOwner listOwner;
            super.visitAnnotation(annotation);
            if (Comparing.strEqual((String)annotation.getQualifiedName(), (String)"java.lang.SuppressWarnings") && (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class)) != null && (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) != null) {
                PsiNameValuePair[] nameValuePairs;
                StringBuilder buf = new StringBuilder();
                for (PsiNameValuePair nameValuePair : nameValuePairs = annotation.getParameterList().getAttributes()) {
                    buf.append(",").append(nameValuePair.getText().replaceAll("[{}\"\"]", ""));
                }
                if (buf.length() > 0) {
                    element.addSuppression(buf.substring(1));
                }
            }
        }

        public void visitVariable(PsiVariable variable) {
            RefElement reference;
            super.visitVariable(variable);
            this.myRefUtil.addTypeReference((PsiElement)variable, variable.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
            if (variable instanceof PsiParameter && (reference = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)variable)) instanceof RefParameterImpl) {
                ((RefParameterImpl)reference).buildReferences();
            }
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
            super.visitInstanceOfExpression(expression2);
            PsiTypeElement typeElement = expression2.getCheckType();
            if (typeElement != null) {
                this.myRefUtil.addTypeReference((PsiElement)expression2, typeElement.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
            }
        }

        public void visitThisExpression(PsiThisExpression expression2) {
            super.visitThisExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier != null) {
                RefClassImpl refClass;
                this.myRefUtil.addTypeReference((PsiElement)expression2, expression2.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
                RefClass ownerClass = this.myRefUtil.getOwnerClass((RefManager)RefJavaManagerImpl.this.myRefManager, (PsiElement)expression2);
                if (ownerClass != null && (refClass = (RefClassImpl)RefJavaManagerImpl.this.myRefManager.getReference(qualifier.resolve())) != null) {
                    refClass.addInstanceReference((RefElement)ownerClass);
                }
            }
        }

        public void visitModule(PsiJavaModule javaModule) {
            super.visitModule(javaModule);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)javaModule);
            if (refElement != null) {
                ((RefJavaModuleImpl)refElement).buildReferences();
            }
        }

        public void visitJavaFile(PsiJavaFile file2) {
            super.visitJavaFile(file2);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)file2);
            if (refElement != null) {
                ((RefJavaFileImpl)refElement).buildReferences();
            }
        }
    }
}

