/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.ResolveResult;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaModuleImpl
extends RefElementImpl
implements RefJavaModule {
    private final RefModule myRefModule;
    private Map<String, List<String>> myExportedPackageNames;
    private List<RefJavaModule.RequiredModule> myRequiredModules;

    public RefJavaModuleImpl(@NotNull PsiJavaModule javaModule, @NotNull RefManagerImpl manager) {
        super(javaModule.getName(), (PsiElement)javaModule, manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)javaModule));
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> ((RefJavaVisitor)visitor).visitJavaModule((RefJavaModule)this));
        } else {
            super.accept(visitor);
        }
    }

    @Nullable
    public PsiJavaModule getElement() {
        return (PsiJavaModule)super.getElement();
    }

    @Override
    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    @NotNull
    public Map<String, List<String>> getExportedPackageNames() {
        return this.myExportedPackageNames != null ? this.myExportedPackageNames : Collections.emptyMap();
    }

    @NotNull
    public List<RefJavaModule.RequiredModule> getRequiredModules() {
        return this.myRequiredModules != null ? this.myRequiredModules : Collections.emptyList();
    }

    @Override
    public void buildReferences() {
        PsiJavaModule javaModule = this.getElement();
        if (javaModule != null) {
            PsiElement element;
            for (PsiRequiresStatement statement2 : javaModule.getRequires()) {
                PsiJavaModuleReferenceElement referenceElement = statement2.getReferenceElement();
                if (referenceElement == null || !((element = this.addReference(referenceElement.getReference())) instanceof PsiJavaModule)) continue;
                PsiJavaModule requiredModule = (PsiJavaModule)element;
                Map<String, List<String>> packagesExportedByModule = RefJavaModuleImpl.getPackagesExportedByModule(requiredModule);
                if (this.myRequiredModules == null) {
                    this.myRequiredModules = new ArrayList<RefJavaModule.RequiredModule>(1);
                }
                this.myRequiredModules.add(new RefJavaModule.RequiredModule(requiredModule.getName(), packagesExportedByModule, statement2.hasModifierProperty("transitive")));
            }
            List emptyList = Collections.emptyList();
            for (PsiPackageAccessibilityStatement statement3 : javaModule.getExports()) {
                element = this.addReference((PsiPolyVariantReference)statement3.getPackageReference());
                String packageName = null;
                if (element instanceof PsiPackage) {
                    packageName = ((PsiPackage)element).getQualifiedName();
                    if (this.myExportedPackageNames == null) {
                        this.myExportedPackageNames = new THashMap(1);
                    }
                    this.myExportedPackageNames.put(packageName, emptyList);
                }
                for (PsiJavaModuleReferenceElement referenceElement : statement3.getModuleReferences()) {
                    if (referenceElement == null) continue;
                    PsiElement moduleElement = this.addReference(referenceElement.getReference());
                    if (packageName == null || !(moduleElement instanceof PsiJavaModule)) continue;
                    List<String> toModuleNames = this.myExportedPackageNames.get(packageName);
                    if (toModuleNames == emptyList) {
                        toModuleNames = new ArrayList<String>(1);
                        this.myExportedPackageNames.put(packageName, toModuleNames);
                    }
                    toModuleNames.add(((PsiJavaModule)moduleElement).getName());
                }
            }
            ((RefModuleImpl)this.myRefModule).add(this);
            this.getRefManager().fireBuildReferences(this);
        }
    }

    private PsiElement addReference(PsiPolyVariantReference reference) {
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        if (reference != null) {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
                PsiElement element = resolveResult.getElement();
                if (element == null) continue;
                resolvedElements.add(element);
                RefElement refElement = this.getRefManager().getReference(element);
                if (refElement == null) continue;
                this.addOutReference(refElement);
                ((RefElementImpl)refElement).addInReference(this);
            }
        }
        return resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
    }

    @NotNull
    private static Map<String, List<String>> getPackagesExportedByModule(@NotNull PsiJavaModule javaModule) {
        THashMap exportedPackages = new THashMap();
        for (PsiPackageAccessibilityStatement statement2 : javaModule.getExports()) {
            String packageName = statement2.getPackageName();
            if (packageName == null) continue;
            exportedPackages.put(packageName, statement2.getModuleNames());
        }
        return !exportedPackages.isEmpty() ? exportedPackages : Collections.emptyMap();
    }
}

