/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaUtilImpl
extends RefJavaUtil {
    public void addReferences(final @NotNull PsiModifierListOwner psiFrom, @NotNull RefJavaElement ref, @Nullable PsiElement findIn) {
        final RefJavaElementImpl refFrom = (RefJavaElementImpl)ref;
        if (findIn == null) {
            return;
        }
        findIn.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                this.visitElement((PsiElement)reference);
                PsiElement target = reference.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference((PsiElement)aClass);
                    refFrom.addReference(refClass, (PsiElement)aClass, (PsiElement)psiFrom, false, true, null);
                }
                if (target instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated((PsiElement)target)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                RefElement refContainingClass;
                PsiClass containingClass;
                this.visitElement((PsiElement)expression2);
                JavaResolveResult result2 = expression2.advancedResolve(false);
                PsiElement psiResolved = result2.getElement();
                if (psiResolved instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated((PsiElement)psiResolved)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
                RefElement refResolved = refFrom.getRefManager().getReference(psiResolved);
                refFrom.addReference(refResolved, psiResolved, (PsiElement)psiFrom, PsiUtil.isAccessedForWriting((PsiExpression)expression2), PsiUtil.isAccessedForReading((PsiExpression)expression2), expression2);
                if (refResolved instanceof RefMethod) {
                    RefJavaUtilImpl.this.updateRefMethod(psiResolved, refResolved, (PsiElement)expression2, (PsiElement)psiFrom, refFrom);
                }
                if (psiResolved instanceof PsiMember && result2.getCurrentFileResolveScope() instanceof PsiImportStaticStatement && (containingClass = ((PsiMember)psiResolved).getContainingClass()) != null && (refContainingClass = refFrom.getRefManager().getReference((PsiElement)containingClass)) != null) {
                    refFrom.addReference(refContainingClass, (PsiElement)containingClass, (PsiElement)psiFrom, false, true, expression2);
                }
            }

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                super.visitEnumConstant(enumConstant);
                this.processNewLikeConstruct(enumConstant.resolveConstructor(), enumConstant.getArgumentList());
            }

            public void visitNewExpression(PsiNewExpression newExpr) {
                PsiType newType;
                super.visitNewExpression(newExpr);
                PsiMethod psiConstructor = newExpr.resolveConstructor();
                PsiExpressionList argumentList = newExpr.getArgumentList();
                RefMethod refConstructor = this.processNewLikeConstruct(psiConstructor, argumentList);
                if (refConstructor == null && (newType = newExpr.getType()) instanceof PsiClassType) {
                    this.processClassReference(PsiUtil.resolveClassInType((PsiType)newType), refFrom, psiFrom, true);
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                super.visitLambdaExpression(expression2);
                this.processFunctionalExpression((PsiFunctionalExpression)expression2);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                super.visitMethodReferenceExpression(expression2);
                this.processFunctionalExpression((PsiFunctionalExpression)expression2);
            }

            private void processFunctionalExpression(PsiFunctionalExpression expression2) {
                PsiClass aClass = PsiUtil.resolveClassInType((PsiType)expression2.getFunctionalInterfaceType());
                if (aClass != null) {
                    refFrom.addReference(refFrom.getRefManager().getReference((PsiElement)aClass), (PsiElement)aClass, (PsiElement)psiFrom, false, true, null);
                    PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass);
                    if (interfaceMethod != null) {
                        refFrom.addReference(refFrom.getRefManager().getReference((PsiElement)interfaceMethod), (PsiElement)interfaceMethod, (PsiElement)psiFrom, false, true, null);
                        PsiElement body2 = null;
                        PsiFunctionalExpression topElement = null;
                        if (expression2 instanceof PsiLambdaExpression) {
                            body2 = ((PsiLambdaExpression)expression2).getBody();
                            topElement = expression2;
                        } else {
                            PsiElement resolve2 = ((PsiMethodReferenceExpression)expression2).resolve();
                            if (resolve2 instanceof PsiMethod) {
                                body2 = ((PsiMethod)resolve2).getBody();
                                topElement = resolve2;
                            }
                        }
                        List<PsiClassType> exceptionTypes = body2 != null ? ExceptionUtil.collectUnhandledExceptions(body2, (PsiElement)topElement, false) : Collections.emptyList();
                        RefElement refResolved = refFrom.getRefManager().getReference((PsiElement)interfaceMethod);
                        if (refResolved instanceof RefMethodImpl) {
                            for (PsiClassType exceptionType : exceptionTypes) {
                                ((RefMethodImpl)refResolved).updateThrowsList(exceptionType);
                            }
                        }
                    }
                }
            }

            @Nullable
            private RefMethod processNewLikeConstruct(PsiMethod psiConstructor, PsiExpressionList argumentList) {
                if (psiConstructor != null && RefJavaUtil.isDeprecated((PsiElement)psiConstructor)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
                RefMethodImpl refConstructor = (RefMethodImpl)refFrom.getRefManager().getReference((PsiElement)psiConstructor);
                refFrom.addReference(refConstructor, (PsiElement)psiConstructor, (PsiElement)psiFrom, false, true, null);
                if (argumentList != null) {
                    PsiExpression[] psiParams;
                    for (PsiExpression param : psiParams = argumentList.getExpressions()) {
                        param.accept((PsiElementVisitor)this);
                    }
                    if (refConstructor != null) {
                        refConstructor.updateParameterValues(psiParams);
                    }
                }
                return refConstructor;
            }

            public void visitClass(PsiClass psiClass) {
                super.visitClass(psiClass);
                RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference((PsiElement)psiClass);
                refFrom.addReference(refClass, (PsiElement)psiClass, (PsiElement)psiFrom, false, true, null);
            }

            public void visitReturnStatement(PsiReturnStatement statement2) {
                super.visitReturnStatement(statement2);
                if (refFrom instanceof RefMethodImpl) {
                    RefMethodImpl refMethod = (RefMethodImpl)refFrom;
                    refMethod.updateReturnValueTemplate(statement2.getReturnValue());
                }
            }

            public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
                super.visitClassObjectAccessExpression(expression2);
                PsiTypeElement operand2 = expression2.getOperand();
                PsiType type2 = operand2.getType();
                if (type2 instanceof PsiClassType) {
                    this.processClassReference(((PsiClassType)type2).resolve(), refFrom, psiFrom, false);
                }
            }

            private void processClassReference(PsiClass psiClass, RefJavaElementImpl refFrom2, PsiModifierListOwner psiFrom2, boolean defaultConstructorOnly) {
                RefClassImpl refClass;
                if (psiClass != null && (refClass = (RefClassImpl)refFrom2.getRefManager().getReference((PsiElement)psiClass)) != null) {
                    boolean hasConstructorsMarked = false;
                    if (defaultConstructorOnly) {
                        RefMethodImpl refDefaultConstructor = (RefMethodImpl)refClass.getDefaultConstructor();
                        if (refDefaultConstructor != null) {
                            refDefaultConstructor.addInReference(refFrom2);
                            refFrom2.addOutReference(refDefaultConstructor);
                            hasConstructorsMarked = true;
                        }
                    } else {
                        for (RefMethod cons : refClass.getConstructors()) {
                            if (cons instanceof RefImplicitConstructor) continue;
                            ((RefMethodImpl)cons).addInReference(refFrom2);
                            refFrom2.addOutReference((RefElement)cons);
                            hasConstructorsMarked = true;
                        }
                    }
                    if (!hasConstructorsMarked) {
                        refFrom2.addReference(refClass, (PsiElement)psiClass, (PsiElement)psiFrom2, false, true, null);
                    }
                }
            }
        });
    }

    private void updateRefMethod(PsiElement psiResolved, RefElement refResolved, PsiElement refExpression, PsiElement psiFrom, RefElement refFrom) {
        PsiMethod psiMethod = (PsiMethod)psiResolved;
        RefMethodImpl refMethod = (RefMethodImpl)refResolved;
        if (refExpression instanceof PsiMethodReferenceExpression) {
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && !PsiType.VOID.equals((Object)returnType)) {
                refMethod.setReturnValueUsed(true);
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            return;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiMethodCallExpression.class);
        if (call != null) {
            PsiClassType methodOwnerType;
            String fqName;
            PsiType usedType;
            PsiExpression psiExpression;
            PsiExpressionList argumentList;
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && !PsiType.VOID.equals((Object)returnType)) {
                if (!(call.getParent() instanceof PsiExpressionStatement)) {
                    refMethod.setReturnValueUsed(true);
                }
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            if ((argumentList = call.getArgumentList()).getExpressions().length > 0) {
                refMethod.updateParameterValues(argumentList.getExpressions());
            }
            if ((psiExpression = call.getMethodExpression().getQualifierExpression()) != null && (usedType = psiExpression.getType()) != null && (fqName = psiMethod.getContainingClass().getQualifiedName()) != null && !usedType.equals(methodOwnerType = JavaPsiFacade.getInstance((Project)call.getProject()).getElementFactory().createTypeByFQClassName(fqName, GlobalSearchScope.allScope((Project)psiMethod.getProject())))) {
                refMethod.setCalledOnSubClass(true);
            }
        }
    }

    public RefClass getTopLevelClass(@NotNull RefElement refElement) {
        for (RefEntity refParent = refElement.getOwner(); refParent != null && refParent instanceof RefElement && !(refParent instanceof RefFile); refParent = refParent.getOwner()) {
            refElement = (RefElementImpl)refParent;
        }
        return refElement instanceof RefClass ? (RefClass)refElement : null;
    }

    public boolean isInheritor(@NotNull RefClass subClass, RefClass superClass) {
        if (subClass == superClass) {
            return true;
        }
        for (RefClass baseClass : subClass.getBaseClasses()) {
            if (!this.isInheritor(baseClass, superClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getPackageName(RefEntity refEntity) {
        if (refEntity instanceof RefProject) {
            return null;
        }
        RefPackage refPackage = RefJavaUtilImpl.getPackage((RefEntity)refEntity);
        return refPackage == null ? InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]) : refPackage.getQualifiedName();
    }

    @NotNull
    public String getAccessModifier(@NotNull PsiModifierListOwner psiElement) {
        if (psiElement instanceof PsiParameter) {
            return "packageLocal";
        }
        PsiModifierList list = psiElement.getModifierList();
        String result2 = "packageLocal";
        if (list != null) {
            if (list.hasModifierProperty("private")) {
                result2 = "private";
            } else if (list.hasModifierProperty("protected")) {
                result2 = "protected";
            } else if (list.hasModifierProperty("public")) {
                result2 = "public";
            } else if (psiElement.getParent() instanceof PsiClass) {
                PsiClass ownerClass = (PsiClass)psiElement.getParent();
                if (ownerClass.isInterface()) {
                    result2 = "public";
                }
                if (ownerClass.isEnum() && result2.equals("packageLocal")) {
                    result2 = "private";
                }
            }
        }
        return result2;
    }

    @Nullable
    public RefClass getOwnerClass(RefManager refManager, PsiElement psiElement) {
        while (psiElement != null && !(psiElement instanceof PsiClass)) {
            psiElement = psiElement.getParent();
        }
        return psiElement != null ? (RefClass)refManager.getReference(psiElement) : null;
    }

    @Nullable
    public RefClass getOwnerClass(RefElement refElement) {
        RefEntity parent = refElement.getOwner();
        while (!(parent instanceof RefClass) && parent instanceof RefElement) {
            parent = parent.getOwner();
        }
        if (parent instanceof RefClass) {
            return (RefClass)parent;
        }
        return null;
    }

    public boolean isMethodOnlyCallsSuper(PsiMethod method2) {
        boolean hasStatements = false;
        PsiCodeBlock body2 = method2.getBody();
        if (body2 != null) {
            PsiStatement[] statements;
            for (PsiStatement psiStatement : statements = body2.getStatements()) {
                boolean isCallToSameSuper = false;
                if (psiStatement instanceof PsiExpressionStatement) {
                    isCallToSameSuper = this.isCallToSuperMethod(((PsiExpressionStatement)psiStatement).getExpression(), method2);
                } else if (psiStatement instanceof PsiReturnStatement) {
                    PsiExpression expression2 = ((PsiReturnStatement)psiStatement).getReturnValue();
                    isCallToSameSuper = expression2 == null || this.isCallToSuperMethod(expression2, method2);
                }
                hasStatements = true;
                if (isCallToSameSuper) continue;
                return false;
            }
        }
        if (hasStatements) {
            PsiMethod[] superMethods = method2.findSuperMethods();
            for (PsiStatement psiStatement : superMethods) {
                if (VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)psiStatement.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)method2.getModifierList())) <= 0) continue;
                return false;
            }
        }
        return hasStatements;
    }

    public boolean isCallToSuperMethod(PsiExpression expression2, PsiMethod method2) {
        PsiMethodCallExpression methodCall;
        if (expression2 instanceof PsiMethodCallExpression && (methodCall = (PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression() instanceof PsiSuperExpression) {
            PsiMethod superMethod = (PsiMethod)methodCall.getMethodExpression().resolve();
            if (superMethod == null || !MethodSignatureUtil.areSignaturesEqual((PsiMethod)method2, (PsiMethod)superMethod)) {
                return false;
            }
            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
            PsiParameter[] parms = method2.getParameterList().getParameters();
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = args[i];
                if (!(arg instanceof PsiReferenceExpression)) {
                    return false;
                }
                if (parms[i].equals(((PsiReferenceExpression)arg).resolve())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareAccess(String a1, String a2) {
        int i2;
        int i1 = RefJavaUtilImpl.getAccessNumber(a1);
        if (i1 == (i2 = RefJavaUtilImpl.getAccessNumber(a2))) {
            return 0;
        }
        if (i1 < i2) {
            return -1;
        }
        return 1;
    }

    private static int getAccessNumber(String a) {
        if (a == "private") {
            return 0;
        }
        if (a == "packageLocal") {
            return 1;
        }
        if (a == "protected") {
            return 2;
        }
        if (a == "public") {
            return 3;
        }
        return -1;
    }

    public void setAccessModifier(@NotNull RefJavaElement refElement, @NotNull String newAccess) {
        ((RefJavaElementImpl)refElement).setAccessModifier(newAccess);
    }

    public void setIsStatic(RefJavaElement refElement, boolean isStatic) {
        ((RefJavaElementImpl)refElement).setIsStatic(isStatic);
    }

    public void setIsFinal(RefJavaElement refElement, boolean isFinal) {
        ((RefJavaElementImpl)refElement).setIsFinal(isFinal);
    }

    public void addTypeReference(PsiElement psiElement, PsiType psiType, RefManager refManager) {
        this.addTypeReference(psiElement, psiType, refManager, null);
    }

    public void addTypeReference(PsiElement psiElement, PsiType psiType, RefManager refManager, @Nullable RefJavaElement refMethod) {
        RefClass ownerClass;
        if (psiType != null && (ownerClass = this.getOwnerClass(refManager, psiElement)) != null && (psiType = psiType.getDeepComponentType()) instanceof PsiClassType) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
            if (psiClass != null && refManager.belongsToScope((PsiElement)psiClass)) {
                RefClassImpl refClass = (RefClassImpl)refManager.getReference((PsiElement)psiClass);
                if (refClass != null) {
                    refClass.addTypeReference((RefJavaElement)ownerClass);
                    if (refMethod != null) {
                        refClass.addClassExporter(refMethod);
                    }
                }
            } else {
                ((RefManagerImpl)refManager).fireNodeMarkedReferenced((PsiElement)psiClass, psiElement, false);
            }
        }
    }
}

