/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefDirectoryImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefManagerImpl
extends RefManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.reference.RefManager");
    private long myLastUsedMask = 0x8000000L;
    @NotNull
    private final Project myProject;
    private AnalysisScope myScope;
    private RefProject myRefProject;
    private final Map<PsiAnchor, RefElement> myRefTable = new THashMap();
    private final Map<PsiElement, RefElement> myPsiToRefTable = new THashMap();
    private final Object myRefTableLock = new Object();
    private List<RefElement> mySortedRefs;
    private final ConcurrentMap<Module, RefModule> myModules = ContainerUtil.newConcurrentMap();
    private final ProjectIterator myProjectIterator = new ProjectIterator();
    private volatile boolean myDeclarationsFound;
    private final PsiManager myPsiManager;
    private volatile boolean myIsInProcess;
    private volatile boolean myOfflineView;
    private final List<RefGraphAnnotator> myGraphAnnotators = new ArrayList<RefGraphAnnotator>();
    private GlobalInspectionContext myContext;
    private final Map<Key, RefManagerExtension> myExtensions = new THashMap();
    private final Map<Language, RefManagerExtension> myLanguageExtensions = new HashMap<Language, RefManagerExtension>();
    private final StringInterner myNameInterner = new StringInterner();

    public RefManagerImpl(@NotNull Project project2, @Nullable AnalysisScope scope, @NotNull GlobalInspectionContext context) {
        this.myProject = project2;
        this.myScope = scope;
        this.myContext = context;
        this.myPsiManager = PsiManager.getInstance((Project)project2);
        this.myRefProject = new RefProjectImpl(this);
        for (InspectionExtensionsFactory inspectionExtensionsFactory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            RefManagerExtension extension = inspectionExtensionsFactory.createRefManagerExtension((RefManager)this);
            if (extension == null) continue;
            this.myExtensions.put(extension.getID(), extension);
            this.myLanguageExtensions.put(extension.getLanguage(), extension);
        }
        if (scope != null) {
            for (InspectionExtensionsFactory inspectionExtensionsFactory : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                this.getRefModule((Module)inspectionExtensionsFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String internName(@NotNull String name) {
        StringInterner stringInterner = this.myNameInterner;
        synchronized (stringInterner) {
            return (String)this.myNameInterner.intern((Object)name);
        }
    }

    @NotNull
    public GlobalInspectionContext getContext() {
        return this.myContext;
    }

    public void iterate(@NotNull RefVisitor visitor) {
        for (RefElement refElement : this.getSortedElements()) {
            refElement.accept(visitor);
        }
        if (this.myModules != null) {
            for (RefModule refModule : this.myModules.values()) {
                refModule.accept(visitor);
            }
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.iterate(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.myScope = null;
        this.myRefProject = null;
        Iterator<RefManagerExtension> iterator = this.myRefTableLock;
        synchronized (iterator) {
            (RefManagerImpl.usePsiAsKey() ? this.myPsiToRefTable : this.myRefTable).clear();
            this.mySortedRefs = null;
        }
        this.myModules.clear();
        this.myContext = null;
        this.myGraphAnnotators.clear();
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
    }

    @Nullable
    public AnalysisScope getScope() {
        return this.myScope;
    }

    public void fireNodeInitialized(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onInitialize(refElement);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting);
        }
    }

    public void fireNodeMarkedReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(what, from, referencedFromClassInitializer);
        }
    }

    public void fireBuildReferences(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onReferencesBuild(refElement);
        }
    }

    public void registerGraphAnnotator(@NotNull RefGraphAnnotator annotator) {
        this.myGraphAnnotators.add(annotator);
        if (annotator instanceof RefGraphAnnotatorEx) {
            ((RefGraphAnnotatorEx)annotator).initialize((RefManager)this);
        }
    }

    public long getLastUsedMask() {
        this.myLastUsedMask *= 2L;
        return this.myLastUsedMask;
    }

    public <T> T getExtension(@NotNull Key<T> key2) {
        return (T)this.myExtensions.get(key2);
    }

    @Nullable
    public String getType(RefEntity ref) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String type2 = extension.getType(ref);
            if (type2 == null) continue;
            return type2;
        }
        if (ref instanceof RefFile) {
            return "file";
        }
        if (ref instanceof RefModule) {
            return "module";
        }
        if (ref instanceof RefProject) {
            return "project";
        }
        if (ref instanceof RefDirectory) {
            return "dir";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            ref = extension.getRefinedElement(ref);
        }
        return ref;
    }

    public Element export(@NotNull RefEntity refEntity, @NotNull Element element, int actualLine) {
        refEntity = this.getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefDirectory) {
            Element fileElement = new Element("file");
            VirtualFile virtualFile = ((PsiDirectory)((RefDirectory)refEntity).getElement()).getVirtualFile();
            fileElement.addContent(virtualFile.getUrl());
            problem.addContent(fileElement);
        } else if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            SmartPsiElementPointer pointer = refElement.getPointer();
            PsiFile psiFile = pointer.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            Element fileElement = new Element("file");
            Element lineElement = new Element("line");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance((Project)pointer.getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                Segment range = pointer.getRange();
                lineElement.addContent(String.valueOf(range != null ? document.getLineNumber(range.getStartOffset()) + 1 : -1));
            } else {
                lineElement.addContent(String.valueOf(actualLine + 1));
            }
            problem.addContent(fileElement);
            problem.addContent(lineElement);
            RefManagerImpl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            RefManagerImpl.appendModule(problem, refModule);
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            extension.export(refEntity, problem);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        element.addContent(problem);
        return problem;
    }

    @Nullable
    public String getGroupName(RefElement entity) {
        RefEntity parent;
        for (RefManagerExtension extension : this.myExtensions.values()) {
            String groupName = extension.getGroupName((RefEntity)entity);
            if (groupName == null) continue;
            return groupName;
        }
        LinkedList<String> containingDirs = new LinkedList<String>();
        for (parent = entity.getOwner(); parent != null && !(parent instanceof RefDirectory); parent = parent.getOwner()) {
        }
        while (parent instanceof RefDirectory) {
            containingDirs.addFirst(parent.getName());
            parent = parent.getOwner();
        }
        return containingDirs.isEmpty() ? null : StringUtil.join(containingDirs, (String)File.separator);
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    public void findAllDeclarations() {
        if (!this.myDeclarationsFound) {
            long before = System.currentTimeMillis();
            AnalysisScope scope = this.getScope();
            if (scope != null) {
                scope.accept((PsiElementVisitor)this.myProjectIterator);
            }
            this.myDeclarationsFound = true;
            LOG.info("Total duration of processing project usages:" + (System.currentTimeMillis() - before));
        }
    }

    public boolean isDeclarationsFound() {
        return this.myDeclarationsFound;
    }

    public void inspectionReadActionStarted() {
        this.myIsInProcess = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectionReadActionFinished() {
        this.myIsInProcess = false;
        if (this.myScope != null) {
            this.myScope.invalidate();
        }
        Object object = this.myRefTableLock;
        synchronized (object) {
            this.mySortedRefs = null;
        }
    }

    public void startOfflineView() {
        this.myOfflineView = true;
    }

    public boolean isOfflineView() {
        return this.myOfflineView;
    }

    public boolean isInProcess() {
        return this.myIsInProcess;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public RefProject getRefProject() {
        return this.myRefProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RefElement> getSortedElements() {
        ArrayList<RefElement> answer;
        Object object = this.myRefTableLock;
        synchronized (object) {
            if (this.mySortedRefs != null) {
                return this.mySortedRefs;
            }
            answer = new ArrayList<RefElement>(RefManagerImpl.usePsiAsKey() ? this.myPsiToRefTable.values() : this.myRefTable.values());
        }
        ReadAction.run(() -> ContainerUtil.quickSort((List)answer, (o1, o2) -> {
            VirtualFile v1 = ((RefElementImpl)o1).getVirtualFile();
            VirtualFile v2 = ((RefElementImpl)o2).getVirtualFile();
            return (v1 != null ? v1.hashCode() : 0) - (v2 != null ? v2.hashCode() : 0);
        }));
        object = this.myRefTableLock;
        synchronized (object) {
            this.mySortedRefs = Collections.unmodifiableList(answer);
            return this.mySortedRefs;
        }
    }

    @NotNull
    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReference(@NotNull RefElement refElem) {
        RefManagerExtension extension;
        PsiElement element = refElem.getElement();
        RefManagerExtension refManagerExtension = extension = element != null ? this.getExtension(element.getLanguage()) : null;
        if (extension != null) {
            extension.removeReference(refElem);
        }
        Object object = this.myRefTableLock;
        synchronized (object) {
            this.mySortedRefs = null;
            if (element != null && (RefManagerImpl.usePsiAsKey() ? this.myPsiToRefTable.remove(element) : this.myRefTable.remove(RefManagerImpl.createAnchor(element))) != null) {
                return;
            }
            if (RefManagerImpl.usePsiAsKey()) {
                for (Map.Entry<PsiElement, RefElement> entry : this.myPsiToRefTable.entrySet()) {
                    RefElement value2 = entry.getValue();
                    PsiElement anchor = entry.getKey();
                    if (value2 != refElem) continue;
                    this.myPsiToRefTable.remove(anchor);
                    break;
                }
            } else {
                for (Map.Entry<PsiAnchor, RefElement> entry : this.myRefTable.entrySet()) {
                    RefElement value3 = entry.getValue();
                    PsiAnchor anchor = entry.getKey();
                    if (value3 != refElem) continue;
                    this.myRefTable.remove(anchor);
                    break;
                }
            }
        }
    }

    @NotNull
    private static PsiAnchor createAnchor(final @NotNull PsiElement element) {
        return (PsiAnchor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnchor>(){

            public PsiAnchor compute() {
                return PsiAnchor.create(element);
            }
        });
    }

    public void initializeAnnotators() {
        RefGraphAnnotator[] graphAnnotators;
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.refGraphAnnotator");
        for (RefGraphAnnotator annotator : graphAnnotators = (RefGraphAnnotator[])point.getExtensions()) {
            this.registerGraphAnnotator(annotator);
        }
    }

    @Nullable
    public RefElement getReference(PsiElement elem) {
        return this.getReference(elem, false);
    }

    @Nullable
    public RefElement getReference(final PsiElement elem, final boolean ignoreScope) {
        if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return elem == null || !elem.isValid() || elem instanceof LightElement || !(elem instanceof PsiDirectory) && !RefManagerImpl.this.belongsToScope(elem, ignoreScope);
            }
        })).booleanValue()) {
            return null;
        }
        return this.getFromRefTableOrCache(elem, () -> (RefElementImpl)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RefElementImpl>(){

            @Nullable
            public RefElementImpl compute() {
                RefElement refElement;
                RefManagerExtension extension = RefManagerImpl.this.getExtension(elem.getLanguage());
                if (extension != null && (refElement = extension.createRefElement(elem)) != null) {
                    return (RefElementImpl)refElement;
                }
                if (elem instanceof PsiFile) {
                    return new RefFileImpl((PsiFile)elem, (RefManager)RefManagerImpl.this);
                }
                if (elem instanceof PsiDirectory) {
                    return new RefDirectoryImpl((PsiDirectory)elem, (RefManager)RefManagerImpl.this);
                }
                return null;
            }
        }), element -> ReadAction.run(() -> {
            element.initialize();
            for (RefManagerExtension each : this.myExtensions.values()) {
                each.onEntityInitialized((RefElement)element, elem);
            }
            this.fireNodeInitialized((RefElement)element);
        }));
    }

    private RefManagerExtension getExtension(Language language) {
        return this.myLanguageExtensions.get(language);
    }

    @Nullable
    public RefEntity getReference(String type2, String fqName) {
        for (RefManagerExtension extension : this.myExtensions.values()) {
            RefEntity refEntity = extension.getReference(type2, fqName);
            if (refEntity == null) continue;
            return refEntity;
        }
        if ("file".equals(type2)) {
            return RefFileImpl.fileFromExternalName(this, fqName);
        }
        if ("module".equals(type2)) {
            return RefModuleImpl.moduleFromName(this, fqName);
        }
        if ("project".equals(type2)) {
            return this.getRefProject();
        }
        if ("dir".equals(type2)) {
            String url = VfsUtilCore.pathToUrl((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(fqName));
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile != null) {
                PsiDirectory dir = PsiManager.getInstance((Project)this.getProject()).findDirectory(vFile);
                return this.getReference((PsiElement)dir);
            }
        }
        return null;
    }

    @Nullable
    protected <T extends RefElement> T getFromRefTableOrCache(PsiElement element, @NotNull NullableFactory<T> factory) {
        return this.getFromRefTableOrCache(element, factory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T extends RefElement> T getFromRefTableOrCache(PsiElement element, @NotNull NullableFactory<T> factory, @Nullable Consumer<T> whenCached) {
        RefElement result2;
        PsiAnchor psiAnchor = RefManagerImpl.createAnchor(element);
        Object object = this.myRefTableLock;
        synchronized (object) {
            RefElement refElement = result2 = RefManagerImpl.usePsiAsKey() ? this.myPsiToRefTable.get(element) : this.myRefTable.get(psiAnchor);
            if (result2 != null) {
                return (T)result2;
            }
            if (!this.isValidPointForReference()) {
                return null;
            }
            result2 = (RefElement)factory.create();
            if (result2 == null) {
                return null;
            }
            if (RefManagerImpl.usePsiAsKey()) {
                this.myPsiToRefTable.put(element, result2);
            } else {
                this.myRefTable.put(psiAnchor, result2);
            }
            this.mySortedRefs = null;
            if (whenCached != null) {
                whenCached.consume((Object)result2);
            }
        }
        return (T)result2;
    }

    public RefModule getRefModule(Module module2) {
        if (module2 == null) {
            return null;
        }
        RefModule refModule = (RefModule)this.myModules.get(module2);
        if (refModule == null) {
            refModule = (RefModule)ConcurrencyUtil.cacheOrGet(this.myModules, (Object)module2, (Object)new RefModuleImpl(module2, (RefManager)this));
        }
        return refModule;
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return this.belongsToScope(psiElement, false);
    }

    private boolean belongsToScope(final PsiElement psiElement, boolean ignoreScope) {
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return false;
        }
        PsiFile containingFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return psiElement.getContainingFile();
            }
        });
        if (containingFile == null) {
            return false;
        }
        for (RefManagerExtension extension : this.myExtensions.values()) {
            if (extension.belongsToScope(psiElement)) continue;
            return false;
        }
        Boolean inProject = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return psiElement.getManager().isInProject(psiElement);
            }
        });
        return inProject != false && (ignoreScope || this.getScope() == null || this.getScope().contains(psiElement));
    }

    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity == null || refEntity instanceof RefElementImpl && !refEntity.isValid()) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return refEntity.getQualifiedName();
    }

    public void removeRefElement(@NotNull RefElement refElement, @NotNull List<RefElement> deletedRefs) {
        RefElement[] refElements;
        List children2 = refElement.getChildren();
        for (RefElement refChild : refElements = children2.toArray(new RefElement[children2.size()])) {
            this.removeRefElement(refChild, deletedRefs);
        }
        ((RefManagerImpl)refElement.getRefManager()).removeReference(refElement);
        ((RefElementImpl)refElement).referenceRemoved();
        if (!deletedRefs.contains(refElement)) {
            deletedRefs.add(refElement);
        }
    }

    protected boolean isValidPointForReference() {
        return this.myIsInProcess || this.myOfflineView || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static boolean usePsiAsKey() {
        return Registry.is((String)"batch.inspections.use.psi.as.ref.table.key");
    }

    private class ProjectIterator
    extends PsiElementVisitor {
        private ProjectIterator() {
        }

        public void visitElement(PsiElement element) {
            RefManagerExtension extension = RefManagerImpl.this.getExtension(element.getLanguage());
            if (extension != null) {
                extension.visitElement(element);
            }
            for (PsiElement aChildren : element.getChildren()) {
                aChildren.accept((PsiElementVisitor)this);
            }
        }

        public void visitFile(PsiFile file2) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null) {
                String relative = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)RefManagerImpl.this.myProject, (boolean)true, (boolean)false);
                RefManagerImpl.this.myContext.incrementJobDoneAmount(((RefManagerImpl)RefManagerImpl.this).myContext.getStdJobDescriptors().BUILD_GRAPH, relative);
            }
            FileViewProvider viewProvider = file2.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                this.visitElement((PsiElement)viewProvider.getPsi(language));
            }
            RefManagerImpl.this.myPsiManager.dropResolveCaches();
            InjectedLanguageManager.getInstance((Project)RefManagerImpl.this.myProject).dropFileCaches(file2);
        }
    }
}

