/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.sillyAssignment.SillyAssignmentInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SillyAssignmentInspection
extends SillyAssignmentInspectionBase {
    @Override
    protected LocalQuickFix createRemoveAssignmentFix(PsiReferenceExpression expression2) {
        PsiVariable variable;
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiVariable && (variable = (PsiVariable)parent).hasModifierProperty("final")) {
            return null;
        }
        return new RemoveSillyAssignmentFix();
    }

    private static class RemoveSillyAssignmentFix
    implements LocalQuickFix {
        private RemoveSillyAssignmentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"assignment.to.itself.quickfix.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
            if (parent instanceof PsiVariable) {
                element.delete();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (PsiTreeUtil.isAncestor((PsiElement)lhs, (PsiElement)element, (boolean)false)) {
                if (rhs != null) {
                    assignmentExpression.replace((PsiElement)rhs);
                } else {
                    assignmentExpression.delete();
                }
            } else {
                PsiElement grandParent = assignmentExpression.getParent();
                if (grandParent instanceof PsiExpressionStatement) {
                    grandParent.delete();
                } else {
                    assignmentExpression.replace(element);
                }
            }
        }
    }
}

