/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectMigration
extends BaseStreamApiMigration {
    private static final Logger LOG = Logger.getInstance(CollectMigration.class);
    static final Map<String, String> INTERMEDIATE_STEPS = EntryStream.of((Object)"java.util.ArrayList", (Object)"", (Object)"java.util.LinkedList", (Object)"", (Object)"java.util.HashSet", (Object)".distinct()", (Object)"java.util.LinkedHashSet", (Object)".distinct()", (Object)"java.util.TreeSet", (Object)".distinct().sorted()").toMap();

    protected CollectMigration(String methodName) {
        super(methodName);
    }

    @Nullable
    static PsiType getAddedElementType(PsiMethodCallExpression call) {
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        PsiMethod method2 = call.resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        return resolveResult.getSubstitutor().substitute(parameters2[0].getType());
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body2, @NotNull TerminalBlock tb) {
        PsiElement result2;
        PsiLoopStatement loopStatement = tb.getMainLoop();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        CollectTerminal terminal = CollectMigration.extractCollectTerminal(tb);
        if (terminal == null) {
            return null;
        }
        String stream = tb.generate() + terminal.generateIntermediate() + terminal.generateTerminal();
        PsiElement toReplace = terminal.getElementToReplace();
        CollectMigration.restoreComments(loopStatement, body2);
        if (toReplace != null) {
            result2 = toReplace.replace((PsiElement)factory.createExpressionFromText(stream, toReplace));
            CollectMigration.removeLoop(loopStatement);
        } else {
            PsiLocalVariable variable = terminal.getTargetVariable();
            LOG.assertTrue(variable != null);
            result2 = CollectMigration.replaceInitializer(loopStatement, (PsiVariable)variable, variable.getInitializer(), stream, terminal.getStatus());
        }
        terminal.cleanUp();
        return result2;
    }

    private static boolean isHashMap(PsiLocalVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        LOG.assertTrue(initializer != null);
        PsiClass initializerClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)initializer.getType());
        PsiClass varClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType());
        return initializerClass != null && varClass != null && "java.util.HashMap".equals(initializerClass.getQualifiedName()) && "java.util.Map".equals(varClass.getQualifiedName()) && !ConstructionUtils.isCustomizedEmptyCollectionInitializer(initializer);
    }

    @Nullable
    static PsiLocalVariable extractQualifierVariable(TerminalBlock tb, PsiMethodCallExpression call) {
        PsiExpression qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)qualifierExpression2).resolve(), PsiLocalVariable.class);
        if (variable == null) {
            return null;
        }
        if (tb.getVariable() != variable && VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)call.getArgumentList())) {
            return null;
        }
        return variable;
    }

    @Nullable
    static CollectTerminal extractCollectTerminal(TerminalBlock tb) {
        PsiMethodCallExpression delimiterAppend;
        PsiMethodCallExpression call;
        PsiStatement[] statements = tb.getStatements();
        if (statements.length == 2) {
            if (!(statements[1] instanceof PsiExpressionStatement)) {
                return null;
            }
            call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)statements[1]).getExpression(), PsiMethodCallExpression.class);
            if (!(statements[0] instanceof PsiIfStatement)) {
                return null;
            }
            delimiterAppend = StringBuilderTerminal.extractDelimiterAppend(tb, (PsiIfStatement)statements[0]);
            if (delimiterAppend == null || VariableAccessUtils.variableIsUsed(tb.getVariable(), (PsiElement)delimiterAppend)) {
                return null;
            }
        } else {
            delimiterAppend = null;
            call = tb.getSingleMethodCall();
        }
        if (call == null) {
            return null;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        if (tb.dependsOn(qualifierExpression2)) {
            return null;
        }
        List<BiFunction> extractors = Arrays.asList(AddingTerminal::tryExtract, GroupingTerminal::tryExtract, ToMapTerminal::tryExtract, AddingAllTerminal::tryExtractAddAll, (t, c) -> StringBuilderTerminal.tryExtract(t, c, delimiterAppend));
        CollectTerminal terminal = ((StreamEx)StreamEx.of(extractors).map(extractor -> (CollectTerminal)extractor.apply(tb, call)).nonNull()).findFirst().orElse(null);
        if (terminal != null) {
            if (terminal.getStatus() == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
                return null;
            }
            terminal = CollectMigration.includePostStatements(terminal, tb.getMainLoop());
        }
        return terminal;
    }

    static CollectTerminal includePostStatements(CollectTerminal terminal, PsiLoopStatement loop) {
        CollectTerminal wrapped;
        List<BiFunction> wrappers = Arrays.asList(SortingTerminal::tryWrap, ToArrayTerminal::tryWrap, NewListTerminal::tryWrap);
        PsiLoopStatement nextStatement = loop;
        block0: do {
            nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)nextStatement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
            wrapped = null;
            for (BiFunction wrapper : wrappers) {
                wrapped = (CollectTerminal)wrapper.apply(terminal, nextStatement);
                if (wrapped == null) continue;
                terminal = wrapped;
                continue block0;
            }
        } while (wrapped != null);
        return terminal;
    }

    @Contract(value="null -> false")
    static boolean hasLambdaCompatibleEmptyInitializer(@Nullable PsiLocalVariable target) {
        return target != null && ConstructionUtils.isEmptyCollectionInitializer(target.getInitializer()) && LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)target.getInitializer());
    }

    static boolean isUsedOutsideOf(PsiVariable collectionVariable, Collection<PsiElement> allowedParents) {
        return !ReferencesSearch.search((PsiElement)collectionVariable).forEach(ref -> {
            PsiElement element = ref.getElement();
            return element == collectionVariable || allowedParents.stream().anyMatch(p -> PsiTreeUtil.isAncestor((PsiElement)p, (PsiElement)element, (boolean)false));
        });
    }

    @Contract(value="null -> null")
    static String getIntermediateStepsFromInitializer(PsiLocalVariable variable) {
        if (variable == null) {
            return null;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)initializer.getType());
        if (aClass == null) {
            return null;
        }
        return INTERMEDIATE_STEPS.get(aClass.getQualifiedName());
    }

    @NotNull
    private static String getCollectionCollector(PsiExpression initializer, PsiType type2) {
        String collector;
        PsiClassType rawVarType;
        PsiType initializerType = initializer.getType();
        PsiClassType rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
        PsiClassType psiClassType = rawVarType = type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : null;
        if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.ArrayList") && (rawVarType.equalsToText("java.util.List") || rawVarType.equalsToText("java.util.Collection")) && !ConstructionUtils.isCustomizedEmptyCollectionInitializer(initializer)) {
            collector = "toList()";
        } else if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.HashSet") && (rawVarType.equalsToText("java.util.Set") || rawVarType.equalsToText("java.util.Collection")) && !ConstructionUtils.isCustomizedEmptyCollectionInitializer(initializer)) {
            collector = "toSet()";
        } else {
            PsiExpression arg;
            PsiExpressionList argumentList;
            PsiExpression copy = JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createExpressionFromText(initializer.getText(), (PsiElement)initializer);
            if (copy instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)copy).getArgumentList()) != null && (arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])argumentList.getExpressions())) != null && !(arg.getType() instanceof PsiPrimitiveType)) {
                arg.delete();
            }
            collector = "toCollection(() -> " + copy.getText() + ")";
        }
        return "java.util.stream.Collectors." + collector;
    }

    static class NewListTerminal
    extends RecreateTerminal {
        private final PsiType myResultType;

        NewListTerminal(CollectTerminal upstream, PsiLocalVariable variable, String intermediate, PsiExpression newListExpression, PsiType resultType) {
            super(upstream, variable, intermediate, newListExpression);
            this.myResultType = resultType;
        }

        @Override
        public String generateTerminal() {
            return ".collect(" + CollectMigration.getCollectionCollector(this.myCreateExpression, this.myResultType) + ")";
        }

        @Nullable
        public static NewListTerminal tryWrap(CollectTerminal terminal, PsiElement element) {
            PsiType type2;
            PsiExpression candidate;
            if (terminal.getStatus() == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
                return null;
            }
            PsiLocalVariable collectionVariable = terminal.getTargetVariable();
            String intermediateSteps = CollectMigration.getIntermediateStepsFromInitializer(collectionVariable);
            if (intermediateSteps == null) {
                return null;
            }
            PsiLocalVariable var = null;
            if (element instanceof PsiReturnStatement) {
                candidate = ((PsiReturnStatement)element).getReturnValue();
                type2 = PsiTypesUtil.getMethodReturnType((PsiElement)element);
            } else {
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
                if (assignment != null) {
                    candidate = assignment.getRExpression();
                    type2 = assignment.getType();
                } else if (element instanceof PsiDeclarationStatement) {
                    PsiElement[] elements = ((PsiDeclarationStatement)element).getDeclaredElements();
                    if (elements.length != 1 || !(elements[0] instanceof PsiLocalVariable)) {
                        return null;
                    }
                    var = (PsiLocalVariable)elements[0];
                    candidate = var.getInitializer();
                    type2 = var.getType();
                } else {
                    return null;
                }
                if (candidate != null && CollectMigration.isUsedOutsideOf((PsiVariable)collectionVariable, terminal.usedElements().append((Object)element).toList())) {
                    return null;
                }
            }
            if (!(candidate instanceof PsiNewExpression)) {
                return null;
            }
            PsiExpressionList argumentList = ((PsiNewExpression)candidate).getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1 || !ExpressionUtils.isReferenceTo(args[0], (PsiVariable)collectionVariable)) {
                return null;
            }
            return new NewListTerminal(terminal, var, intermediateSteps, candidate, type2);
        }
    }

    static class ToArrayTerminal
    extends RecreateTerminal {
        private final String mySupplier;

        ToArrayTerminal(CollectTerminal upstream, PsiLocalVariable variable, String intermediate, PsiMethodCallExpression toArrayExpression, String supplier) {
            super(upstream, variable, intermediate, (PsiExpression)toArrayExpression);
            this.mySupplier = supplier;
        }

        @Override
        public String getMethodName() {
            return "toArray";
        }

        @Override
        public String generateTerminal() {
            return ".toArray(" + this.mySupplier + ")";
        }

        @Contract(value="_, null -> null")
        @Nullable
        public static ToArrayTerminal tryWrap(CollectTerminal terminal, PsiElement element) {
            if (terminal.getStatus() == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
                return null;
            }
            if (!(element instanceof PsiExpressionStatement || element instanceof PsiDeclarationStatement || element instanceof PsiReturnStatement)) {
                return null;
            }
            PsiLocalVariable collectionVariable = terminal.getTargetVariable();
            String intermediateSteps = CollectMigration.getIntermediateStepsFromInitializer(collectionVariable);
            if (intermediateSteps == null) {
                return null;
            }
            Collection results = ReferencesSearch.search((PsiElement)collectionVariable, (SearchScope)new LocalSearchScope(element)).findAll();
            if (results.isEmpty() || results.size() > 2) {
                return null;
            }
            PsiMethodCallExpression toArrayCandidate = ((StreamEx)StreamEx.of((Collection)results).map(usage -> ExpressionUtils.getCallForQualifier((PsiExpression)ObjectUtils.tryCast((Object)usage, PsiExpression.class))).nonNull()).findFirst().orElse(null);
            if (toArrayCandidate == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = toArrayCandidate.getMethodExpression();
            if (!"toArray".equals(methodExpression.getReferenceName())) {
                return null;
            }
            if (!(PsiUtil.skipParenthesizedExprUp((PsiElement)toArrayCandidate.getParent()) instanceof PsiReturnStatement) && CollectMigration.isUsedOutsideOf((PsiVariable)collectionVariable, terminal.usedElements().append((Object)toArrayCandidate).toList())) {
                return null;
            }
            PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)toArrayCandidate.getParent()), PsiLocalVariable.class);
            String supplier = ToArrayTerminal.extractSupplier(toArrayCandidate, (PsiVariable)collectionVariable);
            if (supplier == null) {
                return null;
            }
            return new ToArrayTerminal(terminal, var, intermediateSteps, toArrayCandidate, supplier);
        }

        @Nullable
        static String extractSupplier(PsiMethodCallExpression toArrayCandidate, PsiVariable collectionVariable) {
            PsiExpression[] args = toArrayCandidate.getArgumentList().getExpressions();
            if (args.length == 0) {
                return "";
            }
            if (args.length != 1 || !(args[0] instanceof PsiNewExpression)) {
                return null;
            }
            PsiNewExpression newArray = (PsiNewExpression)args[0];
            PsiType arrayType = newArray.getType();
            if (arrayType == null) {
                return null;
            }
            String name = arrayType.getCanonicalText();
            PsiExpression[] dimensions = newArray.getArrayDimensions();
            if (dimensions.length != 1) {
                return null;
            }
            if (ExpressionUtils.isZero(dimensions[0])) {
                return name + "::new";
            }
            if (!(dimensions[0] instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression maybeSizeCall = (PsiMethodCallExpression)dimensions[0];
            if (!StreamApiMigrationInspection.isCallOf(maybeSizeCall, "java.util.Collection", "size")) {
                return null;
            }
            PsiExpression sizeQualifier = maybeSizeCall.getMethodExpression().getQualifierExpression();
            if (!ExpressionUtils.isReferenceTo(sizeQualifier, collectionVariable)) {
                return null;
            }
            return name + "::new";
        }
    }

    static abstract class RecreateTerminal
    extends CollectTerminal {
        private final CollectTerminal myUpstream;
        private final String myIntermediate;
        final PsiExpression myCreateExpression;

        RecreateTerminal(CollectTerminal upstream, PsiLocalVariable variable, String intermediate, PsiExpression createExpression) {
            super(variable, null, ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE);
            this.myUpstream = upstream;
            this.myIntermediate = intermediate;
            this.myCreateExpression = createExpression;
        }

        @Override
        public boolean isTrivial() {
            return false;
        }

        @Override
        @Nullable
        public PsiElement getElementToReplace() {
            return this.getTargetVariable() == null ? this.myCreateExpression : null;
        }

        @Override
        public String generateIntermediate() {
            return this.myUpstream.generateIntermediate() + this.myIntermediate;
        }

        @Override
        public void cleanUp() {
            if (this.myUpstream.getStatus() != ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE) {
                this.myUpstream.getTargetVariable().delete();
            }
            this.myUpstream.cleanUp();
        }
    }

    static class SortingTerminal
    extends CollectTerminal {
        private final CollectTerminal myDownstream;
        private final PsiExpression myComparator;
        private final PsiStatement myStatement;

        SortingTerminal(CollectTerminal downstream, PsiStatement statement2, PsiExpression comparator2) {
            super(downstream.getTargetVariable(), downstream.myLoop, downstream.getStatus());
            this.myDownstream = downstream;
            this.myStatement = statement2;
            this.myComparator = comparator2;
        }

        @Override
        public String getMethodName() {
            return this.myDownstream.getMethodName();
        }

        @Override
        public String generateIntermediate() {
            return this.myDownstream.generateIntermediate() + ".sorted(" + (this.myComparator == null ? "" : this.myComparator.getText()) + ")";
        }

        @Override
        public String generateTerminal() {
            return this.myDownstream.generateTerminal();
        }

        @Override
        StreamEx<PsiElement> usedElements() {
            return this.myDownstream.usedElements().append((Object)this.myStatement);
        }

        @Override
        public void cleanUp() {
            this.myDownstream.cleanUp();
            this.myStatement.delete();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public static CollectTerminal tryWrap(CollectTerminal terminal, PsiElement element) {
            PsiLocalVariable containerVariable = terminal.getTargetVariable();
            if (containerVariable == null || !(element instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)element).getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            if (!"sort".equals(methodExpression.getReferenceName())) {
                return null;
            }
            PsiMethod method2 = methodCall.resolveMethod();
            if (method2 == null) {
                return null;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            PsiExpression containerExpression = null;
            PsiExpression comparatorExpression = null;
            if ("java.util.Collections".equals(containingClass.getQualifiedName()) || "java.util.Arrays".equals(containingClass.getQualifiedName())) {
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length == 1) {
                    containerExpression = args[0];
                } else {
                    if (args.length != 2) return null;
                    containerExpression = args[0];
                    comparatorExpression = args[1];
                }
            } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.List")) {
                containerExpression = methodExpression.getQualifierExpression();
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return null;
                }
                comparatorExpression = args[0];
            }
            if (!(containerExpression instanceof PsiReferenceExpression) || !((PsiReferenceExpression)containerExpression).isReferenceTo((PsiElement)containerVariable)) {
                return null;
            }
            if (!ExpressionUtils.isNullLiteral(comparatorExpression)) return new SortingTerminal(terminal, (PsiStatement)((PsiExpressionStatement)element), comparatorExpression);
            comparatorExpression = null;
            return new SortingTerminal(terminal, (PsiStatement)((PsiExpressionStatement)element), comparatorExpression);
        }
    }

    static class StringBuilderTerminal
    extends CollectTerminal {
        private static final CallMatcher APPEND = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.StringBuilder", "append").parameterCount(1), CallMatcher.instanceCall("java.lang.StringBuffer", "append").parameterCount(1));
        private final PsiVariable myElement;
        private final PsiMethodCallExpression myAppendCall;
        private final PsiMethodCallExpression myFinalAppendCall;
        private final PsiExpression myDelimiter;

        StringBuilderTerminal(PsiLocalVariable variable, PsiLoopStatement loop, PsiVariable element, PsiMethodCallExpression appendCall, PsiExpression delimiter, PsiMethodCallExpression finalAppend) {
            super(variable, loop, ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, loop));
            this.myElement = element;
            this.myAppendCall = appendCall;
            this.myFinalAppendCall = finalAppend;
            this.myDelimiter = delimiter;
        }

        @Override
        public String generateIntermediate() {
            PsiExpression mapping = this.myAppendCall.getArgumentList().getExpressions()[0];
            mapping = JavaPsiFacade.getElementFactory((Project)mapping.getProject()).createExpressionFromText(StringBuilderTerminal.expressionToCharSequence(mapping), (PsiElement)mapping);
            return StreamApiUtil.generateMapOperation(this.myElement, null, (PsiElement)mapping);
        }

        @NotNull
        private static String expressionToCharSequence(@NotNull PsiExpression expression2) {
            PsiType type2 = expression2.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.CharSequence")) {
                Object value2;
                if (expression2 instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)expression2).getValue()) instanceof Character) {
                    return "\"" + StringUtil.escapeStringCharacters((String)value2.toString()) + "\"";
                }
                return "java.lang.String.valueOf(" + expression2.getText() + ")";
            }
            return expression2.getText();
        }

        @Override
        String generateTerminal() {
            String delimiter = this.myDelimiter == null ? "" : StringBuilderTerminal.expressionToCharSequence(this.myDelimiter);
            PsiExpression initializer = this.getTargetVariable().getInitializer();
            String initialText = ConstructionUtils.getStringBuilderInitializerText(initializer);
            String finalText = "\"\"";
            if (this.myFinalAppendCall != null) {
                finalText = StringBuilderTerminal.expressionToCharSequence(this.myFinalAppendCall.getArgumentList().getExpressions()[0]);
            }
            String args = "\"\"".equals(initialText) && "\"\"".equals(finalText) ? delimiter : (delimiter.isEmpty() ? "\"\"" : delimiter) + "," + initialText + "," + finalText;
            return ".collect(java.util.stream.Collectors.joining(" + args + "))";
        }

        @Override
        boolean isTrivial() {
            return this.myDelimiter == null;
        }

        @Override
        void cleanUp() {
            PsiExpression initializer;
            String initialText;
            PsiLocalVariable target = this.getTargetVariable();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)target.getProject());
            target.getTypeElement().replace((PsiElement)factory.createTypeElementFromText("java.lang.String", (PsiElement)target));
            if (this.getStatus() == ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE && (initialText = ConstructionUtils.getStringBuilderInitializerText(initializer = target.getInitializer())) != null) {
                initializer.replace((PsiElement)factory.createExpressionFromText(initialText, (PsiElement)target));
            }
            if (this.myFinalAppendCall != null) {
                if (this.myFinalAppendCall.getParent() instanceof PsiExpressionStatement) {
                    this.myFinalAppendCall.delete();
                } else {
                    PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)this.myFinalAppendCall);
                    PsiExpression qualifier = this.myFinalAppendCall.getMethodExpression().getQualifierExpression();
                    if (nextCall != null && qualifier != null) {
                        nextCall.replace((PsiElement)qualifier);
                    }
                }
            }
            Collection usages = ReferencesSearch.search((PsiElement)target).findAll();
            for (PsiReference usage : usages) {
                PsiMethodCallExpression call;
                PsiElement element = usage.getElement();
                if (!element.isValid() || !(element instanceof PsiExpression) || (call = ExpressionUtils.getCallForQualifier((PsiExpression)element)) == null || !"toString".equals(call.getMethodExpression().getReferenceName())) continue;
                call.replace(element);
            }
        }

        static PsiMethodCallExpression getAfterLoopAppend(PsiLoopStatement loop, PsiVariable target) {
            PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)loop, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
            if (!(next instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)next).getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (APPEND.test(call) && ExpressionUtils.isReferenceTo(call.getMethodExpression().getQualifierExpression(), target)) {
                return call;
            }
            return null;
        }

        static PsiExpression getExpressionComparedToZero(PsiBinaryExpression condition2) {
            if (condition2 == null) {
                return null;
            }
            IElementType tokenType = condition2.getOperationTokenType();
            PsiExpression left = condition2.getLOperand();
            PsiExpression right = condition2.getROperand();
            if (ExpressionUtils.isZero(right)) {
                if (tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.GT)) {
                    return left;
                }
            } else if (ExpressionUtils.isZero(left) && (tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.LT))) {
                return right;
            }
            return null;
        }

        static PsiMethodCallExpression extractDelimiterAppend(TerminalBlock tb, PsiIfStatement ifStatement) {
            StreamApiMigrationInspection.CountingLoopSource source;
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpressionStatement thenBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiExpressionStatement.class);
            if (thenBranch == null) {
                return null;
            }
            PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)ifStatement.getCondition()), PsiBinaryExpression.class);
            PsiExpression comparedToZero = StringBuilderTerminal.getExpressionComparedToZero(condition2);
            if (comparedToZero == null) {
                return null;
            }
            PsiMethodCallExpression maybeLength = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedToZero), PsiMethodCallExpression.class);
            PsiLocalVariable builder = null;
            if (StreamApiMigrationInspection.isCallOf(maybeLength, "java.lang.AbstractStringBuilder", "length") ? (builder = CollectMigration.extractQualifierVariable(tb, maybeLength)) == null : (source = tb.getLastOperation(StreamApiMigrationInspection.CountingLoopSource.class)) == null || !ExpressionUtils.isZero(source.getExpression()) || !ExpressionUtils.isReferenceTo(comparedToZero, source.getVariable())) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)thenBranch.getExpression(), PsiMethodCallExpression.class);
            if (!APPEND.test(call)) {
                return null;
            }
            return builder == null || CollectMigration.extractQualifierVariable(tb, call) == builder ? call : null;
        }

        static StringBuilderTerminal tryExtract(TerminalBlock tb, PsiMethodCallExpression call, PsiMethodCallExpression delimiterAppend) {
            PsiMethodCallExpression nextCall;
            PsiMethodCallExpression usage;
            if (tb.getCountExpression() != null) {
                return null;
            }
            if (!APPEND.test(call)) {
                return null;
            }
            PsiLocalVariable targetBuilder = CollectMigration.extractQualifierVariable(tb, call);
            if (targetBuilder == null) {
                return null;
            }
            if (delimiterAppend != null && !ExpressionUtils.isReferenceTo(delimiterAppend.getMethodExpression().getQualifierExpression(), (PsiVariable)targetBuilder)) {
                return null;
            }
            String initialText = ConstructionUtils.getStringBuilderInitializerText(targetBuilder.getInitializer());
            if (initialText == null) {
                return null;
            }
            PsiMethodCallExpression finalAppend = StringBuilderTerminal.getAfterLoopAppend(tb.getMainLoop(), (PsiVariable)targetBuilder);
            List refs = ((StreamEx)StreamEx.of((Collection)ReferencesSearch.search((PsiElement)targetBuilder).findAll()).map(PsiReference::getElement).remove(e -> PsiTreeUtil.isAncestor((PsiElement)targetBuilder, (PsiElement)e, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)tb.getMainLoop(), (PsiElement)e, (boolean)false))).toList();
            if (!refs.stream().allMatch(PsiExpression.class::isInstance)) {
                return null;
            }
            boolean allowed = StringBuilderTerminal.areReferencesAllowed(finalAppend, refs);
            if (!allowed && refs.size() == 1 && finalAppend == null && APPEND.test(usage = ExpressionUtils.getCallForQualifier((PsiExpression)refs.get(0))) && (nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)usage)) != null && "toString".equals(nextCall.getMethodExpression().getReferenceName())) {
                finalAppend = usage;
                allowed = true;
            }
            if (!allowed) {
                return null;
            }
            PsiExpression delimiter = delimiterAppend == null ? null : delimiterAppend.getArgumentList().getExpressions()[0];
            return new StringBuilderTerminal(targetBuilder, tb.getMainLoop(), tb.getVariable(), call, delimiter, finalAppend);
        }

        private static boolean areReferencesAllowed(PsiMethodCallExpression finalAppend, List<PsiElement> refs) {
            return StreamEx.of(refs).select(PsiExpression.class).allMatch(expression2 -> {
                PsiElement parent;
                PsiMethodCallExpression usage = ExpressionUtils.getCallForQualifier(expression2);
                if (usage != null) {
                    if (usage == finalAppend) {
                        return true;
                    }
                    PsiExpression[] usageArgs = usage.getArgumentList().getExpressions();
                    String name = usage.getMethodExpression().getReferenceName();
                    if (usageArgs.length == 0 && ("toString".equals(name) || "length".equals(name))) {
                        return true;
                    }
                }
                if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                    return true;
                }
                return parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUSEQ);
            });
        }
    }

    static class ToMapTerminal
    extends CollectTerminal {
        private final PsiMethodCallExpression myMapUpdateCall;
        private final PsiVariable myElementVariable;

        ToMapTerminal(PsiMethodCallExpression call, PsiVariable elementVariable, PsiLocalVariable variable, PsiLoopStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            super(variable, loop, status);
            this.myMapUpdateCall = call;
            this.myElementVariable = elementVariable;
        }

        @Override
        public String generateTerminal() {
            String merger;
            PsiExpression[] args = this.myMapUpdateCall.getArgumentList().getExpressions();
            LOG.assertTrue(args.length >= 2);
            String methodName = this.myMapUpdateCall.getMethodExpression().getReferenceName();
            LOG.assertTrue(methodName != null);
            Project project2 = this.myMapUpdateCall.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            String aVar = codeStyleManager.suggestUniqueVariableName("a", (PsiElement)this.myMapUpdateCall, true);
            String bVar = codeStyleManager.suggestUniqueVariableName("b", (PsiElement)this.myMapUpdateCall, true);
            switch (methodName) {
                case "put": {
                    merger = "(" + aVar + "," + bVar + ")->" + bVar;
                    break;
                }
                case "putIfAbsent": {
                    merger = "(" + aVar + "," + bVar + ")->" + aVar;
                    break;
                }
                case "merge": {
                    LOG.assertTrue(args.length == 3);
                    merger = args[2].getText();
                    break;
                }
                default: {
                    return null;
                }
            }
            StringBuilder collector = new StringBuilder(".collect(java.util.stream.Collectors.toMap(");
            collector.append(LambdaUtil.createLambda((PsiVariable)this.myElementVariable, (PsiExpression)args[0])).append(',').append(LambdaUtil.createLambda((PsiVariable)this.myElementVariable, (PsiExpression)args[1])).append(',').append(merger);
            PsiExpression initializer = this.getTargetVariable().getInitializer();
            LOG.assertTrue(initializer != null);
            if (!CollectMigration.isHashMap(this.getTargetVariable())) {
                collector.append(",()->").append(initializer.getText());
            }
            collector.append("))");
            return collector.toString();
        }

        @Nullable
        static ToMapTerminal tryExtract(TerminalBlock tb, PsiMethodCallExpression call) {
            if (tb.getCountExpression() != null || !StreamApiMigrationInspection.isCallOf(call, "java.util.Map", "merge", "put", "putIfAbsent")) {
                return null;
            }
            PsiLocalVariable variable = CollectMigration.extractQualifierVariable(tb, call);
            if (!CollectMigration.hasLambdaCompatibleEmptyInitializer(variable)) {
                return null;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, tb.getMainLoop());
            return new ToMapTerminal(call, tb.getVariable(), variable, tb.getMainLoop(), status);
        }
    }

    static class GroupingTerminal
    extends CollectTerminal {
        private final AddingTerminal myDownstream;
        private final PsiExpression myKeyExpression;

        GroupingTerminal(AddingTerminal downstream, PsiLocalVariable target, PsiExpression expression2, ControlFlowUtils.InitializerUsageStatus status) {
            super(target, downstream.myLoop, status);
            this.myDownstream = downstream;
            this.myKeyExpression = expression2;
        }

        @Override
        public boolean isTrivial() {
            return false;
        }

        @Override
        public String generateTerminal() {
            String downstreamCollector = this.myDownstream.generateCollector();
            PsiVariable elementVariable = this.myDownstream.getElementVariable();
            if (!ExpressionUtils.isReferenceTo(this.myDownstream.getMapping(), this.myDownstream.getElementVariable())) {
                downstreamCollector = "java.util.stream.Collectors.mapping(" + this.myDownstream.getElementVariable().getName() + "->" + this.myDownstream.getMapping().getText() + "," + downstreamCollector + ")";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(".collect(java.util.stream.Collectors.groupingBy(").append(LambdaUtil.createLambda((PsiVariable)elementVariable, (PsiExpression)this.myKeyExpression));
            PsiExpression initializer = this.getTargetVariable().getInitializer();
            LOG.assertTrue(initializer != null);
            if (!CollectMigration.isHashMap(this.getTargetVariable())) {
                builder.append(",()->").append(initializer.getText()).append(",").append(downstreamCollector);
            } else if (!"java.util.stream.Collectors.toList()".equals(downstreamCollector)) {
                builder.append(",").append(downstreamCollector);
            }
            builder.append("))");
            return builder.toString();
        }

        @Nullable
        public static GroupingTerminal tryExtract(TerminalBlock tb, PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifierCall;
            if (!StreamApiMigrationInspection.isCallOf(call, "java.util.Collection", "add")) {
                return null;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 instanceof PsiMethodCallExpression && tb.getCountExpression() == null && StreamApiMigrationInspection.isCallOf(qualifierCall = (PsiMethodCallExpression)qualifierExpression2, "java.util.Map", "computeIfAbsent")) {
                PsiLocalVariable variable;
                PsiExpression[] args = qualifierCall.getArgumentList().getExpressions();
                if (args.length != 2 || !(args[1] instanceof PsiLambdaExpression)) {
                    return null;
                }
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)args[1];
                PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
                if (ConstructionUtils.isEmptyCollectionInitializer(body2) && CollectMigration.hasLambdaCompatibleEmptyInitializer(variable = CollectMigration.extractQualifierVariable(tb, qualifierCall))) {
                    PsiType mapType = variable.getType();
                    PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)mapType, (String)"java.util.Map", (int)1, (boolean)false);
                    if (valueType == null) {
                        return null;
                    }
                    AddingTerminal adding = new AddingTerminal(valueType, body2, tb.getVariable(), call);
                    ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, tb.getMainLoop());
                    return new GroupingTerminal(adding, variable, args[0], status);
                }
            }
            return null;
        }
    }

    static class AddingAllTerminal
    extends AddingTerminal {
        private final PsiMethodCallExpression myAddAllCall;

        AddingAllTerminal(PsiLocalVariable target, PsiVariable element, PsiMethodCallExpression addAllCall, PsiLoopStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            super(target, element, null, loop, status);
            this.myAddAllCall = addAllCall;
        }

        @Override
        public String generateIntermediate() {
            PsiType[] typeParameters = this.myAddAllCall.getMethodExpression().getTypeParameters();
            String generic = "";
            if (typeParameters.length == 1) {
                generic = "<" + typeParameters[0].getCanonicalText() + ">";
            }
            String method2 = MethodCallUtils.isVarArgCall(this.myAddAllCall) ? "java.util.stream.Stream." + generic + "of" : "java.util.Arrays." + generic + "stream";
            String lambda2 = this.myElement.getName() + "->" + method2 + "(" + ((StreamEx)StreamEx.of((Object[])this.myAddAllCall.getArgumentList().getExpressions()).skip(1L)).map(PsiElement::getText).joining((CharSequence)",") + ")";
            return this.myElement.getType() instanceof PsiPrimitiveType ? ".mapToObj(" + lambda2 + ").flatMap(" + "java.util.function.Function" + ".identity())" : ".flatMap(" + lambda2 + ")";
        }

        @Nullable
        static AddingAllTerminal tryExtractAddAll(TerminalBlock tb, PsiMethodCallExpression call) {
            if (tb.getCountExpression() != null || !MethodCallUtils.isCallToStaticMethod(call, "java.util.Collections", "addAll", 2)) {
                return null;
            }
            Object[] args = call.getArgumentList().getExpressions();
            if (args.length < 2) {
                return null;
            }
            PsiReferenceExpression collectionReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)args[0], PsiReferenceExpression.class);
            if (collectionReference == null || tb.dependsOn((PsiExpression)collectionReference)) {
                return null;
            }
            PsiLocalVariable target = (PsiLocalVariable)ObjectUtils.tryCast((Object)collectionReference.resolve(), PsiLocalVariable.class);
            if (target == null || ((StreamEx)StreamEx.of((Object[])args).skip(1L)).anyMatch(arg -> VariableAccessUtils.variableIsUsed((PsiVariable)target, (PsiElement)arg))) {
                return null;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)target, tb.getMainLoop());
            return new AddingAllTerminal(target, tb.getVariable(), call, tb.getMainLoop(), status);
        }
    }

    static class AddingTerminal
    extends CollectTerminal {
        final PsiType myTargetType;
        final PsiExpression myInitializer;
        final PsiVariable myElement;
        final PsiMethodCallExpression myAddCall;

        AddingTerminal(@NotNull PsiLocalVariable target, PsiVariable element, PsiMethodCallExpression addCall, PsiLoopStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            super(target, loop, CollectMigration.hasLambdaCompatibleEmptyInitializer(target) ? status : ControlFlowUtils.InitializerUsageStatus.UNKNOWN);
            this.myTargetType = target.getType();
            this.myInitializer = target.getInitializer();
            this.myElement = element;
            this.myAddCall = addCall;
        }

        AddingTerminal(@NotNull PsiType targetType, PsiExpression initializer, PsiVariable element, PsiMethodCallExpression addCall) {
            super(null, null, ControlFlowUtils.InitializerUsageStatus.UNKNOWN);
            this.myTargetType = targetType;
            this.myInitializer = initializer;
            this.myElement = element;
            this.myAddCall = addCall;
        }

        PsiVariable getElementVariable() {
            return this.myElement;
        }

        PsiExpression getMapping() {
            return this.myAddCall.getArgumentList().getExpressions()[0];
        }

        @Override
        public String generateIntermediate() {
            PsiType addedType = CollectMigration.getAddedElementType(this.myAddCall);
            PsiExpression mapping = this.getMapping();
            if (addedType == null) {
                addedType = mapping.getType();
            }
            return StreamApiUtil.generateMapOperation(this.myElement, addedType, (PsiElement)mapping);
        }

        public String generateCollector() {
            return CollectMigration.getCollectionCollector(this.myInitializer, this.myTargetType);
        }

        @Override
        public String generateTerminal() {
            return ".collect(" + this.generateCollector() + ")";
        }

        @Nullable
        static AddingTerminal tryExtract(TerminalBlock tb, PsiMethodCallExpression call) {
            if (!StreamApiMigrationInspection.isCallOf(call, "java.util.Collection", "add")) {
                return null;
            }
            PsiExpression qualifierExpression2 = call.getMethodExpression().getQualifierExpression();
            if (qualifierExpression2 == null) {
                return null;
            }
            PsiExpression count = tb.getCountExpression();
            PsiLocalVariable variable = CollectMigration.extractQualifierVariable(tb, call);
            if (variable != null) {
                ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, tb.getMainLoop());
                AddingTerminal terminal = new AddingTerminal(variable, tb.getVariable(), call, tb.getMainLoop(), status);
                if (count == null) {
                    return terminal;
                }
                if (!(count instanceof PsiMethodCallExpression)) {
                    return null;
                }
                PsiMethodCallExpression sizeCall = (PsiMethodCallExpression)count;
                PsiExpression sizeQualifier = sizeCall.getMethodExpression().getQualifierExpression();
                if (StreamApiMigrationInspection.isCallOf(sizeCall, "java.util.Collection", "size") && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(sizeQualifier, qualifierExpression2) && InheritanceUtil.isInheritor((PsiClass)PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType()), (String)"java.util.List")) {
                    return terminal;
                }
            }
            return null;
        }
    }

    static abstract class CollectTerminal {
        private final PsiLocalVariable myTargetVariable;
        private final ControlFlowUtils.InitializerUsageStatus myStatus;
        final PsiLoopStatement myLoop;

        protected CollectTerminal(PsiLocalVariable variable, PsiLoopStatement loop, ControlFlowUtils.InitializerUsageStatus status) {
            this.myTargetVariable = variable;
            this.myLoop = loop;
            this.myStatus = status;
        }

        @Nullable
        PsiElement getElementToReplace() {
            return null;
        }

        String getMethodName() {
            return "collect";
        }

        PsiLocalVariable getTargetVariable() {
            return this.myTargetVariable;
        }

        String generateIntermediate() {
            return "";
        }

        abstract String generateTerminal();

        StreamEx<PsiElement> usedElements() {
            return StreamEx.ofNullable((Object)this.myLoop);
        }

        public ControlFlowUtils.InitializerUsageStatus getStatus() {
            return this.myStatus;
        }

        void cleanUp() {
        }

        boolean isTrivial() {
            return this.generateIntermediate().isEmpty();
        }
    }
}

