/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class CountMigration
extends BaseStreamApiMigration {
    CountMigration() {
        super("count()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body2, @NotNull TerminalBlock tb) {
        PsiExpression operand2;
        PsiExpression expression2 = tb.getSingleExpression(PsiExpression.class);
        if (expression2 == null) {
            expression2 = tb.getCountExpression();
        }
        if (!((operand2 = StreamApiMigrationInspection.extractIncrementedLValue(expression2)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand2).resolve();
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        return CountMigration.replaceWithNumericAddition(tb.getMainLoop(), (PsiVariable)var, tb.generate() + ".count()", (PsiType)PsiType.LONG);
    }
}

