/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class MigrateToStreamFix
implements LocalQuickFix {
    private BaseStreamApiMigration myMigration;

    protected MigrateToStreamFix(BaseStreamApiMigration migration) {
        this.myMigration = migration;
    }

    @Nls
    @NotNull
    public String getName() {
        return "Replace with " + this.myMigration.getReplacement();
    }

    @NotNull
    public String getFamilyName() {
        return "Replace with Stream API equivalent";
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PsiLoopStatement) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)element;
            StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
            PsiStatement body2 = loopStatement.getBody();
            if (body2 == null || source == null) {
                return;
            }
            TerminalBlock tb = TerminalBlock.from(source, body2);
            PsiElement result2 = this.myMigration.migrate(project2, body2, tb);
            if (result2 != null) {
                tb.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
                MigrateToStreamFix.simplifyAndFormat(project2, result2);
            }
        }
    }

    static void simplifyAndFormat(@NotNull Project project2, PsiElement result2) {
        if (result2 == null) {
            return;
        }
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result2);
        PsiDiamondTypeUtil.removeRedundantTypeArguments(result2);
        result2 = SimplifyStreamApiCallChainsInspection.simplifyStreamExpressions(result2);
        CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result2));
    }
}

