/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

class SumMigration
extends BaseStreamApiMigration {
    SumMigration() {
        super("sum()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body2, @NotNull TerminalBlock tb) {
        PsiType addendType;
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractAccumulator(assignment);
        if (var == null) {
            return null;
        }
        PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
        if (addend == null) {
            return null;
        }
        PsiType type2 = var.getType();
        if (!(type2 instanceof PsiPrimitiveType) || type2.equals(PsiType.FLOAT)) {
            return null;
        }
        if (!type2.equals(PsiType.DOUBLE) && !type2.equals(PsiType.LONG)) {
            type2 = PsiType.INT;
        }
        if ((addendType = addend.getType()) != null && !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)addendType)) {
            addend = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("(" + type2.getCanonicalText() + ")" + ParenthesesUtils.getText(addend, 5), (PsiElement)addend);
        }
        String stream = tb.add(new StreamApiMigrationInspection.MapOp(addend, tb.getVariable(), type2)).generate() + ".sum()";
        return SumMigration.replaceWithNumericAddition(tb.getMainLoop(), var, stream, type2);
    }
}

