/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.IntArrayList;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TerminalBlock {
    private static final Logger LOG = Logger.getInstance(TerminalBlock.class);
    @NotNull
    private final PsiVariable myVariable;
    @NotNull
    private final StreamApiMigrationInspection.Operation[] myOperations;
    @NotNull
    private final PsiStatement[] myStatements;

    private TerminalBlock(@NotNull StreamApiMigrationInspection.Operation[] operations, @NotNull PsiVariable variable, PsiStatement ... statements) {
        LOG.assertTrue(operations.length > 0);
        for (StreamApiMigrationInspection.Operation operation : operations) {
            Objects.requireNonNull(operation);
        }
        for (StreamApiMigrationInspection.Operation operation : statements) {
            Objects.requireNonNull(operation);
        }
        this.myVariable = variable;
        while (true) {
            PsiStatement[] psiStatementArray;
            if (statements.length == 1 && statements[0] instanceof PsiBlockStatement) {
                statements = ((PsiBlockStatement)statements[0]).getCodeBlock().getStatements();
                continue;
            }
            if (statements.length != 1 || !(statements[0] instanceof PsiLabeledStatement)) break;
            PsiStatement statement3 = ((PsiLabeledStatement)statements[0]).getStatement();
            if (statement3 == null) {
                psiStatementArray = PsiStatement.EMPTY_ARRAY;
            } else {
                PsiStatement[] psiStatementArray2 = new PsiStatement[1];
                psiStatementArray = psiStatementArray2;
                psiStatementArray2[0] = statement3;
            }
            statements = psiStatementArray;
        }
        this.myStatements = statements;
        this.myOperations = operations;
    }

    private TerminalBlock(@Nullable TerminalBlock previousBlock, @NotNull StreamApiMigrationInspection.Operation operation, @NotNull PsiVariable variable, PsiStatement ... statements) {
        StreamApiMigrationInspection.Operation[] operationArray;
        if (previousBlock == null) {
            StreamApiMigrationInspection.Operation[] operationArray2 = new StreamApiMigrationInspection.Operation[1];
            operationArray = operationArray2;
            operationArray2[0] = operation;
        } else {
            operationArray = (StreamApiMigrationInspection.Operation[])ArrayUtil.append((Object[])previousBlock.myOperations, (Object)operation);
        }
        this(operationArray, variable, statements);
    }

    Collection<PsiStatement> findExitPoints(ControlFlow controlFlow) {
        int startOffset = controlFlow.getStartOffset((PsiElement)this.myStatements[0]);
        int endOffset = controlFlow.getEndOffset((PsiElement)this.myStatements[this.myStatements.length - 1]);
        if (startOffset < 0 || endOffset < 0) {
            return null;
        }
        return ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
    }

    PsiStatement getSingleStatement() {
        return this.myStatements.length == 1 ? this.myStatements[0] : null;
    }

    @NotNull
    PsiStatement[] getStatements() {
        return this.myStatements;
    }

    @Nullable
    <T extends PsiExpression> T getSingleExpression(Class<T> wantedType) {
        PsiStatement statement2 = this.getSingleStatement();
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpression expression2 = ((PsiExpressionStatement)statement2).getExpression();
            return (T)((PsiExpression)ObjectUtils.tryCast((Object)expression2, wantedType));
        }
        return null;
    }

    @Nullable
    PsiMethodCallExpression getSingleMethodCall() {
        return this.getSingleExpression(PsiMethodCallExpression.class);
    }

    @Nullable
    private TerminalBlock extractFilter() {
        PsiStatement first;
        PsiStatement thenBranch;
        PsiIfStatement ifStatement;
        if (this.getSingleStatement() instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)this.getSingleStatement()).getElseBranch() == null && ifStatement.getCondition() != null && (thenBranch = ifStatement.getThenBranch()) != null) {
            return new TerminalBlock(this, new StreamApiMigrationInspection.FilterOp(ifStatement.getCondition(), this.myVariable, false), this.myVariable, thenBranch);
        }
        if (this.myStatements.length >= 1 && (first = this.myStatements[0]) instanceof PsiIfStatement) {
            PsiStatement[] statements;
            PsiIfStatement ifStatement2 = (PsiIfStatement)first;
            if (ifStatement2.getCondition() == null) {
                return null;
            }
            PsiStatement branch = ifStatement2.getThenBranch();
            if (branch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements()).length == 1) {
                branch = statements[0];
            }
            if (!(branch instanceof PsiContinueStatement) || ((PsiContinueStatement)branch).getLabelIdentifier() != null) {
                return null;
            }
            if (ifStatement2.getElseBranch() != null) {
                statements = (PsiStatement[])this.myStatements.clone();
                statements[0] = ifStatement2.getElseBranch();
            } else {
                statements = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
            }
            return new TerminalBlock(this, new StreamApiMigrationInspection.FilterOp(ifStatement2.getCondition(), this.myVariable, true), this.myVariable, statements);
        }
        return null;
    }

    @Nullable
    private TerminalBlock extractOperation() {
        TerminalBlock withLimit;
        StreamApiMigrationInspection.Operation op2;
        TerminalBlock withFilter = this.extractFilter();
        if (withFilter != null) {
            return withFilter;
        }
        if (this.getSingleStatement() instanceof PsiLoopStatement) {
            PsiStatement[] statements;
            PsiStatement lastStatement;
            PsiLoopStatement loopStatement = (PsiLoopStatement)this.getSingleStatement();
            StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
            PsiStatement body2 = loopStatement.getBody();
            if (source == null || body2 == null) {
                return null;
            }
            op2 = new StreamApiMigrationInspection.FlatMapOp(source, this.myVariable);
            TerminalBlock withFlatMap = new TerminalBlock(this, op2, source.getVariable(), body2);
            if (!VariableAccessUtils.variableIsUsed(this.myVariable, (PsiElement)body2)) {
                return withFlatMap;
            }
            TerminalBlock withFlatMapFilter = withFlatMap.extractFilter();
            if (withFlatMapFilter != null && !withFlatMapFilter.isEmpty() && (lastStatement = (statements = withFlatMapFilter.getStatements())[statements.length - 1]) instanceof PsiBreakStatement && ((StreamApiMigrationInspection.FlatMapOp)op2).breaksMe((PsiBreakStatement)lastStatement) && ReferencesSearch.search((PsiElement)withFlatMapFilter.getVariable(), (SearchScope)new LocalSearchScope((PsiElement[])statements)).findFirst() == null) {
                return new TerminalBlock(this, new StreamApiMigrationInspection.CompoundFilterOp((StreamApiMigrationInspection.FilterOp)withFlatMapFilter.getLastOperation(), (StreamApiMigrationInspection.FlatMapOp)op2), this.myVariable, Arrays.copyOfRange(statements, 0, statements.length - 1));
            }
        }
        if (this.myStatements.length >= 1) {
            PsiExpression rValue;
            PsiLocalVariable declaredVar;
            PsiDeclarationStatement decl;
            PsiElement[] elements;
            PsiStatement[] leftOver;
            PsiStatement first = this.myStatements[0];
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)first.getContainingFile()) && first instanceof PsiIfStatement) {
                PsiStatement thenStatement;
                PsiIfStatement ifStatement = (PsiIfStatement)first;
                PsiExpression condition2 = ifStatement.getCondition();
                if (ifStatement.getElseBranch() == null && condition2 != null && ControlFlowUtils.statementBreaksLoop(thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), this.getMainLoop())) {
                    StreamApiMigrationInspection.TakeWhileOp op3 = new StreamApiMigrationInspection.TakeWhileOp(condition2, this.myVariable, true);
                    leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                    return new TerminalBlock(this, op3, this.myVariable, leftOver);
                }
            }
            if (first instanceof PsiDeclarationStatement && (elements = (decl = (PsiDeclarationStatement)first).getDeclaredElements()).length == 1 && (declaredVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class)) != null && StreamApiUtil.isSupportedStreamElement(declaredVar.getType())) {
                PsiExpression initializer = declaredVar.getInitializer();
                leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                if (initializer != null && ReferencesSearch.search((PsiElement)this.myVariable, (SearchScope)new LocalSearchScope((PsiElement[])leftOver)).findFirst() == null) {
                    StreamApiMigrationInspection.MapOp op4 = new StreamApiMigrationInspection.MapOp(initializer, this.myVariable, declaredVar.getType());
                    return new TerminalBlock(this, op4, (PsiVariable)declaredVar, leftOver);
                }
            }
            if ((rValue = ExpressionUtils.getAssignmentTo((PsiElement)first, this.myVariable)) != null && this.operations().allMatch(op -> op.canReassignVariable(this.myVariable))) {
                PsiStatement[] leftOver2 = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                op2 = new StreamApiMigrationInspection.MapOp(rValue, this.myVariable, this.myVariable.getType());
                return new TerminalBlock(this, op2, this.myVariable, leftOver2);
            }
        }
        return (withLimit = this.tryPeelLimit(true)) == this ? null : withLimit;
    }

    private TerminalBlock tryPeelLimit(boolean dedicatedCounter) {
        PsiExpression limit;
        if (this.myStatements.length == 0) {
            return this;
        }
        TerminalBlock tb = this;
        PsiStatement[] statements = new PsiStatement[]{};
        if (this.myStatements.length > 1) {
            int count = this.myStatements.length - 1;
            if (this.myStatements[count] instanceof PsiBreakStatement || this.myStatements[count] instanceof PsiReturnStatement) {
                --count;
            }
            statements = Arrays.copyOfRange(this.myStatements, 0, count);
            tb = new TerminalBlock(this.myOperations, this.myVariable, Arrays.copyOfRange(this.myStatements, count, this.myStatements.length)).extractFilter();
        }
        if (tb == null || !ControlFlowUtils.statementBreaksLoop(tb.getSingleStatement(), this.getMainLoop())) {
            return this;
        }
        StreamApiMigrationInspection.FilterOp filter = tb.getLastOperation(StreamApiMigrationInspection.FilterOp.class);
        if (filter == null) {
            return this;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)filter.getExpression()), PsiBinaryExpression.class);
        if (binOp == null || !ComparisonUtils.isComparison((PsiExpression)binOp)) {
            return this;
        }
        String comparison = filter.isNegated() ? ComparisonUtils.getNegatedComparison(binOp.getOperationTokenType()) : binOp.getOperationSign().getText();
        boolean flipped = false;
        int delta = 0;
        switch (comparison) {
            case "==": 
            case ">=": {
                break;
            }
            case ">": {
                delta = 1;
                break;
            }
            case "<": {
                delta = 1;
                flipped = true;
                break;
            }
            case "<=": {
                flipped = true;
                break;
            }
            default: {
                return this;
            }
        }
        PsiExpression countExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)(flipped ? binOp.getROperand() : binOp.getLOperand()));
        if (countExpression == null || VariableAccessUtils.variableIsUsed(this.myVariable, (PsiElement)countExpression)) {
            return this;
        }
        PsiExpression incrementedValue = StreamApiMigrationInspection.extractIncrementedLValue(countExpression);
        PsiLocalVariable var = null;
        if (dedicatedCounter) {
            if (!(incrementedValue instanceof PsiReferenceExpression)) {
                return this;
            }
            var = (PsiLocalVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)incrementedValue).resolve(), PsiLocalVariable.class);
            if (var == null || !ExpressionUtils.isZero(var.getInitializer()) || ReferencesSearch.search((PsiElement)var).findAll().size() != 1) {
                return this;
            }
        }
        PsiExpression psiExpression = limit = flipped ? binOp.getLOperand() : binOp.getROperand();
        if (!ExpressionUtils.isSimpleExpression(limit) || VariableAccessUtils.variableIsUsed(this.myVariable, (PsiElement)limit)) {
            return this;
        }
        PsiType type2 = limit.getType();
        if (!PsiType.INT.equals((Object)type2) && !PsiType.LONG.equals((Object)type2)) {
            return this;
        }
        if (countExpression instanceof PsiPostfixExpression) {
            ++delta;
        }
        TerminalBlock block = new TerminalBlock(Arrays.copyOf(tb.myOperations, tb.myOperations.length - 1), this.myVariable, statements);
        if (incrementedValue == null) {
            TerminalBlock newBlock;
            while ((newBlock = block.extractOperation()) != null && !(newBlock.getLastOperation() instanceof StreamApiMigrationInspection.FlatMapOp)) {
                block = newBlock;
            }
        }
        return block.add(new StreamApiMigrationInspection.LimitOp(block.getVariable(), countExpression, limit, var, delta));
    }

    @Nullable
    private PsiLocalVariable extractCollectionAdditionVariable() {
        PsiMethodCallExpression call = this.getSingleMethodCall();
        if (!StreamApiMigrationInspection.isCallOf(call, "java.util.Collection", "add")) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1 || !ExpressionUtils.isReferenceTo(args[0], this.myVariable)) {
            return null;
        }
        PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression().getQualifierExpression(), PsiReferenceExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiLocalVariable.class);
        if (var == null) {
            return null;
        }
        PsiNewExpression initializer = (PsiNewExpression)ObjectUtils.tryCast((Object)var.getInitializer(), PsiNewExpression.class);
        if (initializer == null) {
            return null;
        }
        PsiExpressionList argumentList = initializer.getArgumentList();
        if (argumentList == null || argumentList.getExpressions().length != 0 || ControlFlowUtils.getInitializerUsageStatus((PsiVariable)var, this.getMainLoop()) == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
            return null;
        }
        return var;
    }

    @NotNull
    private TerminalBlock replace(StreamApiMigrationInspection.Operation orig, StreamApiMigrationInspection.Operation replacement) {
        int idx = ArrayUtil.indexOf((Object[])this.myOperations, (Object)orig);
        if (idx == -1) {
            throw new NoSuchElementException(orig.toString());
        }
        StreamApiMigrationInspection.Operation[] ops = (StreamApiMigrationInspection.Operation[])this.myOperations.clone();
        ops[idx] = replacement;
        return new TerminalBlock(ops, this.myVariable, this.myStatements);
    }

    TerminalBlock add(StreamApiMigrationInspection.Operation op) {
        return new TerminalBlock(this, op, this.myVariable, this.myStatements);
    }

    private TerminalBlock tryExtractDistinct() {
        PsiLocalVariable collectionVariable = this.extractCollectionAdditionVariable();
        if (collectionVariable == null) {
            return this;
        }
        for (int idx = this.myOperations.length - 1; idx > 0; --idx) {
            StreamApiMigrationInspection.Operation op = this.myOperations[idx];
            if (op instanceof StreamApiMigrationInspection.FilterOp) {
                PsiExpression[] conditionArgs;
                PsiMethodCallExpression conditionCall;
                StreamApiMigrationInspection.FilterOp filter = (StreamApiMigrationInspection.FilterOp)op;
                PsiExpression condition2 = filter.getExpression();
                if (BoolUtils.isNegation(condition2)) {
                    if (filter.isNegated()) continue;
                    condition2 = BoolUtils.getNegated(condition2);
                } else if (!filter.isNegated()) continue;
                if (!(condition2 instanceof PsiMethodCallExpression) || !ExpressionUtils.isReferenceTo((conditionCall = (PsiMethodCallExpression)condition2).getMethodExpression().getQualifierExpression(), (PsiVariable)collectionVariable) || !StreamApiMigrationInspection.isCallOf(conditionCall, "java.util.Collection", "contains") || (conditionArgs = conditionCall.getArgumentList().getExpressions()).length != 1 || !ExpressionUtils.isReferenceTo(conditionArgs[0], this.myVariable)) continue;
                return this.replace(op, new StreamApiMigrationInspection.DistinctOp(this.myVariable));
            }
            if (!(op instanceof StreamApiMigrationInspection.LimitOp)) break;
        }
        return this;
    }

    @NotNull
    StreamApiMigrationInspection.Operation getLastOperation() {
        return this.myOperations[this.myOperations.length - 1];
    }

    @Nullable
    <T extends StreamApiMigrationInspection.Operation> T getLastOperation(Class<T> clazz) {
        return (T)((StreamApiMigrationInspection.Operation)ObjectUtils.tryCast((Object)this.getLastOperation(), clazz));
    }

    @Nullable
    PsiExpression getCountExpression() {
        StreamApiMigrationInspection.LimitOp limitOp = this.getLastOperation(StreamApiMigrationInspection.LimitOp.class);
        if (limitOp != null && limitOp.getCounterVariable() == null) {
            return limitOp.getCountExpression();
        }
        return null;
    }

    @NotNull
    TerminalBlock extractOperations() {
        return StreamEx.iterate((Object)this, Objects::nonNull, TerminalBlock::extractOperation).reduce((a, b) -> b).orElse(this);
    }

    @NotNull
    PsiVariable getVariable() {
        return this.myVariable;
    }

    boolean hasOperations() {
        return this.myOperations.length > 1;
    }

    boolean isEmpty() {
        return this.myStatements.length == 0;
    }

    @NotNull
    StreamEx<StreamApiMigrationInspection.Operation> operations() {
        return StreamEx.ofReversed((Object[])this.myOperations);
    }

    PsiLoopStatement getMainLoop() {
        return ((StreamApiMigrationInspection.StreamSource)this.myOperations[0]).getLoop();
    }

    StreamEx<PsiExpression> intermediateExpressions() {
        return StreamEx.of((Object[])this.myOperations, (int)1, (int)this.myOperations.length).flatMap(StreamApiMigrationInspection.Operation::expressions);
    }

    StreamEx<PsiExpression> intermediateAndSourceExpressions() {
        return this.operations().flatMap(StreamApiMigrationInspection.Operation::expressions);
    }

    PsiElement convertToElement(PsiElementFactory factory) {
        if (this.myStatements.length == 1) {
            return this.myStatements[0];
        }
        PsiCodeBlock block = factory.createCodeBlock();
        for (PsiStatement statement2 : this.myStatements) {
            block.add((PsiElement)statement2);
        }
        return block;
    }

    String generate() {
        return this.generate(false);
    }

    String generate(boolean noStreamForEmpty) {
        if (noStreamForEmpty && this.myOperations.length == 1 && this.myOperations[0] instanceof StreamApiMigrationInspection.CollectionStream) {
            return ParenthesesUtils.getText(this.myOperations[0].getExpression(), 2);
        }
        return StreamEx.of((Object[])this.myOperations).map(StreamApiMigrationInspection.Operation::createReplacement).joining();
    }

    @NotNull
    static TerminalBlock from(StreamApiMigrationInspection.StreamSource source, @NotNull PsiStatement body2) {
        return new TerminalBlock(null, source, source.myVariable, body2).extractOperations().tryPeelLimit(false).tryExtractDistinct();
    }

    boolean dependsOn(PsiExpression qualifier) {
        return this.intermediateExpressions().anyMatch(expression2 -> StreamApiMigrationInspection.isExpressionDependsOnUpdatedCollections(expression2, qualifier));
    }

    boolean isReferencedInOperations(PsiVariable variable) {
        return this.intermediateAndSourceExpressions().anyMatch(expr -> VariableAccessUtils.variableIsUsed(variable, (PsiElement)expr));
    }
}

