/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FunctionHelper {
    private static final Logger LOG = Logger.getInstance(FunctionHelper.class);
    private String myResultType;

    FunctionHelper(PsiType resultType) {
        this.myResultType = resultType.getCanonicalText();
    }

    String getResultType() {
        return this.myResultType;
    }

    final String getText() {
        return this.getExpression().getText();
    }

    String getStatementText() {
        return this.getText() + ";\n";
    }

    abstract PsiExpression getExpression();

    String tryLightTransform(PsiType type2) {
        return null;
    }

    abstract void transform(StreamToLoopInspection.StreamToLoopReplacementContext var1, String ... var2);

    void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
    }

    void registerReusedElements(Consumer<PsiElement> consumer2) {
    }

    @Nullable
    String getParameterName(int index) {
        return null;
    }

    void preprocessVariable(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var, int index) {
        String name = this.getParameterName(index);
        if (name != null) {
            var.addBestNameCandidate(name);
        }
    }

    void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
    }

    List<String> suggestFinalOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, String desiredName, String worstCaseName) {
        List<String> candidates = Arrays.asList(JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, (String)desiredName, (PsiExpression)context.createExpression((String)this.getText()), (PsiType)context.createType((String)this.getResultType())).names);
        if (candidates.isEmpty() && worstCaseName != null) {
            candidates = Collections.singletonList(worstCaseName);
        }
        return candidates;
    }

    private static void suggestFromExpression(StreamVariable var, Project project2, PsiExpression expression2) {
        SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project2).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, expression2, null, true);
        for (String name : info.names) {
            var.addOtherNameCandidate(name);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    static FunctionHelper create(PsiExpression expression2, int paramCount) {
        return FunctionHelper.create(expression2, paramCount, false);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    static FunctionHelper create(PsiExpression expression2, int paramCount, boolean allowReturns) {
        PsiType type2;
        if (expression2 == null) {
            return null;
        }
        PsiType psiType = type2 = expression2 instanceof PsiFunctionalExpression ? ((PsiFunctionalExpression)expression2).getFunctionalInterfaceType() : expression2.getType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type2);
        if (interfaceMethod == null || interfaceMethod.getParameterList().getParametersCount() != paramCount) {
            return null;
        }
        PsiType returnType = interfaceMethod.getReturnType();
        if (returnType == null) {
            return null;
        }
        returnType = ((PsiClassType)type2).resolveGenerics().getSubstitutor().substitute(returnType);
        type2 = FunctionHelper.fixType(type2, expression2.getProject());
        if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiParameterList list = lambda2.getParameterList();
            if (list.getParametersCount() != paramCount) {
                return null;
            }
            String[] parameters2 = (String[])StreamEx.of((Object[])list.getParameters()).map(PomNamedTarget::getName).toArray(String[]::new);
            PsiElement body2 = lambda2.getBody();
            PsiExpression lambdaExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2);
            if (lambdaExpression == null) {
                if (PsiType.VOID.equals((Object)returnType) && body2 instanceof PsiCodeBlock) {
                    List<PsiReturnStatement> returns = FunctionHelper.getReturns(body2);
                    if (!allowReturns && !returns.isEmpty()) {
                        return null;
                    }
                    for (PsiReturnStatement ret : returns) {
                        if (PsiTreeUtil.getParentOfType((PsiElement)ret, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class}) == null) continue;
                        return null;
                    }
                    return new VoidBlockLambdaFunctionHelper((PsiCodeBlock)body2, parameters2);
                }
                return null;
            }
            return new LambdaFunctionHelper(returnType, (PsiElement)lambdaExpression, parameters2);
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            if (methodRef.resolve() == null) {
                return null;
            }
            String template = FunctionHelper.tryInlineMethodReference(paramCount, methodRef);
            if (template != null) {
                return new InlinedFunctionHelper(returnType, paramCount, template);
            }
            return new MethodReferenceFunctionHelper(returnType, type2, methodRef);
        }
        if (expression2 instanceof PsiReferenceExpression && ExpressionUtils.isSimpleExpression(expression2)) {
            return new SimpleReferenceFunctionHelper(returnType, expression2, interfaceMethod.getName());
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.function.Function", "identity", 0)) {
                return paramCount == 1 ? new InlinedFunctionHelper(returnType, 1, "{0}") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Comparator", "naturalOrder", 0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{0}.compareTo({1})") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Comparator", "reverseOrder", 0) || MethodCallUtils.isCallToStaticMethod(call, "java.util.Collections", "reverseOrder", 0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{1}.compareTo({0})") : null;
            }
        }
        return new ComplexExpressionFunctionHelper(returnType, type2, interfaceMethod.getName(), expression2);
    }

    private static PsiType fixType(PsiType type2, Project project2) {
        PsiCapturedWildcardType capturedWildcardType;
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass != null && classType.getParameterCount() != 0) {
                PsiType[] parameters2 = classType.getParameters();
                Arrays.asList(parameters2).replaceAll(t -> FunctionHelper.fixType(t, project2));
                return JavaPsiFacade.getElementFactory((Project)project2).createType(aClass, parameters2);
            }
        } else if (type2 instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)type2).getComponentType();
            PsiType fixedType = FunctionHelper.fixType(componentType, project2);
            if (fixedType != componentType) {
                return fixedType.createArrayType();
            }
        } else if (type2 instanceof PsiCapturedWildcardType && (capturedWildcardType = (PsiCapturedWildcardType)type2).getLowerBound().equals(PsiType.NULL)) {
            return capturedWildcardType.getUpperBound();
        }
        return type2;
    }

    @Nullable
    private static String tryInlineMethodReference(int paramCount, PsiMethodReferenceExpression methodRef) {
        PsiElement element = methodRef.resolve();
        if (element instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)element;
            String name = method2.getName();
            PsiClass aClass = method2.getContainingClass();
            if (aClass != null) {
                PsiExpression qualifier;
                String className = aClass.getQualifiedName();
                if ("java.util.Objects".equals(className) && paramCount == 1) {
                    if (name.equals("nonNull")) {
                        return "{0}!=null";
                    }
                    if (name.equals("isNull")) {
                        return "{0}==null";
                    }
                }
                if (paramCount == 2 && name.equals("sum") && ("java.lang.Integer".equals(className) || "java.lang.Long".equals(className) || "java.lang.Double".equals(className))) {
                    return "{0}+{1}";
                }
                if ("java.lang.Class".equals(className) && paramCount == 1 && (qualifier = methodRef.getQualifierExpression()) instanceof PsiClassObjectAccessExpression) {
                    PsiTypeElement type2 = ((PsiClassObjectAccessExpression)qualifier).getOperand();
                    if (name.equals("isInstance")) {
                        return "{0} instanceof " + type2.getText();
                    }
                    if (name.equals("cast")) {
                        return "(" + type2.getText() + "){0}";
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    static FunctionHelper newObjectSupplier(PsiType type2, final String instanceClassName) {
        return new FunctionHelper(type2){
            PsiExpression myExpression;

            @Override
            PsiExpression getExpression() {
                return this.myExpression;
            }

            @Override
            void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
                LOG.assertTrue(argumentValues.length == 0);
                this.myExpression = context.createExpression("new " + instanceClassName + "<>()");
            }
        };
    }

    static boolean hasVarReference(PsiElement expressionOrCodeBlock, String name, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(name + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda2.getParameterList().getParameters()[0];
        PsiElement body2 = lambda2.getBody();
        LOG.assertTrue(body2 != null);
        return ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body2)).findFirst() != null;
    }

    @NotNull
    static <T extends PsiElement> T replaceVarReference(@NotNull T expressionOrCodeBlock, String name, String replacement, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        if (name.equals(replacement)) {
            return expressionOrCodeBlock;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(name + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda2.getParameterList().getParameters()[0];
        PsiElement body2 = lambda2.getBody();
        LOG.assertTrue(body2 != null);
        PsiExpression replacementExpression = context.createExpression(replacement);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body2)).findAll()) {
            ref.getElement().replace((PsiElement)replacementExpression);
        }
        return (T)lambda2.getBody();
    }

    @NotNull
    private static List<PsiReturnStatement> getReturns(PsiElement body2) {
        final ArrayList<PsiReturnStatement> returns = new ArrayList<PsiReturnStatement>();
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(@NotNull PsiClass psiClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
                super.visitReturnStatement(returnStatement);
                returns.add(returnStatement);
            }
        });
        return returns;
    }

    private static class VoidBlockLambdaFunctionHelper
    extends LambdaFunctionHelper {
        VoidBlockLambdaFunctionHelper(PsiCodeBlock body2, String[] parameters2) {
            super((PsiType)PsiType.VOID, (PsiElement)body2, parameters2);
        }

        @Override
        String getStatementText() {
            Object[] children2 = this.myBody.getChildren();
            return StreamEx.of((Object[])children2, (int)1, (int)(children2.length - 1)).map(PsiElement::getText).joining().trim();
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            super.transform(context, argumentValues);
            if (!this.myBody.isValid()) {
                this.myBody = ((PsiLambdaExpression)context.createExpression("()->" + this.myBody.getText())).getBody();
            }
            List returns = FunctionHelper.getReturns(this.myBody);
            String continueStatement = "continue;";
            returns.forEach(ret -> ret.replace((PsiElement)context.createStatement(continueStatement)));
        }
    }

    private static class LambdaFunctionHelper
    extends FunctionHelper {
        String[] myParameters;
        PsiElement myBody;

        LambdaFunctionHelper(PsiType returnType, PsiElement body2, String[] parameters2) {
            super(returnType);
            this.myParameters = parameters2;
            this.myBody = body2;
        }

        @Override
        String tryLightTransform(PsiType type2) {
            LOG.assertTrue(this.myParameters.length == 1);
            return this.myParameters[0];
        }

        @Override
        PsiExpression getExpression() {
            return (PsiExpression)this.myBody;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myParameters.length);
            EntryStream.zip((Object[])this.myParameters, (Object[])argumentValues).forKeyValue((oldName, newName) -> {
                this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
            });
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            int idx = ArrayUtil.indexOf((Object[])this.myParameters, (Object)newName);
            if (idx >= 0) {
                int i2 = 1;
                while (true) {
                    String paramName;
                    if (!((paramName = newName + '$' + i2).equals(oldName) || StreamEx.of((Object[])this.myParameters).has((Object)paramName) || LambdaFunctionHelper.hasVarReference(this.myBody, paramName, context))) {
                        this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, newName, paramName, context);
                        this.myParameters[idx] = paramName;
                        break;
                    }
                    ++i2;
                }
            }
            this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer2) {
            consumer2.accept(this.myBody);
        }

        @Override
        String getParameterName(int index) {
            return this.myParameters[index];
        }

        @Override
        void preprocessVariable(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var, int index) {
            super.preprocessVariable(context, var, index);
            boolean hasClassOrLambda = StreamEx.ofTree((Object)this.myBody, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(e -> e instanceof PsiLambdaExpression || e instanceof PsiClass);
            if (hasClassOrLambda) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(this.getParameterName(index) + "->" + this.myBody.getText());
                PsiParameter parameter = lambda2.getParameterList().getParameters()[0];
                PsiElement body2 = lambda2.getBody();
                LOG.assertTrue(body2 != null);
                boolean mayBeNotFinal = ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(body2)).forEach(e -> PsiTreeUtil.getParentOfType((PsiElement)e.getElement(), (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == lambda2);
                if (!mayBeNotFinal) {
                    var.markFinal();
                }
            }
        }

        @Override
        void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
            PsiExpression expr = context.createExpression("(" + var.getType() + ")" + this.getText());
            FunctionHelper.suggestFromExpression(var, context.getProject(), expr);
        }
    }

    static class InlinedFunctionHelper
    extends FunctionHelper {
        private final int myArgCount;
        private final String myTemplate;
        private PsiExpression myExpression;

        public InlinedFunctionHelper(PsiType type2, int argCount, String template) {
            super(type2);
            this.myArgCount = argCount;
            this.myTemplate = template;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myArgCount);
            this.myExpression = context.createExpression(MessageFormat.format(this.myTemplate, argumentValues));
        }
    }

    private static class SimpleReferenceFunctionHelper
    extends FunctionHelper {
        private PsiExpression myReference;
        private final String myName;
        private PsiExpression myExpression;

        public SimpleReferenceFunctionHelper(PsiType returnType, PsiExpression reference, String methodName) {
            super(returnType);
            this.myReference = reference;
            this.myName = methodName;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            this.myExpression = context.createExpression(this.myReference.getText() + "." + this.myName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myReference = SimpleReferenceFunctionHelper.replaceVarReference(this.myReference, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer2) {
            consumer2.accept((PsiElement)this.myReference);
        }
    }

    private static class ComplexExpressionFunctionHelper
    extends FunctionHelper {
        private final String myMethodName;
        private final String myNameCandidate;
        private final String myFnType;
        private PsiExpression myExpression;
        private PsiExpression myFinalExpression;

        private ComplexExpressionFunctionHelper(PsiType type2, PsiType functionalInterface, String name, PsiExpression expression2) {
            super(type2);
            this.myMethodName = name;
            this.myExpression = expression2;
            this.myNameCandidate = this.getNameCandidate(functionalInterface);
            this.myFnType = functionalInterface.getCanonicalText();
        }

        private String getNameCandidate(PsiType functionalInterface) {
            PsiElement parent = this.myExpression.getParent();
            if (parent instanceof PsiExpressionList) {
                PsiParameter[] parameters2;
                PsiMethod method2;
                int idx = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)this.myExpression);
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiMethodCallExpression && idx >= 0 && (method2 = ((PsiMethodCallExpression)gParent).resolveMethod()) != null && idx < (parameters2 = method2.getParameterList().getParameters()).length) {
                    return parameters2[idx].getName();
                }
            }
            return functionalInterface.getPresentableText().toLowerCase(Locale.ENGLISH);
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myFinalExpression != null);
            return this.myFinalExpression;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myExpression = ComplexExpressionFunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer2) {
            consumer2.accept((PsiElement)this.myExpression);
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            String varName = context.declare(this.myNameCandidate, this.myFnType, this.myExpression.getText());
            this.myFinalExpression = context.createExpression(varName + "." + this.myMethodName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }
    }

    private static class MethodReferenceFunctionHelper
    extends FunctionHelper {
        private final String myType;
        private final String myQualifierType;
        private PsiMethodReferenceExpression myMethodRef;
        private PsiExpression myExpression;

        public MethodReferenceFunctionHelper(PsiType returnType, PsiType functionalInterfaceType, PsiMethodReferenceExpression methodRef) {
            super(returnType);
            this.myMethodRef = methodRef;
            this.myType = functionalInterfaceType.getCanonicalText();
            PsiExpression qualifier = methodRef.getQualifierExpression();
            PsiType type2 = qualifier == null ? null : qualifier.getType();
            this.myQualifierType = type2 == null ? null : type2.getCanonicalText();
        }

        @Override
        String tryLightTransform(PsiType type2) {
            PsiLambdaExpression lambda2;
            if (this.myMethodRef.isConstructor()) {
                return null;
            }
            if ((type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)type2)) == null) {
                return null;
            }
            PsiElement element = this.myMethodRef.resolve();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            PsiMethod method2 = (PsiMethod)element;
            String var = "x";
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return null;
            }
            if (method2.getModifierList().hasExplicitModifier("static")) {
                if (method2.getParameterList().getParametersCount() != 1) {
                    return null;
                }
                lambda2 = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)this.myMethodRef.getProject()).createExpressionFromText("(" + type2.getCanonicalText() + " " + var + ")->" + aClass.getQualifiedName() + "." + method2.getName() + "(" + var + ")", (PsiElement)this.myMethodRef);
            } else {
                lambda2 = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)this.myMethodRef.getProject()).createExpressionFromText("(" + type2.getCanonicalText() + " " + var + ")->" + var + "." + this.myMethodRef.getReferenceName() + "()", (PsiElement)this.myMethodRef);
            }
            this.myExpression = (PsiExpression)lambda2.getBody();
            return var;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void registerReusedElements(Consumer<PsiElement> consumer2) {
            consumer2.accept((PsiElement)this.myMethodRef);
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            PsiLambdaExpression lambda2;
            String type2;
            String qualifierText;
            PsiMethodReferenceExpression methodRef = this.fromText(context, this.myMethodRef.getText());
            PsiExpression qualifier = methodRef.getQualifierExpression();
            if (qualifier != null && !ExpressionUtils.isSimpleExpression(context.createExpression(qualifierText = qualifier.getText())) && (type2 = this.myQualifierType) != null) {
                String nameCandidate = "expr";
                PsiType psiType = context.createType(this.myQualifierType);
                SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, psiType, true);
                if (info.names.length > 0) {
                    nameCandidate = info.names[0];
                }
                String expr = context.declare(nameCandidate, type2, qualifierText);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)context.createExpression("(" + type2 + " " + expr + ")->(" + this.myType + ")" + expr + "::" + this.myMethodRef.getReferenceName());
                PsiTypeCastExpression castExpr = (PsiTypeCastExpression)lambdaExpression.getBody();
                LOG.assertTrue(castExpr != null);
                methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
                LOG.assertTrue(methodRef != null);
            }
            if ((lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodRef, true, true)) == null) {
                throw new IllegalStateException("Unable to convert method reference to lambda: " + methodRef.getText());
            }
            PsiElement body2 = lambda2.getBody();
            LOG.assertTrue(body2 instanceof PsiExpression);
            this.myExpression = (PsiExpression)body2;
            EntryStream.zip((Object[])lambda2.getParameterList().getParameters(), (Object[])argumentValues).forKeyValue((param, newName) -> {
                this.myExpression = MethodReferenceFunctionHelper.replaceVarReference(this.myExpression, param.getName(), newName, context);
            });
        }

        @Override
        void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
            PsiElement body2;
            PsiTypeCastExpression castExpr = (PsiTypeCastExpression)context.createExpression("(" + this.myType + ")" + this.myMethodRef.getText());
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
            PsiLambdaExpression lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodRef, true, true);
            if (lambda2 != null && (body2 = lambda2.getBody()) instanceof PsiExpression) {
                FunctionHelper.suggestFromExpression(var, context.getProject(), (PsiExpression)body2);
            }
        }

        @NotNull
        private PsiMethodReferenceExpression fromText(StreamToLoopInspection.StreamToLoopReplacementContext context, String text) {
            PsiTypeCastExpression castExpr = (PsiTypeCastExpression)context.createExpression("(" + this.myType + ")" + text);
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
            LOG.assertTrue(methodRef != null);
            return methodRef;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            if (oldName.equals(newName)) {
                return;
            }
            PsiExpression qualifier = this.myMethodRef.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            qualifier = MethodReferenceFunctionHelper.replaceVarReference(qualifier, oldName, newName, context);
            this.myMethodRef = this.fromText(context, qualifier.getText() + "::" + this.myMethodRef.getReferenceName());
        }
    }
}

