/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.SourceOperation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.codeInspection.streamToLoop.TerminalOperation;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Operation {
    Operation() {
    }

    boolean changesVariable() {
        return false;
    }

    StreamEx<StreamToLoopInspection.OperationRecord> nestedOperations() {
        return StreamEx.empty();
    }

    void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
    }

    abstract String wrap(StreamVariable var1, StreamVariable var2, String var3, StreamToLoopInspection.StreamToLoopReplacementContext var4);

    Operation combineWithNext(Operation next) {
        return null;
    }

    public void registerReusedElements(Consumer<PsiElement> consumer2) {
    }

    public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
    }

    @Nullable
    static Operation createIntermediate(@NotNull String name, @NotNull PsiExpression[] args, @NotNull StreamVariable outVar, @NotNull PsiType inType, boolean supportUnknownSources) {
        if (name.equals("distinct") && args.length == 0) {
            return new DistinctOperation();
        }
        if (name.equals("skip") && args.length == 1) {
            return new SkipOperation(args[0]);
        }
        if (name.equals("limit") && args.length == 1) {
            return new LimitOperation(args[0]);
        }
        if (name.equals("filter") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new FilterOperation(fn);
        }
        if (name.equals("takeWhile") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new TakeWhileOperation(fn);
        }
        if (name.equals("dropWhile") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new DropWhileOperation(fn);
        }
        if (name.equals("nonNull") && args.length == 0) {
            return new FilterOperation(new FunctionHelper.InlinedFunctionHelper((PsiType)PsiType.BOOLEAN, 1, "{0} != null"));
        }
        if (name.equals("sorted") && !(inType instanceof PsiPrimitiveType)) {
            return new SortedOperation(args.length == 1 ? args[0] : null);
        }
        if (name.equals("peek") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new PeekOperation(fn);
        }
        if ((name.equals("boxed") || name.equals("asLongStream") || name.equals("asDoubleStream")) && args.length == 0) {
            return new WideningOperation();
        }
        if ((name.equals("flatMap") || name.equals("flatMapToInt") || name.equals("flatMapToLong") || name.equals("flatMapToDouble")) && args.length == 1) {
            return FlatMapOperation.from(outVar, args[0], inType, supportUnknownSources);
        }
        if ((name.equals("map") || name.equals("mapToInt") || name.equals("mapToLong") || name.equals("mapToDouble") || name.equals("mapToObj")) && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new MapOperation(fn);
        }
        return null;
    }

    static class SortedOperation
    extends Operation {
        @Nullable
        private final PsiExpression myComparator;

        SortedOperation(@Nullable PsiExpression comparator2) {
            this.myComparator = comparator2;
        }

        @Override
        Operation combineWithNext(Operation next) {
            if (next instanceof TerminalOperation.ToArrayTerminalOperation || next instanceof TerminalOperation.ToCollectionTerminalOperation && ((TerminalOperation.ToCollectionTerminalOperation)next).isList()) {
                return new TerminalOperation.SortedTerminalOperation((TerminalOperation.AccumulatedOperation)next, this.myComparator);
            }
            return null;
        }

        @Override
        String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String list = context.registerVarName(Arrays.asList("toSort", "listToSort"));
            context.addAfterStep(new SourceOperation.ForEachSource(context.createExpression(list)).wrap(null, outVar, code2, context));
            context.addAfterStep(list + ".sort(" + (this.myComparator == null ? "null" : this.myComparator.getText()) + ");\n");
            String listType = "java.util.List<" + inVar.getType() + ">";
            String initializer = "new java.util.ArrayList<>()";
            context.addBeforeStep(listType + " " + list + "=" + initializer + ";");
            return list + ".add(" + inVar + ");\n";
        }
    }

    static class LimitOperation
    extends Operation {
        PsiExpression myLimit;

        LimitOperation(PsiExpression expression2) {
            this.myLimit = expression2;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myLimit = FunctionHelper.replaceVarReference(this.myLimit, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer2) {
            consumer2.accept((PsiElement)this.myLimit);
        }

        @Override
        String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String limit = context.declare("limit", "long", this.myLimit.getText());
            return "if(" + limit + "--==0) " + context.getBreakStatement() + code2;
        }
    }

    static class SkipOperation
    extends Operation {
        PsiExpression myExpression;

        SkipOperation(PsiExpression expression2) {
            this.myExpression = expression2;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myExpression = FunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer2) {
            consumer2.accept((PsiElement)this.myExpression);
        }

        @Override
        String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String toSkip = context.declare("toSkip", "long", this.myExpression.getText());
            return "if(" + toSkip + ">0) {\n" + toSkip + "--;\ncontinue;\n}\n" + code2;
        }
    }

    static class DistinctOperation
    extends Operation {
        DistinctOperation() {
        }

        @Override
        String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String set2 = context.declare("uniqueValues", "java.util.Set<" + PsiTypesUtil.boxIfPossible((String)inVar.getType()) + ">", "new java.util.HashSet<>()");
            return "if(" + set2 + ".add(" + inVar + ")) {\n" + code2 + "}\n";
        }
    }

    static class FlatMapOperation
    extends Operation {
        private String myVarName;
        private final FunctionHelper myFn;
        private final List<StreamToLoopInspection.OperationRecord> myRecords;
        private PsiExpression myCondition;
        private final boolean myInverted;

        private FlatMapOperation(String varName, FunctionHelper fn, List<StreamToLoopInspection.OperationRecord> records, PsiExpression condition2, boolean inverted) {
            this.myVarName = varName;
            this.myFn = fn;
            this.myRecords = records;
            this.myCondition = condition2;
            this.myInverted = inverted;
        }

        @Override
        StreamEx<StreamToLoopInspection.OperationRecord> nestedOperations() {
            return StreamEx.of(this.myRecords).flatMap(or -> (StreamEx)StreamEx.of((Object)or).append(or.myOperation.nestedOperations()));
        }

        @Override
        boolean changesVariable() {
            return true;
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            String name = this.myFn.getParameterName(0);
            if (name != null) {
                inVar.addBestNameCandidate(name);
            }
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer2) {
            this.myRecords.forEach(or -> or.myOperation.registerReusedElements(consumer2));
            if (this.myCondition != null) {
                consumer2.accept((PsiElement)this.myCondition);
            }
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myRecords.forEach(or -> or.myOperation.rename(oldName, newName, context));
            if (this.myCondition != null) {
                this.myCondition = FunctionHelper.replaceVarReference(this.myCondition, oldName, newName, context);
            }
        }

        @Override
        String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            if (!this.myVarName.equals(inVar.getName())) {
                this.rename(this.myVarName, inVar.getName(), context);
            }
            StreamToLoopInspection.StreamToLoopReplacementContext innerContext = new StreamToLoopInspection.StreamToLoopReplacementContext(context, this.myRecords);
            String replacement = code2;
            for (StreamToLoopInspection.OperationRecord or : StreamEx.ofReversed(this.myRecords)) {
                replacement = or.myOperation.wrap(or.myInVar, or.myOutVar, replacement, innerContext);
            }
            if (this.myCondition != null) {
                String conditionText = this.myCondition.getText();
                if (this.myInverted) {
                    conditionText = BoolUtils.getNegatedExpressionText(context.createExpression(conditionText));
                }
                return "if(" + conditionText + "){\n" + replacement + "}\n";
            }
            return replacement;
        }

        @Nullable
        public static FlatMapOperation from(StreamVariable outVar, PsiExpression arg, PsiType inType, boolean supportUnknownSources) {
            FunctionHelper fn = FunctionHelper.create(arg, 1);
            if (fn == null) {
                return null;
            }
            String varName = fn.tryLightTransform(inType);
            if (varName == null) {
                return null;
            }
            PsiExpression body2 = fn.getExpression();
            PsiExpression condition2 = null;
            boolean inverted = false;
            if (body2 instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)body2;
                condition2 = ternary.getCondition();
                PsiExpression thenExpression2 = ternary.getThenExpression();
                PsiExpression elseExpression2 = ternary.getElseExpression();
                if (StreamApiUtil.isNullOrEmptyStream(thenExpression2)) {
                    body2 = elseExpression2;
                    inverted = true;
                } else if (StreamApiUtil.isNullOrEmptyStream(elseExpression2)) {
                    body2 = thenExpression2;
                } else {
                    return null;
                }
            }
            if (!(body2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression terminalCall = (PsiMethodCallExpression)body2;
            List<StreamToLoopInspection.OperationRecord> records = StreamToLoopInspection.extractOperations(outVar, terminalCall, supportUnknownSources);
            if (records == null || StreamToLoopInspection.getTerminal(records) != null) {
                return null;
            }
            return new FlatMapOperation(varName, fn, records, condition2, inverted);
        }
    }

    static class WideningOperation
    extends Operation {
        WideningOperation() {
        }

        @Override
        String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            return outVar.getDeclaration(inVar.getName()) + code2;
        }

        @Override
        boolean changesVariable() {
            return true;
        }
    }

    static class MapOperation
    extends LambdaIntermediateOperation {
        public MapOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            super.preprocessVariables(context, inVar, outVar);
            this.myFn.suggestOutputNames(context, outVar);
        }

        @Override
        String wrap(StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            return outVar.getDeclaration(this.myFn.getText()) + code2;
        }

        @Override
        boolean changesVariable() {
            return true;
        }
    }

    static class PeekOperation
    extends LambdaIntermediateOperation {
        public PeekOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            return this.myFn.getStatementText() + code2;
        }
    }

    static class DropWhileOperation
    extends LambdaIntermediateOperation {
        public DropWhileOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String dropping = context.declare("dropping", "boolean", "true");
            return "if(" + dropping + ") {\nif(" + this.myFn.getText() + ") {\ncontinue;\n}\n" + dropping + "=false;\n}\n" + code2;
        }
    }

    static class TakeWhileOperation
    extends LambdaIntermediateOperation {
        public TakeWhileOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            return "if(" + BoolUtils.getNegatedExpressionText(this.myFn.getExpression()) + ") {\n" + context.getBreakStatement() + "}\n" + code2;
        }
    }

    static class FilterOperation
    extends LambdaIntermediateOperation {
        public FilterOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            return "if(" + this.myFn.getText() + ") {\n" + code2 + "}\n";
        }
    }

    static abstract class LambdaIntermediateOperation
    extends Operation {
        final FunctionHelper myFn;

        LambdaIntermediateOperation(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer2) {
            this.myFn.registerReusedElements(consumer2);
        }

        @Override
        final String wrap(StreamVariable inVar, StreamVariable outVar, String code2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myFn.transform(context, inVar.getName());
            return this.wrap(outVar, code2, context);
        }

        abstract String wrap(StreamVariable var1, String var2, StreamToLoopInspection.StreamToLoopReplacementContext var3);

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myFn.rename(oldName, newName, context);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }
    }
}

