/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamToLoop.ConditionalExpression;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.SourceOperation;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.codeInspection.streamToLoop.TerminalOperation;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamToLoopInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StreamToLoopInspection.class);
    private static final Set<String> SUPPORTED_TERMINALS = ContainerUtil.set((Object[])new String[]{"count", "sum", "summaryStatistics", "reduce", "collect", "findFirst", "findAny", "anyMatch", "allMatch", "noneMatch", "toArray", "average", "forEach", "forEachOrdered", "min", "max", "toList", "toSet"});
    public boolean SUPPORT_UNKNOWN_SOURCES = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Iterate unknown Stream sources via Stream.iterator()", (InspectionProfileEntry)this, "SUPPORT_UNKNOWN_SOURCES");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiReferenceExpression expression2 = call.getMethodExpression();
                PsiElement nameElement = expression2.getReferenceNameElement();
                if (nameElement == null || !SUPPORTED_TERMINALS.contains(nameElement.getText()) || !StreamToLoopInspection.isSupportedCodeLocation(call)) {
                    return;
                }
                PsiMethod method2 = call.resolveMethod();
                if (method2 == null) {
                    return;
                }
                PsiClass aClass = method2.getContainingClass();
                if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
                    if (StreamToLoopInspection.extractOperations(StreamVariable.STUB, call, StreamToLoopInspection.this.SUPPORT_UNKNOWN_SOURCES) != null) {
                        this.register(call, nameElement, "Replace Stream API chain with loop");
                    }
                } else if (StreamToLoopInspection.extractIterableForEach(call) != null) {
                    this.register(call, nameElement, "Replace 'forEach' call with loop");
                }
            }

            private void register(PsiMethodCallExpression call, PsiElement nameElement, String message2) {
                TextRange range = isOnTheFly && InspectionProjectProfileManager.isInformationLevel(StreamToLoopInspection.this.getShortName(), (PsiElement)call) ? new TextRange(0, call.getTextLength()) : nameElement.getTextRange().shiftRight(-call.getTextOffset());
                holder.registerProblem((PsiElement)call, range, message2, new LocalQuickFix[]{new ReplaceStreamWithLoopFix(message2)});
            }
        };
    }

    private static boolean isSupportedCodeLocation(PsiMethodCallExpression call) {
        PsiElement grandParent;
        PsiMethodCallExpression cur = call;
        PsiElement parent = cur.getParent();
        while (parent instanceof PsiExpression || parent instanceof PsiExpressionList) {
            PsiReferenceExpression methodExpression;
            PsiPolyadicExpression polyadicExpression;
            IElementType type2;
            if (parent instanceof PsiLambdaExpression) {
                return true;
            }
            if (parent instanceof PsiPolyadicExpression && ((type2 = (polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || type2.equals(JavaTokenType.OROR)) && polyadicExpression.getOperands()[0] != cur) {
                return false;
            }
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != cur) {
                return false;
            }
            if (parent instanceof PsiMethodCallExpression && ((methodExpression = ((PsiMethodCallExpression)parent).getMethodExpression()).textMatches((CharSequence)"this") || methodExpression.textMatches((CharSequence)"super"))) {
                return false;
            }
            cur = parent;
            parent = cur.getParent();
        }
        if (parent instanceof PsiReturnStatement || parent instanceof PsiExpressionStatement) {
            return true;
        }
        if (parent instanceof PsiLocalVariable && (grandParent = parent.getParent()) instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)grandParent).getDeclaredElements().length == 1) {
            return true;
        }
        if (parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == cur) {
            return true;
        }
        return parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() == cur;
    }

    @Nullable
    static Operation createOperationFromCall(StreamVariable outVar, PsiMethodCallExpression call, boolean supportUnknownSources) {
        PsiMethod method2 = call.resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        String name = method2.getName();
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        PsiType callType = call.getType();
        if (callType == null) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream") && !method2.getModifierList().hasExplicitModifier("static")) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null) {
                PsiType elementType = StreamApiUtil.getStreamElementType(qualifier.getType());
                if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)call)) {
                    return null;
                }
                Operation op = Operation.createIntermediate(name, args, outVar, elementType, supportUnknownSources);
                if (op != null) {
                    return op;
                }
                op = TerminalOperation.createTerminal(name, args, elementType, callType, StreamToLoopInspection.isVoidContext(call.getParent()));
                if (op != null) {
                    return op;
                }
            }
            return null;
        }
        return SourceOperation.createSource(call, supportUnknownSources);
    }

    private static boolean isValidElementType(PsiType elementType, PsiElement context) {
        PsiResolveHelper helper;
        if (elementType == null || elementType instanceof PsiClassType && ((PsiClassType)elementType).isRaw()) {
            return false;
        }
        return !(elementType instanceof PsiImmediateClassType) || (helper = PsiResolveHelper.SERVICE.getInstance((Project)context.getProject())).resolveReferencedClass(elementType.getCanonicalText(), context) != null;
    }

    private static boolean isVoidContext(PsiElement element) {
        return element instanceof PsiExpressionStatement || element instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)element)));
    }

    @Nullable
    static List<OperationRecord> extractIterableForEach(PsiMethodCallExpression terminalCall) {
        if (MethodCallUtils.isCallToMethod(terminalCall, "java.lang.Iterable", (PsiType)PsiType.VOID, "forEach", new PsiType[1]) && StreamToLoopInspection.isVoidContext(terminalCall.getParent())) {
            PsiExpression qualifier = terminalCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            PsiType type2 = qualifier.getType();
            if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.BaseStream")) {
                return null;
            }
            PsiExpression[] args = terminalCall.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            FunctionHelper fn = FunctionHelper.create(args[0], 1, true);
            if (fn == null) {
                return null;
            }
            PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.lang.Iterable", (int)0, (boolean)false);
            if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)terminalCall)) {
                return null;
            }
            elementType = GenericsUtil.getVariableTypeByExpressionType((PsiType)elementType);
            TerminalOperation.ForEachTerminalOperation terminal = new TerminalOperation.ForEachTerminalOperation(fn);
            SourceOperation.ForEachSource source = new SourceOperation.ForEachSource(qualifier);
            OperationRecord terminalRecord = new OperationRecord();
            OperationRecord sourceRecord = new OperationRecord();
            terminalRecord.myOperation = terminal;
            sourceRecord.myOperation = source;
            sourceRecord.myOutVar = terminalRecord.myInVar = new StreamVariable(elementType.getCanonicalText());
            sourceRecord.myInVar = terminalRecord.myOutVar = StreamVariable.STUB;
            return Arrays.asList(sourceRecord, terminalRecord);
        }
        return null;
    }

    @Nullable
    static List<OperationRecord> extractOperations(StreamVariable outVar, PsiMethodCallExpression terminalCall, boolean supportUnknownSources) {
        ArrayList<OperationRecord> operations = new ArrayList<OperationRecord>();
        PsiMethodCallExpression currentCall = terminalCall;
        StreamVariable lastVar = outVar;
        Operation next = null;
        Operation op;
        while ((op = StreamToLoopInspection.createOperationFromCall(lastVar, currentCall, supportUnknownSources)) != null) {
            Operation combined;
            if (next != null && (combined = op.combineWithNext(next)) != null) {
                op = combined;
                operations.remove(operations.size() - 1);
            }
            OperationRecord or = new OperationRecord();
            or.myOperation = op;
            or.myOutVar = lastVar;
            operations.add(or);
            if (op instanceof SourceOperation) {
                or.myInVar = StreamVariable.STUB;
                Collections.reverse(operations);
                return operations;
            }
            if ((currentCall = MethodCallUtils.getQualifierMethodCall(currentCall)) == null) {
                return null;
            }
            if (op.changesVariable()) {
                PsiType type2 = StreamApiUtil.getStreamElementType(currentCall.getType());
                if (type2 == null) {
                    return null;
                }
                lastVar = new StreamVariable(type2.getCanonicalText());
            }
            or.myInVar = lastVar;
            next = op;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    static TerminalOperation getTerminal(List<OperationRecord> operations) {
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        OperationRecord record = operations.get(operations.size() - 1);
        if (record.myOperation instanceof TerminalOperation) {
            return (TerminalOperation)record.myOperation;
        }
        return null;
    }

    static class OperationRecord {
        Operation myOperation;
        StreamVariable myInVar;
        StreamVariable myOutVar;

        OperationRecord() {
        }
    }

    static class StreamToLoopReplacementContext {
        private final boolean myHasNestedLoops;
        private final String mySuffix;
        private final PsiStatement myStatement;
        private final Set<String> myUsedNames;
        private final Set<String> myUsedLabels;
        private final List<String> myBeforeSteps = new ArrayList<String>();
        private final List<String> myAfterSteps = new ArrayList<String>();
        private final CommentTracker myCommentTracker;
        private PsiElement myPlaceholder;
        private final PsiElementFactory myFactory;
        private String myLabel;
        private String myFinisher;

        StreamToLoopReplacementContext(PsiStatement statement2, List<OperationRecord> records, @NotNull PsiExpression placeholder, CommentTracker ct) {
            this.myStatement = statement2;
            this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myStatement.getProject());
            this.myHasNestedLoops = records.stream().anyMatch(or -> or.myOperation instanceof Operation.FlatMapOperation);
            this.myPlaceholder = placeholder;
            this.mySuffix = this.myHasNestedLoops ? "Outer" : "";
            this.myCommentTracker = ct;
            this.myUsedNames = new HashSet<String>();
            this.myUsedLabels = StreamEx.iterate((Object)statement2, Objects::nonNull, PsiElement::getParent).select(PsiLabeledStatement.class).map(PsiLabeledStatement::getName).toSet();
        }

        StreamToLoopReplacementContext(StreamToLoopReplacementContext parentContext, List<OperationRecord> records) {
            this.myUsedNames = parentContext.myUsedNames;
            this.myUsedLabels = parentContext.myUsedLabels;
            this.myPlaceholder = null;
            this.myStatement = parentContext.myStatement;
            this.myFactory = parentContext.myFactory;
            this.myCommentTracker = parentContext.myCommentTracker;
            this.myHasNestedLoops = records.stream().anyMatch(or -> or.myOperation instanceof Operation.FlatMapOperation);
            this.mySuffix = "Inner";
        }

        public void registerReusedElement(@Nullable PsiElement element) {
            if (element == null) {
                return;
            }
            element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    myUsedNames.add(variable.getName());
                }
            });
            this.myCommentTracker.markUnchanged(element);
        }

        @Nullable
        private String allocateLabel() {
            if (!this.myHasNestedLoops) {
                return null;
            }
            if (this.myLabel == null) {
                String base = this.mySuffix.toUpperCase(Locale.ENGLISH);
                this.myLabel = (String)((StreamEx)IntStreamEx.ints().mapToObj(i2 -> i2 == 0 ? base : base + i2).remove(this.myUsedLabels::contains)).findFirst().orElseThrow(IllegalArgumentException::new);
                this.myUsedLabels.add(this.myLabel);
            }
            return this.myLabel;
        }

        public String getLoopLabel() {
            return this.myLabel == null ? "" : this.myLabel + ":\n";
        }

        public String getBreakStatement() {
            String label = this.allocateLabel();
            return label == null ? "break;\n" : "break " + label + ";\n";
        }

        public String registerVarName(Collection<String> variants) {
            if (variants.isEmpty()) {
                return this.registerVarName(Collections.singleton("val"));
            }
            int idx = 0;
            while (true) {
                for (String variant : variants) {
                    String name = idx == 0 ? variant : variant + idx;
                    if (this.isUsed(name)) continue;
                    this.myUsedNames.add(name);
                    return name;
                }
                ++idx;
            }
        }

        private boolean isUsed(String varName) {
            return this.myUsedNames.contains(varName) || JavaLexer.isKeyword(varName, LanguageLevel.HIGHEST) || !varName.equals(JavaCodeStyleManager.getInstance((Project)this.myStatement.getProject()).suggestUniqueVariableName(varName, (PsiElement)this.myStatement, true));
        }

        public String declare(String desiredName, String type2, String initializer) {
            String name = this.registerVarName(this.mySuffix.isEmpty() ? Collections.singleton(desiredName) : Arrays.asList(desiredName, desiredName + this.mySuffix));
            this.myBeforeSteps.add(type2 + " " + name + " = " + initializer + ";");
            return name;
        }

        public void addBeforeStep(String beforeStatement) {
            this.myBeforeSteps.add(beforeStatement);
        }

        public void addAfterStep(String afterStatement) {
            this.myAfterSteps.add(0, afterStatement);
        }

        public String drainAfterSteps() {
            String afterSteps = String.join((CharSequence)"", this.myAfterSteps);
            this.myAfterSteps.clear();
            return afterSteps;
        }

        public String drainBeforeSteps() {
            String beforeSteps = String.join((CharSequence)"", this.myBeforeSteps);
            this.myBeforeSteps.clear();
            return beforeSteps;
        }

        public String declareResult(String desiredName, String type2, String initializer, @NotNull ResultKind kind2) {
            PsiDeclarationStatement declaration2;
            PsiVariable var;
            if (kind2 != ResultKind.UNKNOWN && this.myPlaceholder.getParent() instanceof PsiVariable && (var = (PsiVariable)this.myPlaceholder.getParent()).getType().equalsToText(type2) && var.getParent() instanceof PsiDeclarationStatement && (kind2 == ResultKind.FINAL || StreamToLoopReplacementContext.canUseAsNonFinal(var)) && (declaration2 = (PsiDeclarationStatement)var.getParent()).getDeclaredElements().length == 1) {
                PsiModifierList modifierList;
                this.myPlaceholder = declaration2;
                PsiVariable copy = (PsiVariable)var.copy();
                if (kind2 == ResultKind.NON_FINAL && (modifierList = copy.getModifierList()) != null) {
                    modifierList.setModifierProperty("final", false);
                }
                PsiExpression oldInitializer = copy.getInitializer();
                LOG.assertTrue(oldInitializer != null);
                oldInitializer.replace((PsiElement)this.createExpression(initializer));
                this.myBeforeSteps.add(copy.getText());
                return var.getName();
            }
            String name = this.registerVarName(Arrays.asList(desiredName, "result"));
            this.myBeforeSteps.add(type2 + " " + name + " = " + initializer + ";");
            if (this.myFinisher != null) {
                throw new IllegalStateException("Finisher is already defined");
            }
            this.setFinisher(name);
            return name;
        }

        @Contract(value="null -> false")
        private static boolean canUseAsNonFinal(PsiVariable var) {
            if (!(var instanceof PsiLocalVariable)) {
                return false;
            }
            PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
            return block != null && ReferencesSearch.search((PsiElement)var).forEach(ref -> {
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                return context == null || PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)block, (boolean)false);
            });
        }

        public PsiElement makeFinalReplacement() {
            LOG.assertTrue(this.myPlaceholder != null);
            if (this.myFinisher == null || this.myPlaceholder instanceof PsiStatement) {
                this.myPlaceholder.delete();
                return null;
            }
            PsiExpression expression2 = this.myFactory.createExpressionFromText(this.myFinisher, this.myPlaceholder);
            PsiElement parent = this.myPlaceholder.getParent();
            if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(expression2, (PsiExpression)parent, false)) {
                expression2 = this.myFactory.createExpressionFromText("(" + this.myFinisher + ")", this.myPlaceholder);
            }
            return this.myPlaceholder.replace((PsiElement)expression2);
        }

        public void setFinisher(String finisher) {
            this.myFinisher = finisher;
        }

        public void setFinisher(ConditionalExpression conditionalExpression) {
            if (conditionalExpression instanceof ConditionalExpression.Optional) {
                conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, true);
            }
            this.setFinisher(conditionalExpression.asExpression());
        }

        public String assignAndBreak(ConditionalExpression conditionalExpression) {
            FunctionHelper fn;
            PsiExpression[] args;
            PsiMethodCallExpression call;
            PsiIfStatement ifStatement;
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPlaceholder, PsiStatement.class);
            boolean inReturn = statement2 instanceof PsiReturnStatement;
            if (conditionalExpression instanceof ConditionalExpression.Optional) {
                conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, inReturn);
            }
            if (conditionalExpression instanceof ConditionalExpression.Boolean) {
                conditionalExpression = this.tryUnwrapBoolean((ConditionalExpression.Boolean)conditionalExpression, inReturn);
            }
            if (inReturn) {
                this.setFinisher(conditionalExpression.getFalseBranch());
                Object mark = new Object();
                PsiTreeUtil.mark((PsiElement)this.myPlaceholder, (Object)mark);
                PsiElement returnCopy = statement2.copy();
                PsiElement placeHolderCopy = PsiTreeUtil.releaseMark((PsiElement)returnCopy, (Object)mark);
                LOG.assertTrue(placeHolderCopy != null);
                PsiElement replacement = placeHolderCopy.replace((PsiElement)this.createExpression(conditionalExpression.getTrueBranch()));
                return (placeHolderCopy == returnCopy ? replacement : returnCopy).getText();
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myPlaceholder.getParent());
            if (parent instanceof PsiIfStatement && conditionalExpression instanceof ConditionalExpression.Boolean && !((ConditionalExpression.Boolean)conditionalExpression).isInverted() && (ifStatement = (PsiIfStatement)parent).getElseBranch() == null) {
                PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
                if (thenStatement instanceof PsiReturnStatement || thenStatement instanceof PsiThrowStatement) {
                    this.myPlaceholder = parent;
                    return thenStatement.getText();
                }
                if (thenStatement instanceof PsiExpressionStatement) {
                    this.myPlaceholder = parent;
                    return thenStatement.getText() + "\n" + this.getBreakStatement();
                }
            }
            if (conditionalExpression instanceof ConditionalExpression.Optional && this.myPlaceholder instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myPlaceholder)) != null && call.getParent() instanceof PsiExpressionStatement && (args = call.getArgumentList().getExpressions()).length == 1 && "ifPresent".equals(call.getMethodExpression().getReferenceName()) && (fn = FunctionHelper.create(args[0], 1)) != null) {
                fn.transform(this, ((ConditionalExpression.Optional)conditionalExpression).unwrap("").getTrueBranch());
                this.myPlaceholder = call.getParent();
                return fn.getStatementText() + this.getBreakStatement();
            }
            String found = this.declareResult(conditionalExpression.getCondition(), conditionalExpression.getType(), conditionalExpression.getFalseBranch(), ResultKind.NON_FINAL);
            return found + " = " + conditionalExpression.getTrueBranch() + ";\n" + this.getBreakStatement();
        }

        private ConditionalExpression tryUnwrapBoolean(ConditionalExpression.Boolean condition2, boolean unwrapLazilyEvaluated) {
            if (this.myPlaceholder instanceof PsiExpression) {
                PsiConditionalExpression ternary;
                PsiExpression negation = BoolUtils.findNegation((PsiExpression)this.myPlaceholder);
                if (negation != null) {
                    this.myPlaceholder = negation;
                    condition2 = condition2.negate();
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myPlaceholder.getParent());
                ConditionalExpression candidate = null;
                if (parent instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression expression2 = (PsiPolyadicExpression)parent;
                    Object[] operands2 = expression2.getOperands();
                    if (operands2.length > 1 && PsiTreeUtil.isAncestor((PsiElement)operands2[0], (PsiElement)this.myPlaceholder, (boolean)false)) {
                        IElementType type2 = expression2.getOperationTokenType();
                        if (type2.equals(JavaTokenType.ANDAND)) {
                            candidate = condition2.toPlain("boolean", StreamEx.of((Object[])operands2, (int)1, (int)operands2.length).map(PsiElement::getText).joining((CharSequence)" && "), "false");
                        } else if (type2.equals(JavaTokenType.OROR)) {
                            candidate = condition2.toPlain("boolean", "true", StreamEx.of((Object[])operands2, (int)1, (int)operands2.length).map(PsiElement::getText).joining((CharSequence)" || "));
                        }
                    }
                } else if (parent instanceof PsiConditionalExpression && PsiTreeUtil.isAncestor((PsiElement)(ternary = (PsiConditionalExpression)parent).getCondition(), (PsiElement)this.myPlaceholder, (boolean)false)) {
                    PsiType type3 = ternary.getType();
                    PsiExpression thenExpression2 = ternary.getThenExpression();
                    PsiExpression elseExpression2 = ternary.getElseExpression();
                    if (type3 != null && thenExpression2 != null && elseExpression2 != null) {
                        candidate = condition2.toPlain(type3.getCanonicalText(), thenExpression2.getText(), elseExpression2.getText());
                    }
                }
                if (candidate != null && (unwrapLazilyEvaluated || ExpressionUtils.isSimpleExpression(this.createExpression(candidate.getFalseBranch())))) {
                    this.myPlaceholder = parent;
                    return candidate;
                }
            }
            return condition2;
        }

        @NotNull
        private ConditionalExpression tryUnwrapOptional(ConditionalExpression.Optional condition2, boolean unwrapLazilyEvaluated) {
            PsiMethodCallExpression call;
            if (this.myPlaceholder instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myPlaceholder)) != null && !(call.getParent() instanceof PsiExpressionStatement)) {
                String name = call.getMethodExpression().getReferenceName();
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0 && "isPresent".equals(name)) {
                    this.myPlaceholder = call;
                    return new ConditionalExpression.Boolean(condition2.getCondition(), false);
                }
                if (args.length == 1) {
                    FunctionHelper helper;
                    String absentExpression = null;
                    if ("orElse".equals(name)) {
                        absentExpression = args[0].getText();
                    } else if (unwrapLazilyEvaluated && "orElseGet".equals(name) && (helper = FunctionHelper.create(args[0], 0)) != null) {
                        helper.transform(this, new String[0]);
                        absentExpression = helper.getText();
                    }
                    if (absentExpression != null) {
                        this.myPlaceholder = call;
                        return condition2.unwrap(absentExpression);
                    }
                }
            }
            return condition2;
        }

        public Project getProject() {
            return this.myStatement.getProject();
        }

        public PsiExpression createExpression(String text) {
            return this.myFactory.createExpressionFromText(text, (PsiElement)this.myStatement);
        }

        public PsiStatement createStatement(String text) {
            return this.myFactory.createStatementFromText(text, (PsiElement)this.myStatement);
        }

        public PsiType createType(String text) {
            return this.myFactory.createTypeFromText(text, (PsiElement)this.myStatement);
        }
    }

    static enum ResultKind {
        FINAL,
        NON_FINAL,
        UNKNOWN;

    }

    static class ReplaceStreamWithLoopFix
    implements LocalQuickFix {
        private String myMessage;

        public ReplaceStreamWithLoopFix(String message2) {
            this.myMessage = message2;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myMessage;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace Stream API chain with loop";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            TerminalOperation terminal;
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression terminalCall = (PsiMethodCallExpression)element;
            if (!StreamToLoopInspection.isSupportedCodeLocation(terminalCall)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            if ((terminalCall = RefactoringUtil.ensureCodeBlock(terminalCall)) == null) {
                return;
            }
            PsiType resultType = terminalCall.getType();
            if (resultType == null) {
                return;
            }
            List<OperationRecord> operations = StreamToLoopInspection.extractOperations(StreamVariable.STUB, terminalCall, true);
            if (operations == null) {
                operations = StreamToLoopInspection.extractIterableForEach(terminalCall);
            }
            if ((terminal = StreamToLoopInspection.getTerminal(operations)) == null) {
                return;
            }
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)terminalCall, PsiStatement.class);
            LOG.assertTrue(statement2 != null);
            CommentTracker ct = new CommentTracker();
            PsiExpression temporaryStreamPlaceholder = (PsiExpression)ct.replace((PsiElement)terminalCall, "((" + resultType.getCanonicalText() + ")$streamReplacement$)");
            try {
                StreamToLoopReplacementContext context = new StreamToLoopReplacementContext(statement2, operations, temporaryStreamPlaceholder, ct);
                ReplaceStreamWithLoopFix.registerVariables(operations, context);
                String replacement = "";
                for (OperationRecord or : StreamEx.ofReversed(operations)) {
                    replacement = or.myOperation.wrap(or.myInVar, or.myOutVar, replacement, context);
                }
                ct.insertCommentsBefore((PsiElement)statement2);
                for (PsiStatement addedStatement : ((PsiBlockStatement)factory.createStatementFromText("{" + replacement + "}", (PsiElement)statement2)).getCodeBlock().getStatements()) {
                    ReplaceStreamWithLoopFix.addStatement(project2, statement2, addedStatement);
                }
                PsiElement result2 = context.makeFinalReplacement();
                if (result2 != null) {
                    ReplaceStreamWithLoopFix.normalize(project2, result2);
                }
            }
            catch (Exception ex) {
                String text = terminalCall.getText();
                if (temporaryStreamPlaceholder.isPhysical()) {
                    temporaryStreamPlaceholder.replace((PsiElement)factory.createExpressionFromText(text, (PsiElement)temporaryStreamPlaceholder));
                }
                LOG.error((Object)LogMessageEx.createEvent("Error converting Stream to loop", ExceptionUtil.getThrowableText((Throwable)ex), new Attachment("Stream_code.txt", text)));
            }
        }

        private static void addStatement(@NotNull Project project2, PsiStatement statement2, PsiStatement context) {
            PsiElement element = statement2.getParent().addBefore((PsiElement)context, (PsiElement)statement2);
            ReplaceStreamWithLoopFix.normalize(project2, element);
        }

        private static void normalize(@NotNull Project project2, PsiElement element) {
            element = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(element);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(element);
            RedundantCastUtil.getRedundantCastsInside((PsiElement)element).forEach(RedundantCastUtil::removeCast);
        }

        private static StreamEx<OperationRecord> allOperations(List<OperationRecord> operations) {
            return StreamEx.of(operations).flatMap(or -> or.myOperation.nestedOperations().append(or));
        }

        private static void registerVariables(List<OperationRecord> operations, StreamToLoopReplacementContext context) {
            ReplaceStreamWithLoopFix.allOperations(operations).forEach(or -> or.myOperation.preprocessVariables(context, or.myInVar, or.myOutVar));
            ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myOperation).forEach(op -> op.registerReusedElements(context::registerReusedElement));
            ((StreamEx)ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myInVar).distinct()).forEach(var -> var.register(context));
        }
    }
}

