/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalQuickFixWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.Equality;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolPresentation
implements ProblemDescriptionsProcessor,
InspectionToolPresentation {
    @NotNull
    private final InspectionToolWrapper myToolWrapper;
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    private static String ourOutputPath;
    protected InspectionNode myToolNode;
    private static final Object lock;
    private final Map<RefEntity, CommonProblemDescriptor[]> myProblemElements = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
    protected final Map<String, Set<RefEntity>> myContents = Collections.synchronizedMap(new HashMap(1));
    private final Set<RefModule> myModulesProblems = Collections.synchronizedSet(new THashSet(TObjectHashingStrategy.IDENTITY));
    private final Map<CommonProblemDescriptor, RefEntity> myProblemToElements = Collections.synchronizedMap(new THashMap(TObjectHashingStrategy.IDENTITY));
    private DescriptorComposer myComposer;
    private final Map<RefEntity, Set<QuickFix>> myQuickFixActions = Collections.synchronizedMap(new THashMap(TObjectHashingStrategy.IDENTITY));
    private final Map<RefEntity, CommonProblemDescriptor[]> myIgnoredElements = Collections.synchronizedMap(new THashMap(TObjectHashingStrategy.IDENTITY));
    protected static final Logger LOG;
    private volatile boolean isDisposed;

    public DefaultInspectionToolPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    public static String stripUIRefsFromInspectionDescription(String description) {
        int descriptionEnd = description.indexOf("<!-- tooltip end -->");
        if (descriptionEnd < 0) {
            Pattern pattern = Pattern.compile(".*Use.*(the (panel|checkbox|checkboxes|field|button|controls).*below).*", 32);
            Matcher matcher = pattern.matcher(description);
            int startFindIdx = 0;
            while (matcher.find(startFindIdx)) {
                int end;
                startFindIdx = end = matcher.end(1);
                description = description.substring(0, matcher.start(1)) + " inspection settings " + description.substring(end);
            }
        } else {
            description = description.substring(0, descriptionEnd);
        }
        return description;
    }

    @Override
    public HighlightSeverity getSeverity(@NotNull RefElement element) {
        PsiFile psiElement = element.getPointer().getContainingFile();
        if (psiElement != null) {
            GlobalInspectionContextImpl context = this.getContext();
            String shortName = this.getSeverityDelegateName();
            Tools tools = context.getTools().get(shortName);
            if (tools != null) {
                for (ScopeToolState state : tools.getTools()) {
                    InspectionToolWrapper toolWrapper = state.getTool();
                    if (toolWrapper != this.getToolWrapper()) continue;
                    return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                }
            }
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
            HighlightDisplayLevel level = profile2.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
            return level.getSeverity();
        }
        return null;
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    protected static String getTextAttributeKey(@NotNull Project project2, @NotNull HighlightSeverity severity, @NotNull ProblemHighlightType highlightType) {
        if (highlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            return HighlightInfoType.DEPRECATED.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL && severity == HighlightSeverity.ERROR) {
            return HighlightInfoType.WRONG_REF.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return HighlightInfoType.UNUSED_SYMBOL.getAttributesKey().getExternalName();
        }
        SeverityRegistrar registrar = ProjectInspectionProfileManager.getInstance(project2).getSeverityRegistrar();
        return registrar.getHighlightInfoTypeBySeverity(severity).getAttributesKey().getExternalName();
    }

    @Override
    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        return this.myToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        return this.getContext().getRefManager();
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl getContext() {
        return this.myContext;
    }

    @Override
    public void exportResults(final @NotNull Element parentNode, final @NotNull Predicate<RefEntity> excludedEntities, final @NotNull Predicate<CommonProblemDescriptor> excludedDescriptors) {
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolPresentation.this.exportResults(parentNode, elem, (Predicate<CommonProblemDescriptor>)excludedDescriptors);
                }
            }
        });
    }

    public void addProblemElement(RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        this.addProblemElement(refElement, true, descriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProblemElement(RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        if (refElement == null) {
            return;
        }
        if (descriptors.length == 0) {
            return;
        }
        if (filterSuppressed) {
            if (!DefaultInspectionToolPresentation.isOutputPathSet() || !(this.myToolWrapper instanceof LocalInspectionToolWrapper)) {
                Object object = lock;
                synchronized (object) {
                    Map<RefEntity, CommonProblemDescriptor[]> problemElements = this.getProblemElements();
                    CommonProblemDescriptor[] problems = problemElements.get(refElement);
                    problems = problems == null ? descriptors : DefaultInspectionToolPresentation.mergeDescriptors(problems, descriptors);
                    problemElements.put(refElement, problems);
                }
                for (CommonProblemDescriptor description : descriptors) {
                    this.getProblemToElements().put(description, refElement);
                    this.collectQuickFixes(description.getFixes(), refElement);
                }
            } else {
                this.writeOutput(descriptors, refElement);
            }
        } else {
            for (CommonProblemDescriptor descriptor : descriptors) {
                this.getProblemToElements().put(descriptor, refElement);
            }
        }
        GlobalInspectionContextImpl globalInspectionContextImpl = this.getContext();
        if (globalInspectionContextImpl.isViewClosed() || !(refElement instanceof RefElement)) {
            return;
        }
        if (this.myToolWrapper instanceof LocalInspectionToolWrapper && !ApplicationManager.getApplication().isUnitTestMode()) {
            globalInspectionContextImpl.initializeViewIfNeed().doWhenDone(() -> context.getView().addProblemDescriptors(this.myToolWrapper, refElement, descriptors));
        }
    }

    @NotNull
    public static CommonProblemDescriptor[] mergeDescriptors(@NotNull CommonProblemDescriptor[] problems1, @NotNull CommonProblemDescriptor[] problems2) {
        CommonProblemDescriptor[] out = new CommonProblemDescriptor[problems1.length + problems2.length];
        int o = problems1.length;
        Equality<CommonProblemDescriptor> equality = new Equality<CommonProblemDescriptor>(){

            public boolean equals(CommonProblemDescriptor o1, CommonProblemDescriptor o2) {
                if (o1 instanceof ProblemDescriptor) {
                    ProblemDescriptorBase p1 = (ProblemDescriptorBase)o1;
                    ProblemDescriptorBase p2 = (ProblemDescriptorBase)o2;
                    if (!Comparing.equal((String)p1.getDescriptionTemplate(), (String)p2.getDescriptionTemplate())) {
                        return false;
                    }
                    if (!Comparing.equal((Object)p1.getTextRange(), (Object)p2.getTextRange())) {
                        return false;
                    }
                    if (!Comparing.equal((Object)p1.getHighlightType(), (Object)p2.getHighlightType())) {
                        return false;
                    }
                    if (!Comparing.equal((Object)p1.getProblemGroup(), (Object)p2.getProblemGroup())) {
                        return false;
                    }
                    if (!Comparing.equal((Object)p1.getStartElement(), (Object)p2.getStartElement())) {
                        return false;
                    }
                    if (!Comparing.equal((Object)p1.getEndElement(), (Object)p2.getEndElement())) {
                        return false;
                    }
                } else if (!o1.toString().equals(o2.toString())) {
                    return false;
                }
                return true;
            }
        };
        for (CommonProblemDescriptor descriptor : problems2) {
            if (ArrayUtil.indexOf((Object[])problems1, (Object)descriptor, (Equality)equality) != -1) continue;
            out[o++] = descriptor;
        }
        System.arraycopy(problems1, 0, out, 0, problems1.length);
        return Arrays.copyOfRange(out, 0, o);
    }

    @Override
    public InspectionNode getToolNode() {
        return this.myToolNode;
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeOutput(@NotNull CommonProblemDescriptor[] descriptions, @NotNull RefEntity refElement) {
        Element parentNode = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
        this.exportResults(descriptions, refElement, parentNode, d -> false);
        List list = parentNode.getChildren();
        String ext = ".xml";
        String fileName = ourOutputPath + File.separator + this.myToolWrapper.getShortName() + ".xml";
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.getContext().getProject());
        try (PrintWriter printWriter = null;){
            new File(ourOutputPath).mkdirs();
            File file2 = new File(fileName);
            CharArrayWriter writer = new CharArrayWriter();
            if (!file2.exists()) {
                writer.append("<").append(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0])).append(" is_local_tool=\"").append(Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper)).append("\">\n");
            }
            for (Object o : list) {
                Element element = (Element)o;
                pathMacroManager.collapsePaths(element);
                JDOMUtil.writeElement((Element)element, (Writer)writer, (String)"\n");
            }
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), CharsetToolkit.UTF8_CHARSET)));
            printWriter.append("\n");
            printWriter.append(writer.toString());
        }
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        return this.getProblemToElements().keySet();
    }

    private void collectQuickFixes(QuickFix[] fixes, @NotNull RefEntity refEntity) {
        if (fixes != null && fixes.length != 0) {
            com.intellij.util.containers.HashSet localQuickFixes = this.getQuickFixActions().get(refEntity);
            if (localQuickFixes == null) {
                localQuickFixes = new com.intellij.util.containers.HashSet();
                this.getQuickFixActions().put(refEntity, (Set<QuickFix>)localQuickFixes);
            }
            ContainerUtil.addAll(localQuickFixes, (Object[])fixes);
        }
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] removedDescriptors = this.getProblemElements().remove(refEntity);
        if (removedDescriptors != null) {
            for (CommonProblemDescriptor descriptor : removedDescriptors) {
                this.getProblemToElements().remove(descriptor);
            }
        }
        this.getQuickFixActions().remove(refEntity);
    }

    @Override
    public void ignoreCurrentElement(RefEntity refEntity) {
        if (refEntity == null) {
            return;
        }
        this.getIgnoredElements().put(refEntity, DefaultInspectionToolPresentation.mergeDescriptors(this.getIgnoredElements().getOrDefault(refEntity, CommonProblemDescriptor.EMPTY_ARRAY), this.getProblemElements().getOrDefault(refEntity, CommonProblemDescriptor.EMPTY_ARRAY)));
    }

    @Override
    public void amnesty(RefEntity refEntity) {
        this.getIgnoredElements().remove(refEntity);
    }

    @Override
    public void amnesty(RefEntity refEntity, CommonProblemDescriptor descriptor) {
        Object[] ignoredDescriptors = this.getIgnoredElements().get(refEntity);
        if (ignoredDescriptors != null) {
            CommonProblemDescriptor[] remainElements = (CommonProblemDescriptor[])ArrayUtil.remove((Object[])ignoredDescriptors, (Object)descriptor);
            if (remainElements.length != 0) {
                this.getIgnoredElements().put(refEntity, remainElements);
            } else {
                this.getIgnoredElements().remove(refEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreProblem(RefEntity refEntity, CommonProblemDescriptor problem, int idx) {
        if (refEntity == null) {
            return;
        }
        Set<QuickFix> localQuickFixes = this.getQuickFixActions().get(refEntity);
        QuickFix[] fixes = problem.getFixes();
        if (DefaultInspectionToolPresentation.isIgnoreProblem(fixes, localQuickFixes, idx)) {
            this.getProblemToElements().remove(problem);
            Map<RefEntity, CommonProblemDescriptor[]> problemElements = this.getProblemElements();
            Object object = lock;
            synchronized (object) {
                CommonProblemDescriptor[] descriptors = problemElements.get(refEntity);
                if (descriptors != null) {
                    ArrayList<CommonProblemDescriptor> newDescriptors = new ArrayList<CommonProblemDescriptor>(Arrays.asList(descriptors));
                    newDescriptors.remove(problem);
                    CommonProblemDescriptor[] newDescriptorsAsArray = newDescriptors.toArray(new CommonProblemDescriptor[newDescriptors.size()]);
                    this.getQuickFixActions().put(refEntity, null);
                    if (!newDescriptors.isEmpty()) {
                        problemElements.put(refEntity, newDescriptorsAsArray);
                        for (CommonProblemDescriptor descriptor : newDescriptors) {
                            this.collectQuickFixes(descriptor.getFixes(), refEntity);
                        }
                    }
                    this.ignoreProblemElement(refEntity, newDescriptorsAsArray, problem);
                }
            }
        }
    }

    private void ignoreProblemElement(RefEntity refEntity, CommonProblemDescriptor[] newDescriptors, CommonProblemDescriptor toIgnore) {
        if (newDescriptors != null && newDescriptors.length == 0) {
            newDescriptors = null;
        }
        if (newDescriptors == null) {
            this.getProblemElements().remove(refEntity);
        } else {
            this.getProblemElements().put(refEntity, newDescriptors);
        }
        CommonProblemDescriptor[] oldIgnored = this.getIgnoredElements().getOrDefault(refEntity, CommonProblemDescriptor.EMPTY_ARRAY);
        CommonProblemDescriptor[] update2 = new CommonProblemDescriptor[oldIgnored.length + 1];
        System.arraycopy(oldIgnored, 0, update2, 0, oldIgnored.length);
        update2[update2.length - 1] = toIgnore;
        this.getIgnoredElements().put(refEntity, update2);
    }

    @Override
    public void ignoreCurrentElementProblem(RefEntity refEntity, CommonProblemDescriptor descriptor) {
        Object[] descriptors = this.getIgnoredElements().get(refEntity);
        if (descriptors == null) {
            descriptors = CommonProblemDescriptor.EMPTY_ARRAY;
        }
        this.getIgnoredElements().put(refEntity, (CommonProblemDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)descriptor));
    }

    private static boolean isIgnoreProblem(QuickFix[] problemFixes, Set<QuickFix> fixes, int idx) {
        if (problemFixes == null || fixes == null) {
            return true;
        }
        if (problemFixes.length <= idx) {
            return true;
        }
        for (QuickFix fix : problemFixes) {
            if (fix == problemFixes[idx] || fixes.contains(fix)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Object object = lock;
        synchronized (object) {
            this.myProblemElements.clear();
            this.myProblemToElements.clear();
            this.myQuickFixActions.clear();
            this.myIgnoredElements.clear();
            this.myContents.clear();
            this.myModulesProblems.clear();
        }
        this.isDisposed = true;
    }

    @Override
    public void finalCleanup() {
        this.cleanup();
    }

    @Nullable
    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] problems = this.getProblemElements().get(refEntity);
        if (problems == null) {
            return null;
        }
        if (!refEntity.isValid()) {
            this.ignoreElement(refEntity);
            return null;
        }
        return problems;
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DescriptorComposer(this);
        }
        return this.myComposer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportResults(@NotNull Element parentNode, @NotNull RefEntity refEntity, @NotNull Predicate<CommonProblemDescriptor> isDescriptorExcluded) {
        Object object = lock;
        synchronized (object) {
            CommonProblemDescriptor[] descriptions;
            if (this.getProblemElements().containsKey(refEntity) && (descriptions = this.getDescriptions(refEntity)) != null) {
                this.exportResults(descriptions, refEntity, parentNode, isDescriptorExcluded);
            }
        }
    }

    private void exportResults(@NotNull CommonProblemDescriptor[] descriptors, @NotNull RefEntity refEntity, @NotNull Element parentNode, @NotNull Predicate<CommonProblemDescriptor> isDescriptorExcluded) {
        for (CommonProblemDescriptor descriptor : descriptors) {
            HighlightSeverity severity;
            if (isDescriptorExcluded.test(descriptor)) continue;
            String template = descriptor.getDescriptionTemplate();
            int line = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getLineNumber() : -1;
            PsiElement psiElement = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
            String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement != null ? ProblemDescriptorUtil.extractHighlightedText(descriptor, psiElement) : "")), (String)" #loc ", (String)" ");
            Element element = refEntity.getRefManager().export(refEntity, parentNode, line);
            if (element == null) {
                return;
            }
            Element problemClassElement = new Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            problemClassElement.addContent(this.myToolWrapper.getDisplayName());
            if (refEntity instanceof RefElement) {
                RefElement refElement = (RefElement)refEntity;
                severity = this.getSeverity(refElement);
            } else {
                InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.getContext().getProject()).getCurrentProfile();
                HighlightDisplayLevel level = profile2.getErrorLevel(HighlightDisplayKey.find((String)this.myToolWrapper.getShortName()), psiElement);
                severity = level.getSeverity();
            }
            if (severity != null) {
                ProblemHighlightType problemHighlightType = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getHighlightType() : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String attributeKey = DefaultInspectionToolPresentation.getTextAttributeKey(this.getRefManager().getProject(), severity, problemHighlightType);
                problemClassElement.setAttribute("severity", severity.myName);
                problemClassElement.setAttribute("attribute_key", attributeKey);
            }
            element.addContent(problemClassElement);
            if (this.myToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)this.myToolWrapper).getTool();
                QuickFix[] fixes = descriptor.getFixes();
                if (fixes != null) {
                    Element hintsElement = new Element("hints");
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        Element hintElement = new Element("hint");
                        hintElement.setAttribute("value", hint);
                        hintsElement.addContent(hintElement);
                    }
                    element.addContent(hintsElement);
                }
            }
            try {
                Element descriptionElement = new Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
                descriptionElement.addContent(problemText);
                element.addContent(descriptionElement);
            }
            catch (IllegalDataException e) {
                System.out.println("Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName());
            }
        }
    }

    @Override
    public boolean isGraphNeeded() {
        return false;
    }

    @Override
    public boolean hasReportedProblems() {
        return !this.getProblemElements().isEmpty();
    }

    @Override
    public void updateContent() {
        this.myContents.clear();
        this.myModulesProblems.clear();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Set<RefEntity> elements = this.getProblemElements().keySet();
        for (RefEntity element : elements) {
            if (this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS && this.getIgnoredElements().containsKey(element)) continue;
            if (element instanceof RefModule) {
                this.myModulesProblems.add((RefModule)element);
                continue;
            }
            String groupName = element instanceof RefElement ? element.getRefManager().getGroupName((RefElement)element) : element.getQualifiedName();
            this.registerContentEntry(element, groupName);
        }
    }

    protected void registerContentEntry(RefEntity element, String packageName) {
        com.intellij.util.containers.HashSet content = this.myContents.get(packageName);
        if (content == null) {
            content = new com.intellij.util.containers.HashSet();
            this.myContents.put(packageName, (Set<RefEntity>)content);
        }
        content.add((RefEntity)element);
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        return this.myContents;
    }

    @Override
    @NotNull
    public Set<RefModule> getModuleProblems() {
        return this.myModulesProblems;
    }

    @Override
    @Nullable
    public QuickFixAction[] getQuickFixes(@NotNull RefEntity[] refElements, InspectionTree tree) {
        return this.extractActiveFixes(refElements, this.getProblemElements(), tree != null ? tree.getSelectedDescriptors() : null);
    }

    @Override
    @Nullable
    public QuickFixAction[] extractActiveFixes(@NotNull RefEntity[] refElements, @NotNull Map<RefEntity, CommonProblemDescriptor[]> descriptorMap, @Nullable CommonProblemDescriptor[] allowedDescriptors) {
        HashSet allowedDescriptorSet = allowedDescriptors == null ? null : ContainerUtil.newHashSet((Object[])allowedDescriptors);
        com.intellij.util.containers.HashMap result2 = new com.intellij.util.containers.HashMap();
        boolean isFirst = true;
        for (RefEntity refElement : refElements) {
            CommonProblemDescriptor[] descriptors = descriptorMap.get(refElement);
            if (descriptors == null) continue;
            for (CommonProblemDescriptor d : descriptors) {
                QuickFix[] fixes;
                if (allowedDescriptorSet != null && !allowedDescriptorSet.contains(d) || (fixes = d.getFixes()) == null) continue;
                if (isFirst) {
                    for (QuickFix fix : fixes) {
                        if (fix == null) continue;
                        LocalQuickFixWrapper quickFixWrapper = new LocalQuickFixWrapper(fix, this.myToolWrapper);
                        result2.put(fix.getFamilyName(), quickFixWrapper);
                    }
                    isFirst = false;
                    continue;
                }
                for (String familyName : new ArrayList(result2.keySet())) {
                    boolean isFound = false;
                    for (QuickFix fix : fixes) {
                        if (fix == null || !familyName.equals(fix.getFamilyName())) continue;
                        isFound = true;
                        LocalQuickFixWrapper quickFixAction = (LocalQuickFixWrapper)((Object)result2.get(fix.getFamilyName()));
                        LOG.assertTrue(DefaultInspectionToolPresentation.getFixClass(fix).equals(DefaultInspectionToolPresentation.getFixClass(quickFixAction.getFix())), (Object)("QuickFix-es with the same getFamilyName() should be the same class instances. Please assign reported exception for the fix \"" + fix.getClass().getName() + "\" developer"));
                        try {
                            quickFixAction.setText(StringUtil.escapeMnemonics((String)fix.getFamilyName()));
                        }
                        catch (AbstractMethodError e) {
                            quickFixAction.setText("Name is not available");
                        }
                        break;
                    }
                    if (isFound) continue;
                    result2.remove(familyName);
                    if (!result2.isEmpty()) continue;
                    return QuickFixAction.EMPTY;
                }
            }
        }
        return result2.values().isEmpty() ? null : result2.values().toArray(new QuickFixAction[result2.size()]);
    }

    private static Class getFixClass(QuickFix fix) {
        return fix instanceof ActionClassHolder ? ((ActionClassHolder)fix).getActionClass() : fix.getClass();
    }

    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
        return this.getProblemToElements().get(descriptor);
    }

    @Override
    public void ignoreProblem(@NotNull CommonProblemDescriptor descriptor, @NotNull QuickFix fix) {
        RefEntity refElement = this.getProblemToElements().get(descriptor);
        if (refElement != null) {
            QuickFix[] fixes = descriptor.getFixes();
            for (int i2 = 0; i2 < fixes.length; ++i2) {
                if (fixes[i2] != fix) continue;
                this.ignoreProblem(refElement, descriptor, i2);
                return;
            }
        }
    }

    @Override
    public boolean isElementIgnored(RefEntity element) {
        return this.getIgnoredElements().containsKey(element);
    }

    @Override
    public boolean isProblemResolved(RefEntity refEntity, CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            return true;
        }
        Object[] descriptors = this.getIgnoredElements().get(refEntity);
        return descriptors != null && ArrayUtil.contains((Object)descriptor, (Object[])descriptors);
    }

    @Override
    @NotNull
    public FileStatus getProblemStatus(@NotNull CommonProblemDescriptor descriptor) {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    @NotNull
    public FileStatus getElementStatus(RefEntity element) {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    @NotNull
    public Set<RefEntity> getIgnoredRefElements() {
        return this.getIgnoredElements().keySet();
    }

    @Override
    @NotNull
    public Map<RefEntity, CommonProblemDescriptor[]> getProblemElements() {
        return this.myProblemElements;
    }

    @NotNull
    private Map<CommonProblemDescriptor, RefEntity> getProblemToElements() {
        return this.myProblemToElements;
    }

    @NotNull
    private Map<RefEntity, Set<QuickFix>> getQuickFixActions() {
        return this.myQuickFixActions;
    }

    @Override
    @NotNull
    public Map<RefEntity, CommonProblemDescriptor[]> getIgnoredElements() {
        return this.myIgnoredElements;
    }

    @Override
    public void createToolNode(@NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider2, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        this.myToolNode = node;
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(final @NotNull CommonProblemDescriptor problemDescriptor, String hint) {
        InspectionProfileEntry tool = this.getToolWrapper().getTool();
        if (!(tool instanceof GlobalInspectionTool)) {
            return null;
        }
        final QuickFix fix = ((GlobalInspectionTool)tool).getQuickFix(hint);
        if (fix == null) {
            return null;
        }
        if (problemDescriptor instanceof ProblemDescriptor) {
            ProblemDescriptorImpl descriptor = new ProblemDescriptorImpl(((ProblemDescriptor)problemDescriptor).getStartElement(), ((ProblemDescriptor)problemDescriptor).getEndElement(), problemDescriptor.getDescriptionTemplate(), new LocalQuickFix[]{(LocalQuickFix)fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false);
            return QuickFixWrapper.wrap(descriptor, 0);
        }
        return new IntentionAction(){

            @NotNull
            public String getText() {
                return fix.getName();
            }

            @NotNull
            public String getFamilyName() {
                return fix.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                return true;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
                fix.applyFix(project2, problemDescriptor);
            }

            public boolean startInWriteAction() {
                return true;
            }
        };
    }

    public static synchronized void setOutputPath(String output) {
        ourOutputPath = output;
    }

    private static synchronized boolean isOutputPathSet() {
        return ourOutputPath != null;
    }

    static {
        lock = new Object();
        LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.DescriptorProviderInspection");
    }
}

