/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.CachedInspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class InspectionViewPsiTreeChangeAdapter
extends PsiTreeChangeAdapter {
    private static final int MAX_UPDATES_FOR_CANCELLABLE_ACTION = 100;
    private final InspectionResultsView myView;
    private final MergingUpdateQueue myUpdater;
    private final Alarm myAlarm;

    public InspectionViewPsiTreeChangeAdapter(final @NotNull InspectionResultsView view) {
        this.myView = view;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)view);
        this.myUpdater = new MergingUpdateQueue("inspection.view.psi.update.listener", 300, true, this.myView, this.myView, this.myView, Alarm.ThreadToUse.POOLED_THREAD){

            protected void execute(final @NotNull Update[] updates) {
                ReadTask task = new ReadTask(){

                    @Override
                    public void computeInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        indicator.setText("Updating inspection view tree...");
                        HashSet files = new HashSet();
                        for (Update update2 : updates) {
                            VirtualFile file2 = (VirtualFile)update2.getEqualityObjects()[0];
                            VfsUtilCore.iterateChildrenRecursively((VirtualFile)file2, (VirtualFileFilter)VirtualFileFilter.ALL, ((Set)files)::add);
                        }
                        Project project2 = view.getProject();
                        Runnable runnable2 = () -> this.lambda$computeInReadAction$2(view, (Set)files, project2);
                        if (updates.length > 100) {
                            ProgressManager.getInstance().executeNonCancelableSection(runnable2);
                        } else {
                            runnable2.run();
                        }
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (!InspectionViewPsiTreeChangeAdapter.this.myView.isDisposed()) {
                            for (Update update2 : updates) {
                                InspectionViewPsiTreeChangeAdapter.this.myUpdater.queue(update2);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private /* synthetic */ void lambda$computeInReadAction$2(@NotNull InspectionResultsView view, Set files, Project project2) {
                        if (view.isDisposed()) {
                            return;
                        }
                        Object object = InspectionViewPsiTreeChangeAdapter.this.myView.getTreeStructureUpdateLock();
                        synchronized (object) {
                            InspectionTreeNode root = InspectionViewPsiTreeChangeAdapter.this.myView.getTree().getRoot();
                            boolean[] needUpdateUI = new boolean[]{false};
                            InspectionViewPsiTreeChangeAdapter.processNodesIfNeed(root, (Processor<InspectionTreeNode>)node -> {
                                if (node instanceof CachedInspectionTreeNode) {
                                    RefEntity element = ((CachedInspectionTreeNode)node).getElement();
                                    if (element instanceof RefElement) {
                                        PsiFile file2;
                                        SmartPsiElementPointer pointer = ((RefElement)element).getPointer();
                                        VirtualFile strictVirtualFile = pointer.getVirtualFile();
                                        if ((strictVirtualFile == null || !strictVirtualFile.isValid()) && (file2 = pointer.getContainingFile()) != null && file2.isValid()) {
                                            strictVirtualFile = file2.getVirtualFile();
                                        }
                                        if (strictVirtualFile == null || files.contains(strictVirtualFile)) {
                                            ((CachedInspectionTreeNode)node).dropCache(project2);
                                            if (!needUpdateUI[0]) {
                                                needUpdateUI[0] = true;
                                            }
                                        }
                                        return false;
                                    }
                                    ((CachedInspectionTreeNode)node).dropCache(project2);
                                    if (!needUpdateUI[0]) {
                                        needUpdateUI[0] = true;
                                    }
                                    return false;
                                }
                                return true;
                            });
                            if (needUpdateUI[0]) {
                                InspectionViewPsiTreeChangeAdapter.this.myAlarm.cancelAllRequests();
                                InspectionViewPsiTreeChangeAdapter.this.myAlarm.addRequest(() -> InspectionViewPsiTreeChangeAdapter.this.myView.resetTree(), 100, ModalityState.NON_MODAL);
                            }
                        }
                    }
                };
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(InspectionViewPsiTreeChangeAdapter.this.myView.getTreeUpdater(), task);
            }
        };
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        this.processEventFileOrDir(event, false);
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        this.processEventFileOrDir(event, true);
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        this.processEventFileOrDir(event, true);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        this.processEventFileOrDir(event, false);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.processEventFileOrDir(event, false);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        this.processEventFileOrDir(event, false);
    }

    private void processEventFileOrDir(@NotNull PsiTreeChangeEvent event, boolean eagerEvaluateFiles) {
        PsiFile file2 = event.getFile();
        if (file2 != null) {
            VirtualFile vFile = file2.getVirtualFile();
            if (vFile == null) {
                return;
            }
            this.invalidateFiles(vFile);
        } else {
            VirtualFile childFile;
            PsiElement child = event.getChild();
            if (child instanceof PsiFileSystemItem && (childFile = ((PsiFileSystemItem)child).getVirtualFile()) != null) {
                if (eagerEvaluateFiles) {
                    HashSet files = new HashSet();
                    VfsUtilCore.iterateChildrenRecursively((VirtualFile)childFile, (VirtualFileFilter)VirtualFileFilter.ALL, ((Set)files)::add);
                    this.invalidateFiles(files.toArray(new VirtualFile[files.size()]));
                } else {
                    this.invalidateFiles(childFile);
                }
            }
        }
    }

    private static void processNodesIfNeed(InspectionTreeNode node, Processor<InspectionTreeNode> processor2) {
        if (processor2.process((Object)node)) {
            int count = node.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                InspectionViewPsiTreeChangeAdapter.processNodesIfNeed((InspectionTreeNode)node.getChildAt(i2), processor2);
            }
        }
    }

    private void invalidateFiles(VirtualFile ... files) {
        for (VirtualFile file2 : files) {
            this.myUpdater.queue(new Update(file2){

                public void run() {
                }

                public boolean canEat(Update update2) {
                    return false;
                }
            });
        }
    }
}

