/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ExcludedInspectionTreeNodesManager;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xml.util.XmlStringUtil;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends SuppressableInspectionTreeNode {
    protected final InspectionToolWrapper myToolWrapper;
    private final CommonProblemDescriptor myDescriptor;
    private final HighlightDisplayLevel myLevel;
    protected final int myLineNumber;
    protected final RefEntity myElement;

    public ProblemDescriptionNode(RefEntity element, CommonProblemDescriptor descriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        this(element, descriptor, toolWrapper, presentation, true, null);
    }

    protected ProblemDescriptionNode(@Nullable RefEntity element, CommonProblemDescriptor descriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation, boolean doInit, @Nullable IntSupplier lineNumberCounter) {
        super((Object)descriptor, presentation);
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myToolWrapper = toolWrapper;
        InspectionProfileImpl profile2 = presentation.getContext().getCurrentProfile();
        HighlightDisplayLevel highlightDisplayLevel = this.myLevel = descriptor instanceof ProblemDescriptor ? profile2.getErrorLevel(HighlightDisplayKey.find((String)toolWrapper.getShortName()), ((ProblemDescriptor)descriptor).getStartElement()) : profile2.getTools(toolWrapper.getShortName(), presentation.getContext().getProject()).getLevel();
        if (doInit) {
            this.init(presentation.getContext().getProject());
        }
        this.myLineNumber = this.myDescriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)this.myDescriptor).getLineNumber() : (lineNumberCounter == null ? -1 : lineNumberCounter.getAsInt());
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Override
    public boolean canSuppress() {
        return super.canSuppress() && !this.isQuickFixAppliedFromView();
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        return this.myToolWrapper;
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public int getProblemCount(boolean allowSuppressed) {
        return this.myPresentation.isProblemResolved(this.getElement(), this.myDescriptor) && (!allowSuppressed || !this.isAlreadySuppressedFromView() || !this.isValid()) ? 0 : 1;
    }

    @Override
    public void visitProblemSeverities(FactoryMap<HighlightDisplayLevel, Integer> counter) {
        if (!this.myPresentation.isProblemResolved(this.getElement(), this.myDescriptor)) {
            counter.put((Object)this.myLevel, (Object)((Integer)counter.get((Object)this.myLevel) + 1));
        }
    }

    @Override
    protected boolean calculateIsValid() {
        if (this.myDescriptor == null) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (this.myDescriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)this.myDescriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    public void excludeElement(ExcludedInspectionTreeNodesManager manager) {
        InspectionToolPresentation presentation = this.getPresentation();
        presentation.ignoreCurrentElementProblem(this.getElement(), this.getDescriptor());
        super.excludeElement(manager);
    }

    @Override
    public void amnestyElement(ExcludedInspectionTreeNodesManager manager) {
        if (!this.isAlreadySuppressedFromView()) {
            InspectionToolPresentation presentation = this.getPresentation();
            presentation.amnesty(this.getElement(), this.getDescriptor());
        }
        super.amnestyElement(manager);
    }

    @Override
    @NotNull
    public InspectionToolPresentation getPresentation() {
        return this.myPresentation;
    }

    @Override
    public FileStatus getNodeStatus() {
        if (this.myElement instanceof RefElement) {
            return this.getPresentation().getProblemStatus(this.myDescriptor);
        }
        return FileStatus.NOT_CHANGED;
    }

    @Override
    protected void dropCache(Project project2) {
        if (!this.isQuickFixAppliedFromView()) {
            super.dropCache(project2);
        }
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return "";
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
        return XmlStringUtil.stripHtml((String)ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, 4));
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.myDescriptor != null && this.myPresentation.isProblemResolved(this.getElement(), this.myDescriptor) && !this.isAlreadySuppressedFromView();
    }

    @Override
    @Nullable
    public String getCustomizedTailText() {
        if (this.isQuickFixAppliedFromView()) {
            return "";
        }
        String text = super.getCustomizedTailText();
        return text == null ? "" : text;
    }
}

