/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.CachedInspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.RefElementAndDescriptorAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuppressableInspectionTreeNode
extends CachedInspectionTreeNode
implements RefElementAndDescriptorAware {
    @NotNull
    private final InspectionResultsView myView;
    private volatile Set<SuppressIntentionAction> myAvailableSuppressActions;
    protected final InspectionToolPresentation myPresentation;

    protected SuppressableInspectionTreeNode(Object userObject, @NotNull InspectionToolPresentation presentation) {
        super(userObject);
        this.myView = presentation.getContext().getView();
        this.myPresentation = presentation;
    }

    @Override
    @NotNull
    public InspectionToolPresentation getPresentation() {
        return this.myPresentation;
    }

    public boolean canSuppress() {
        return this.isLeaf();
    }

    public final boolean isAlreadySuppressedFromView() {
        Object usrObj = this.getUserObject();
        return usrObj != null && this.myView.getSuppressedNodes(this.myPresentation.getToolWrapper().getShortName()).contains(usrObj);
    }

    public abstract boolean isQuickFixAppliedFromView();

    @Override
    @Nullable
    public String getCustomizedTailText() {
        String text = super.getCustomizedTailText();
        if (text != null) {
            return text;
        }
        return this.isAlreadySuppressedFromView() ? "Suppressed" : null;
    }

    @NotNull
    public Set<SuppressIntentionAction> getAvailableSuppressActions() {
        return this.myAvailableSuppressActions;
    }

    public void removeSuppressActionFromAvailable(@NotNull SuppressIntentionAction action) {
        this.myAvailableSuppressActions.remove(action);
    }

    @Override
    protected void init(Project project2) {
        super.init(project2);
        this.myAvailableSuppressActions = this.getElement() == null ? Collections.emptySet() : this.getOnlyAvailableSuppressActions(project2);
    }

    @NotNull
    public final Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor = this.getDescriptor();
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null);
        return Pair.create((Object)element, (Object)descriptor);
    }

    @NotNull
    private Set<SuppressIntentionAction> getOnlyAvailableSuppressActions(@NotNull Project project2) {
        Set<SuppressIntentionAction> actions = this.getSuppressActions();
        if (actions.isEmpty()) {
            return Collections.emptySet();
        }
        Pair<PsiElement, CommonProblemDescriptor> suppress = this.getSuppressContent();
        PsiElement suppressElement = (PsiElement)suppress.getFirst();
        if (suppressElement == null) {
            return actions;
        }
        Set availableActions = null;
        for (SuppressIntentionAction action : actions) {
            if (!action.isAvailable(project2, null, suppressElement)) continue;
            if (availableActions == null) {
                availableActions = ContainerUtil.newConcurrentSet((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
            }
            availableActions.add(action);
        }
        return availableActions == null ? Collections.emptySet() : availableActions;
    }

    @NotNull
    private Set<SuppressIntentionAction> getSuppressActions() {
        return this.myView.getSuppressActions(this.myPresentation.getToolWrapper());
    }
}

