/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import java.awt.Component;
import javax.swing.JComponent;

public class InvokeQuickFixAction
extends AnAction {
    private final InspectionResultsView myView;

    public InvokeQuickFixAction(InspectionResultsView view) {
        super(InspectionsBundle.message((String)"inspection.action.apply.quickfix", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.apply.quickfix.description", (Object[])new Object[0]), AllIcons.Actions.CreateFromUsage);
        this.myView = view;
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ShowIntentionActions").getShortcutSet(), (JComponent)((Object)this.myView.getTree()));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        InspectionToolWrapper toolWrapper = this.myView.getTree().getSelectedToolWrapper(true);
        InspectionRVContentProvider provider2 = this.myView.getProvider();
        if (toolWrapper == null || InvokeQuickFixAction.cantApplyFixes(this.myView)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(provider2.hasQuickFixes(this.myView.getTree()));
    }

    public void actionPerformed(AnActionEvent e) {
        ActionGroup fixes = (ActionGroup)ActionManager.getInstance().getAction("QuickFixes");
        if (fixes.getChildren(e).length == 0) {
            Messages.showInfoMessage((Component)this.myView, (String)"There are no applicable quick fixes", (String)"Nothing Found to Fix");
            return;
        }
        DataContext dataContext = e.getDataContext();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(InspectionsBundle.message((String)"inspection.tree.popup.title", (Object[])new Object[0]), fixes, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        InspectionResultsView.showPopup(e, (JBPopup)popup);
    }

    static boolean cantApplyFixes(InspectionResultsView view) {
        return view.isUpdating() && !view.getTree().areDescriptorNodesSelected();
    }
}

