/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.codeInspection.ui.actions.InspectionViewActionBase;
import com.intellij.codeInspection.ui.actions.KeyAwareInspectionViewAction;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionSequentialTask;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionWrapper
extends ActionGroup
implements CompactActionGroup {
    private static final Logger LOG = Logger.getInstance(SuppressActionWrapper.class);

    public SuppressActionWrapper() {
        super(InspectionsBundle.message((String)"suppress.inspection.problem", (Object[])new Object[0]), false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        InspectionResultsView view = InspectionViewActionBase.getView(e);
        if (view == null) {
            return AnAction.EMPTY_ARRAY;
        }
        InspectionToolWrapper wrapper = view.getTree().getSelectedToolWrapper(true);
        if (wrapper == null) {
            return AnAction.EMPTY_ARRAY;
        }
        Set<SuppressIntentionAction> suppressActions = view.getSuppressActions(wrapper);
        if (suppressActions.isEmpty()) {
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] actions = new AnAction[suppressActions.size() + 1];
        int i2 = 0;
        for (SuppressIntentionAction action : suppressActions) {
            actions[i2++] = new SuppressTreeAction(action);
        }
        actions[suppressActions.size()] = Separator.getInstance();
        Arrays.sort(actions, new Comparator<AnAction>(){

            @Override
            public int compare(AnAction a1, AnAction a2) {
                return this.getWeight(a1) - this.getWeight(a2);
            }

            public int getWeight(AnAction a) {
                return a instanceof Separator ? 0 : (((SuppressTreeAction)a).isSuppressAll() ? 1 : -1);
            }
        });
        return actions;
    }

    public static class SuppressTreeAction
    extends KeyAwareInspectionViewAction {
        private final SuppressIntentionAction mySuppressAction;

        public SuppressTreeAction(SuppressIntentionAction suppressAction) {
            super(suppressAction.getText());
            this.mySuppressAction = suppressAction;
        }

        @Override
        protected void actionPerformed(@NotNull InspectionResultsView view, @NotNull HighlightDisplayKey key2) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project2 = view.getProject();
                String templatePresentationText = this.getTemplatePresentation().getText();
                LOG.assertTrue(templatePresentationText != null);
                InspectionToolWrapper wrapper = view.getTree().getSelectedToolWrapper(true);
                LOG.assertTrue(wrapper != null);
                Set<SuppressableInspectionTreeNode> nodesAsSet = this.getNodesToSuppress(view);
                SuppressableInspectionTreeNode[] nodes = nodesAsSet.toArray(new SuppressableInspectionTreeNode[nodesAsSet.size()]);
                CommandProcessor.getInstance().executeCommand(project2, () -> {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, templatePresentationText, true);
                    progressTask.setMinIterationTime(200L);
                    progressTask.setTask(new SuppressActionSequentialTask(nodes, this.mySuppressAction, wrapper, view.getGlobalInspectionContext()));
                    ProgressManager.getInstance().run((Task)progressTask);
                }, templatePresentationText, null);
                Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance((Project)project2)).getRunningContexts();
                for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                    context.refreshViews();
                }
                view.syncRightPanel();
            });
        }

        @Override
        protected boolean isEnabled(@NotNull InspectionResultsView view, AnActionEvent e) {
            Set<SuppressableInspectionTreeNode> suppressNodes = this.getNodesToSuppress(view);
            for (SuppressableInspectionTreeNode node : suppressNodes) {
                PsiElement element;
                if (!node.getAvailableSuppressActions().contains(this.mySuppressAction)) continue;
                String text = this.mySuppressAction.getFamilyName();
                if (suppressNodes.size() == 1 && (element = (PsiElement)node.getSuppressContent().getFirst()) != null) {
                    this.mySuppressAction.isAvailable(view.getProject(), null, element);
                    text = this.mySuppressAction.getText();
                }
                e.getPresentation().setText(text);
                return true;
            }
            return false;
        }

        public boolean isSuppressAll() {
            return this.mySuppressAction.isSuppressAll();
        }

        private Set<SuppressableInspectionTreeNode> getNodesToSuppress(@NotNull InspectionResultsView view) {
            TreePath[] paths = view.getTree().getSelectionPaths();
            if (paths == null) {
                return Collections.emptySet();
            }
            HashSet result2 = new HashSet();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (!(node instanceof TreeNode)) continue;
                TreeUtil.traverse((TreeNode)((TreeNode)node), arg_0 -> this.lambda$getNodesToSuppress$2((Set)result2, arg_0));
            }
            return result2;
        }

        private /* synthetic */ boolean lambda$getNodesToSuppress$2(Set result2, Object node1) {
            InspectionTreeNode n = (InspectionTreeNode)node1;
            if (n instanceof SuppressableInspectionTreeNode && ((SuppressableInspectionTreeNode)n).canSuppress() && ((SuppressableInspectionTreeNode)n).getAvailableSuppressActions().contains(this.mySuppressAction) && n.isValid()) {
                result2.add((SuppressableInspectionTreeNode)n);
            }
            return true;
        }
    }
}

