/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryModuleDependencyInspection
extends GlobalInspectionTool {
    private SoftReference<Graph<Module>> myGraph = new SoftReference(null);

    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new UnnecessaryModuleDependencyAnnotator(refManager);
    }

    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module2 = refModule.getModule();
            if (module2.isDisposed() || !scope.containsModule(module2)) {
                return CommonProblemDescriptor.EMPTY_ARRAY;
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            OrderEntry[] declaredDependencies = moduleRootManager.getOrderEntries();
            Object[] declaredModuleDependencies = moduleRootManager.getDependencies();
            ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
            Set modules = (Set)refModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES);
            Graph graph = (Graph)this.myGraph.get();
            if (graph == null) {
                graph = ModuleManager.getInstance((Project)globalContext.getProject()).moduleGraph();
                this.myGraph = new SoftReference((Object)graph);
            }
            RefManager refManager = globalContext.getRefManager();
            for (OrderEntry entry : declaredDependencies) {
                Module dependency;
                if (!(entry instanceof ModuleOrderEntry) || (dependency = ((ModuleOrderEntry)entry).getModule()) == null || modules != null && modules.contains(dependency)) continue;
                ArrayList<String> dependenciesThroughExported = null;
                if (((ModuleOrderEntry)entry).isExported()) {
                    Iterator iterator = graph.getOut((Object)module2);
                    while (iterator.hasNext()) {
                        Set neededModules;
                        Module dep = (Module)iterator.next();
                        RefModule depRefModule = refManager.getRefModule(dep);
                        if (depRefModule == null || (neededModules = (Set)depRefModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES)) == null || !neededModules.contains(dependency)) continue;
                        if (dependenciesThroughExported == null) {
                            dependenciesThroughExported = new ArrayList<String>();
                        }
                        dependenciesThroughExported.add(dep.getName());
                    }
                }
                if (modules != null) {
                    RefModule dependenciesOfDependencies;
                    ArrayList<String> transitiveDependencies = new ArrayList<String>();
                    for (RefModule secondDependency : dependenciesOfDependencies = ModuleRootManager.getInstance((Module)dependency).getOrderEntries()) {
                        Module mod;
                        if (!(secondDependency instanceof ModuleOrderEntry) || !((ModuleOrderEntry)secondDependency).isExported() || (mod = ((ModuleOrderEntry)secondDependency).getModule()) == null || !modules.contains(mod) || ArrayUtil.find((Object[])declaredModuleDependencies, (Object)mod) >= 0) continue;
                        transitiveDependencies.add(mod.getName());
                    }
                    if (!transitiveDependencies.isEmpty()) {
                        String exported = StringUtil.join(transitiveDependencies, (String)", ");
                        descriptors.add(manager.createProblemDescriptor(InspectionsBundle.message((String)"unnecessary.module.dependency.exported.problem.descriptor1", (Object[])new Object[]{module2.getName(), dependency.getName(), exported}), new QuickFix[0]));
                        continue;
                    }
                }
                descriptors.add(UnnecessaryModuleDependencyInspection.createDescriptor(scope, manager, module2, dependency, dependenciesThroughExported));
            }
            return descriptors.isEmpty() ? null : descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
        }
        return null;
    }

    private static CommonProblemDescriptor createDescriptor(AnalysisScope scope, InspectionManager manager, Module module2, Module dependency, List<String> exportedDependencies) {
        if (exportedDependencies != null) {
            String exported = StringUtil.join(exportedDependencies, (String)", ");
            return manager.createProblemDescriptor(InspectionsBundle.message((String)"unnecessary.module.dependency.exported.problem.descriptor", (Object[])new Object[]{module2.getName(), dependency.getName(), exported}), new QuickFix[0]);
        }
        if (scope.containsModule(dependency)) {
            String allContainsMessage = InspectionsBundle.message((String)"unnecessary.module.dependency.problem.descriptor", (Object[])new Object[]{module2.getName(), dependency.getName()});
            return manager.createProblemDescriptor(allContainsMessage, new QuickFix[]{new RemoveModuleDependencyFix(module2, dependency)});
        }
        String message2 = InspectionsBundle.message((String)"suspected.module.dependency.problem.descriptor", (Object[])new Object[]{module2.getName(), dependency.getName(), scope.getDisplayName()});
        return manager.createProblemDescriptor(message2, new QuickFix[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"unnecessary.module.dependency.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "UnnecessaryModuleDependencyInspection";
    }

    public static class RemoveModuleDependencyFix
    implements QuickFix {
        private final Module myModule;
        private final Module myDependency;

        public RemoveModuleDependencyFix(Module module2, Module dependency) {
            this.myModule = module2;
            this.myDependency = dependency;
        }

        @NotNull
        public String getFamilyName() {
            return "Remove dependency";
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                Module mDependency;
                if (!(entry instanceof ModuleOrderEntry) || !Comparing.equal((Object)(mDependency = ((ModuleOrderEntry)entry).getModule()), (Object)this.myDependency)) continue;
                model.removeOrderEntry(entry);
                break;
            }
            model.commit();
        }
    }
}

