/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedReturnValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.unusedReturnValue.UnusedReturnValueLocalInspection;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.controlflow.UnnecessaryReturnInspection;
import com.siyeh.ig.psiutils.SideEffectChecker;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedReturnValue
extends GlobalJavaBatchInspectionTool {
    public boolean IGNORE_BUILDER_PATTERN;

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isConstructor()) {
                return null;
            }
            if (!refMethod.getSuperMethods().isEmpty()) {
                return null;
            }
            if (refMethod.getInReferences().size() == 0) {
                return null;
            }
            if (!refMethod.isReturnValueUsed()) {
                PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
                if (this.IGNORE_BUILDER_PATTERN && PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod)) {
                    return null;
                }
                boolean isNative = psiMethod.hasModifierProperty("native");
                if (refMethod.isExternalOverride() && !isNative) {
                    return null;
                }
                return new ProblemDescriptor[]{UnusedReturnValue.createProblemDescriptor(psiMethod, manager, processor2, isNative)};
            }
        }
        return null;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.IGNORE_BUILDER_PATTERN) {
            super.writeSettings(node);
        }
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore simple setters", (InspectionProfileEntry)this, "IGNORE_BUILDER_PATTERN");
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor2.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    processor2.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.unused.return.value.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getShortName() {
        return "UnusedReturnValue";
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new MakeVoidQuickFix(null);
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new UnusedReturnValueLocalInspection(this);
    }

    static ProblemDescriptor createProblemDescriptor(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, @Nullable ProblemDescriptionsProcessor processor2, boolean isNative) {
        return manager.createProblemDescriptor((PsiElement)psiMethod.getNameIdentifier(), InspectionsBundle.message((String)"inspection.unused.return.value.problem.descriptor", (Object[])new Object[0]), (LocalQuickFix)(isNative ? null : new MakeVoidQuickFix(processor2)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
    }

    private static class MakeVoidQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private static final Logger LOG = Logger.getInstance(MakeVoidQuickFix.class);

        public MakeVoidQuickFix(@Nullable ProblemDescriptionsProcessor processor2) {
            this.myProcessor = processor2;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.unused.return.value.make.void.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiMethod psiMethod = null;
            if (this.myProcessor != null) {
                RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
                if (refElement instanceof RefMethod && refElement.isValid()) {
                    RefMethod refMethod = (RefMethod)refElement;
                    psiMethod = (PsiMethod)refMethod.getElement();
                }
            } else {
                psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
            }
            if (psiMethod == null) {
                return;
            }
            MakeVoidQuickFix.makeMethodHierarchyVoid(project2, psiMethod);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            return currentFile;
        }

        private static void makeMethodHierarchyVoid(Project project2, @NotNull PsiMethod psiMethod) {
            MakeVoidQuickFix.replaceReturnStatements(psiMethod);
            for (PsiMethod oMethod : OverridingMethodsSearch.search((PsiMethod)psiMethod)) {
                MakeVoidQuickFix.replaceReturnStatements(oMethod);
            }
            PsiParameter[] params = psiMethod.getParameterList().getParameters();
            ParameterInfoImpl[] infos = new ParameterInfoImpl[params.length];
            for (int i = 0; i < params.length; ++i) {
                PsiParameter param = params[i];
                infos[i] = new ParameterInfoImpl(i, param.getName(), param.getType());
            }
            ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project2, psiMethod, false, null, psiMethod.getName(), (PsiType)PsiType.VOID, infos);
            csp.run();
        }

        private static void replaceReturnStatements(@NotNull PsiMethod method2) {
            PsiReturnStatement[] statements = PsiUtil.findReturnStatements((PsiMethod)method2);
            for (int i = statements.length - 1; i >= 0; --i) {
                PsiReturnStatement returnStatement = statements[i];
                try {
                    PsiExpression expression2 = returnStatement.getReturnValue();
                    if (expression2 == null) continue;
                    WriteAction.run(() -> {
                        boolean mayHaveSideEffects = SideEffectChecker.mayHaveSideEffects(expression2);
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method2.getProject());
                        PsiReturnStatement ret = (PsiReturnStatement)returnStatement.replace((PsiElement)factory.createStatementFromText("return;", (PsiElement)returnStatement));
                        if (mayHaveSideEffects) {
                            PsiStatement statement2 = factory.createStatementFromText(expression2.getText() + ";", (PsiElement)method2);
                            ret.getParent().addBefore((PsiElement)statement2, (PsiElement)ret);
                        }
                        if (UnnecessaryReturnInspection.isReturnRedundant(ret, false, null)) {
                            ret.delete();
                        }
                    });
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

