/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpecialAnnotationsUtilBase {
    public static LocalQuickFix createAddToSpecialAnnotationsListQuickFix(final @NotNull String text, final @NotNull String family, final @NotNull List<String> targetList, final @NotNull String qualifiedName, PsiElement context) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                return text;
            }

            @NotNull
            public String getFamilyName() {
                return family;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                SpecialAnnotationsUtilBase.doQuickFixInternal(project2, targetList, qualifiedName);
            }
        };
    }

    static void doQuickFixInternal(@NotNull Project project2, @NotNull List<String> targetList, @NotNull String qualifiedName) {
        targetList.add(qualifiedName);
        Collections.sort(targetList);
        ProjectInspectionProfileManager.getInstance(project2).fireProfileChanged();
    }

    public static void createAddToSpecialAnnotationFixes(@NotNull PsiModifierListOwner owner, @NotNull Processor<String> processor2) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            PsiAnnotation psiAnnotation;
            String name;
            PsiAnnotation[] psiAnnotations;
            PsiAnnotation[] psiAnnotationArray = psiAnnotations = modifierList.getAnnotations();
            int n = psiAnnotationArray.length;
            for (int j = 0; j < n && ((name = (psiAnnotation = psiAnnotationArray[j]).getQualifiedName()) == null || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.jetbrains.") && AnnotationUtil.isJetbrainsAnnotation((String)StringUtil.getShortName((String)name)) || processor2.process((Object)name)); ++j) {
            }
        }
    }
}

