/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.varScopeCanBeNarrowed.BaseConvertToLocalQuickFix;
import com.intellij.codeInspection.varScopeCanBeNarrowed.ParameterCanBeLocalInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterCanBeLocalInspection
extends ParameterCanBeLocalInspectionBase {
    @Override
    protected ConvertParameterToLocalQuickFix createFix() {
        return new ConvertParameterToLocalQuickFix();
    }

    public static class ConvertParameterToLocalQuickFix
    extends BaseConvertToLocalQuickFix<PsiParameter> {
        @Override
        protected PsiParameter getVariable(@NotNull ProblemDescriptor descriptor) {
            return (PsiParameter)descriptor.getPsiElement().getParent();
        }

        @Override
        protected PsiElement applyChanges(final @NotNull Project project2, final @NotNull String localName, final @Nullable PsiExpression initializer, final @NotNull PsiParameter parameter, final @NotNull Collection<PsiReference> references, boolean delete, final @NotNull NotNullFunction<PsiDeclarationStatement, PsiElement> action) {
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)scope;
                PsiParameter[] parameters2 = method2.getParameterList().getParameters();
                ArrayList<ParameterInfoImpl> info = new ArrayList<ParameterInfoImpl>();
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    PsiParameter psiParameter = parameters2[i2];
                    if (psiParameter == parameter) continue;
                    info.add(new ParameterInfoImpl(i2, psiParameter.getName(), psiParameter.getType()));
                }
                ParameterInfoImpl[] newParams = info.toArray(new ParameterInfoImpl[info.size()]);
                String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method2.getModifierList());
                PsiType returnType = method2.getReturnType();
                JavaChangeInfoImpl changeInfo = new JavaChangeInfoImpl(visibilityModifier, method2, method2.getName(), returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null, newParams, null, false, ContainerUtil.newHashSet(), ContainerUtil.newHashSet());
                ChangeSignatureProcessor cp = new ChangeSignatureProcessor(project2, changeInfo){

                    @Override
                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                        PsiElement newDeclaration = this.moveDeclaration(elementFactory, localName, parameter, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
                        super.performRefactoring(usages);
                        BaseConvertToLocalQuickFix.positionCaretToDeclaration(project2, newDeclaration.getContainingFile(), newDeclaration);
                    }
                };
                cp.run();
            }
            return null;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        @NotNull
        protected String suggestLocalName(@NotNull Project project2, @NotNull PsiParameter parameter, @NotNull PsiCodeBlock scope) {
            return parameter.getName();
        }
    }
}

