/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.visibility.VisibilityInspection;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.TObjectIntHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessCanBeTightenedInspection
extends BaseJavaBatchLocalInspectionTool {
    private final VisibilityInspection myVisibilityInspection;

    AccessCanBeTightenedInspection(@NotNull VisibilityInspection visibilityInspection) {
        this.myVisibilityInspection = visibilityInspection;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.VISIBILITY_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return "Member access can be tightened";
    }

    @NotNull
    public String getShortName() {
        return "WeakerAccess";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new MyVisitor(holder);
    }

    private static boolean isInnerClass(@NotNull PsiClass memberClass) {
        return memberClass.getContainingClass() != null || memberClass instanceof PsiAnonymousClass;
    }

    private static boolean isInReferenceList(@Nullable PsiElement list, final @NotNull PsiMember member) {
        if (list == null) {
            return false;
        }
        final PsiManager psiManager = member.getManager();
        final boolean[] result2 = new boolean[1];
        list.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (psiManager.areElementsEquivalent(reference.resolve(), (PsiElement)member)) {
                    result2[0] = true;
                    this.stopWalking();
                }
            }
        });
        return result2[0];
    }

    @PsiUtil.AccessLevel
    private int suggestPackageLocal(@NotNull PsiMember member) {
        boolean suggestPackageLocal = member instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)((PsiClass)member)) ? this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES : this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS;
        return suggestPackageLocal ? 2 : 4;
    }

    private static void log(String s) {
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final UnusedDeclarationInspectionBase myDeadCodeInspection;
        private final TObjectIntHashMap<PsiClass> maxSuggestedLevelForChildMembers = new TObjectIntHashMap();

        public MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(holder.getProject()).getCurrentProfile();
            UnusedDeclarationInspectionBase tool = (UnusedDeclarationInspectionBase)profile2.getUnwrappedTool("unused", (PsiElement)holder.getFile());
            this.myDeadCodeInspection = tool == null ? new UnusedDeclarationInspectionBase() : tool;
        }

        public void visitClass(PsiClass aClass) {
            this.checkMember((PsiMember)aClass);
        }

        public void visitMethod(PsiMethod method2) {
            this.checkMember((PsiMember)method2);
        }

        public void visitField(PsiField field) {
            this.checkMember((PsiMember)field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMember(@NotNull PsiMember member) {
            PsiClass memberClass = member.getContainingClass();
            PsiModifierList memberModifierList = member.getModifierList();
            if (memberModifierList == null) {
                return;
            }
            int currentLevel = PsiUtil.getAccessLevel((PsiModifierList)memberModifierList);
            int suggestedLevel = this.suggestLevel(member, memberClass, currentLevel);
            if (memberClass != null) {
                TObjectIntHashMap<PsiClass> tObjectIntHashMap = this.maxSuggestedLevelForChildMembers;
                synchronized (tObjectIntHashMap) {
                    int prevMax = this.maxSuggestedLevelForChildMembers.get((Object)memberClass);
                    this.maxSuggestedLevelForChildMembers.put((Object)memberClass, Math.max(prevMax, suggestedLevel));
                }
            }
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + PsiUtil.getAccessModifier((int)suggestedLevel) + "'");
            if (suggestedLevel < currentLevel) {
                PsiElement toHighlight;
                if (member instanceof PsiClass) {
                    int memberMaxLevel;
                    TObjectIntHashMap<PsiClass> prevMax = this.maxSuggestedLevelForChildMembers;
                    synchronized (prevMax) {
                        memberMaxLevel = this.maxSuggestedLevelForChildMembers.get((Object)((PsiClass)member));
                    }
                    if (memberMaxLevel > suggestedLevel) {
                        return;
                    }
                }
                PsiClass cls = memberClass;
                if (member instanceof PsiClass) {
                    cls = (PsiClass)member;
                }
                while (cls != null) {
                    String name = cls.getQualifiedName();
                    if (name != null && ("android.content.Context".equals(name) || "android.app.Fragment".equals(name) || "android.support.v4.app.Fragment".equals(name) || "android.view.View".equals(name) || "android.content.ContentProvider".equals(name) || "android.content.BroadcastReceiver".equals(name) || "android.view.ActionProvider".equals(name) || "android.os.Parcelable".equals(name))) {
                        return;
                    }
                    cls = cls.getSuperClass();
                }
                PsiElement psiElement = toHighlight = currentLevel == 2 ? ((PsiNameIdentifierOwner)member).getNameIdentifier() : (PsiElement)ContainerUtil.find((Object[])memberModifierList.getChildren(), element -> element instanceof PsiKeyword && element.getText().equals(PsiUtil.getAccessModifier((int)currentLevel)));
                assert (toHighlight != null) : member + " ; " + ((PsiNameIdentifierOwner)member).getNameIdentifier() + "; " + memberModifierList.getText();
                String suggestedModifier = PsiUtil.getAccessModifier((int)suggestedLevel);
                this.myHolder.registerProblem(toHighlight, "Access can be " + VisibilityUtil.toPresentableText((String)suggestedModifier), new LocalQuickFix[]{new ChangeModifierFix(suggestedModifier)});
            }
        }

        @PsiUtil.AccessLevel
        private int suggestLevel(@NotNull PsiMember member, PsiClass memberClass, @PsiUtil.AccessLevel int currentLevel) {
            PsiDirectory memberDirectory;
            if (member.hasModifierProperty("private") || member.hasModifierProperty("native")) {
                return currentLevel;
            }
            if (member instanceof PsiMethod && member instanceof SyntheticElement || !member.isPhysical()) {
                return currentLevel;
            }
            if (member instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)member;
                if (!method2.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overrides");
                    return currentLevel;
                }
                if (MethodUtils.isOverridden(method2)) {
                    AccessCanBeTightenedInspection.log(member.getName() + " overridden");
                    return currentLevel;
                }
            }
            if (member instanceof PsiEnumConstant) {
                return currentLevel;
            }
            if (member instanceof PsiClass && (member instanceof PsiAnonymousClass || member instanceof PsiTypeParameter || member instanceof PsiSyntheticClass || PsiUtil.isLocalClass((PsiClass)((PsiClass)member)))) {
                return currentLevel;
            }
            if (memberClass != null && (memberClass.isInterface() || memberClass.isEnum() || memberClass.isAnnotationType() || PsiUtil.isLocalClass((PsiClass)memberClass) && member instanceof PsiClass)) {
                return currentLevel;
            }
            PsiFile memberFile = member.getContainingFile();
            Project project2 = memberFile.getProject();
            int minLevel = 1;
            boolean entryPoint = this.myDeadCodeInspection.isEntryPoint((PsiElement)member);
            if (entryPoint) {
                int level = AccessCanBeTightenedInspection.this.myVisibilityInspection.getMinVisibilityLevel(member);
                if (level <= 0) {
                    AccessCanBeTightenedInspection.log(member.getName() + " is entry point");
                    return currentLevel;
                }
                minLevel = level;
            }
            PsiPackage memberPackage = (memberDirectory = memberFile.getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(memberDirectory);
            AccessCanBeTightenedInspection.log(member.getName() + ": checking effective level for " + member);
            AtomicInteger maxLevel = new AtomicInteger(minLevel);
            AtomicBoolean foundUsage = new AtomicBoolean();
            boolean proceed = UnusedSymbolUtil.processUsages(project2, memberFile, member, (ProgressIndicator)new EmptyProgressIndicator(), null, (Processor<UsageInfo>)((Processor)info -> {
                PsiElement element = info.getElement();
                if (element == null) {
                    return true;
                }
                PsiFile psiFile = info.getFile();
                if (psiFile == null) {
                    return true;
                }
                return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, element, psiFile, foundUsage);
            }));
            if (proceed && member instanceof PsiClass && LambdaUtil.isFunctionalClass((PsiClass)((PsiClass)member))) {
                FunctionalExpressionSearch.search((PsiClass)((PsiClass)member)).forEach(functionalExpression -> {
                    PsiFile psiFile = functionalExpression.getContainingFile();
                    return this.handleUsage(member, memberClass, memberFile, maxLevel, memberPackage, (PsiElement)functionalExpression, psiFile, foundUsage);
                });
            }
            if (!foundUsage.get() && !entryPoint) {
                AccessCanBeTightenedInspection.log(member.getName() + " unused; ignore");
                return currentLevel;
            }
            int suggestedLevel = maxLevel.get();
            if (suggestedLevel == 1 && memberClass == null) {
                suggestedLevel = AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            String suggestedModifier = PsiUtil.getAccessModifier((int)suggestedLevel);
            AccessCanBeTightenedInspection.log(member.getName() + ": effective level is '" + suggestedModifier + "'");
            return suggestedLevel;
        }

        private boolean handleUsage(@NotNull PsiMember member, @Nullable PsiClass memberClass, @NotNull PsiFile memberFile, @NotNull AtomicInteger maxLevel, @Nullable PsiPackage memberPackage, @NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull AtomicBoolean foundUsage) {
            foundUsage.set(true);
            if (!(psiFile instanceof PsiJavaFile)) {
                AccessCanBeTightenedInspection.log("     refd from " + psiFile.getName() + "; set to public");
                maxLevel.set(4);
                return false;
            }
            int level = this.getEffectiveLevel(element, psiFile, member, memberFile, memberClass, memberPackage);
            AccessCanBeTightenedInspection.log("    ref in file " + psiFile.getName() + "; level = " + PsiUtil.getAccessModifier((int)level) + "; (" + element + ")");
            maxLevel.getAndAccumulate(level, Math::max);
            return level != 4;
        }

        @PsiUtil.AccessLevel
        private int getEffectiveLevel(@NotNull PsiElement element, @NotNull PsiFile file2, @NotNull PsiMember member, @NotNull PsiFile memberFile, PsiClass memberClass, PsiPackage memberPackage) {
            PsiPackage aPackage;
            PsiClass innerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            boolean isAbstractMember = member.hasModifierProperty("abstract");
            if (memberClass != null && PsiTreeUtil.isAncestor((PsiElement)innerClass, (PsiElement)memberClass, (boolean)false) || innerClass != null && PsiTreeUtil.isAncestor((PsiElement)memberClass, (PsiElement)innerClass, (boolean)false) && !innerClass.hasModifierProperty("static")) {
                if (AccessCanBeTightenedInspection.isInReferenceList((PsiElement)innerClass.getModifierList(), member) || AccessCanBeTightenedInspection.isInReferenceList((PsiElement)innerClass.getImplementsList(), member) || AccessCanBeTightenedInspection.isInReferenceList((PsiElement)innerClass.getExtendsList(), member)) {
                    return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
                }
                return !isAbstractMember && (((AccessCanBeTightenedInspection)AccessCanBeTightenedInspection.this).myVisibilityInspection.SUGGEST_PRIVATE_FOR_INNERS || !AccessCanBeTightenedInspection.isInnerClass(memberClass)) ? 1 : AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            PsiDirectory directory = file2.getContainingDirectory();
            PsiPackage psiPackage = aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == memberPackage || aPackage != null && memberPackage != null && Comparing.strEqual((String)aPackage.getQualifiedName(), (String)memberPackage.getQualifiedName())) {
                return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            if (innerClass != null && memberClass != null && innerClass.isInheritor(memberClass, true)) {
                boolean isConstructor;
                PsiExpression qualifier = null;
                if (element instanceof PsiReferenceExpression) {
                    qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
                } else if (element instanceof PsiMethodCallExpression) {
                    qualifier = ((PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression();
                }
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    return 4;
                }
                PsiElement resolved = element instanceof PsiReference ? ((PsiReference)element).resolve() : null;
                boolean bl = isConstructor = resolved instanceof PsiClass && element.getParent() instanceof PsiNewExpression || resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor();
                if (!isConstructor) {
                    return 3;
                }
            }
            return 4;
        }
    }
}

