/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import org.jetbrains.annotations.NotNull;

public class AdjustPackageNameFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix");
    private final String myName;

    public AdjustPackageNameFix(String targetPackage) {
        this.myName = targetPackage;
    }

    @NotNull
    public String getName() {
        return QuickFixBundle.message("adjust.package.text", this.myName);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("adjust.package.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        PsiFile myFile = element.getContainingFile();
        PsiDirectory directory = myFile.getContainingDirectory();
        if (directory == null) {
            return;
        }
        PsiPackage myTargetPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (myTargetPackage == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)myFile.getProject()).getElementFactory();
        PsiPackageStatement myStatement = ((PsiJavaFile)myFile).getPackageStatement();
        if (myTargetPackage.getQualifiedName().length() == 0) {
            if (myStatement != null) {
                myStatement.delete();
            }
        } else {
            PsiPackageStatement packageStatement = factory.createPackageStatement(myTargetPackage.getQualifiedName());
            if (myStatement != null) {
                myStatement.getPackageReference().replace((PsiElement)packageStatement.getPackageReference());
            } else {
                myFile.addAfter((PsiElement)packageStatement, null);
            }
        }
    }
}

