/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CompilerIconLayerProvider
implements IconLayerProvider {
    public Icon getLayerIcon(@NotNull Iconable element, boolean isLocked) {
        VirtualFile vFile = null;
        Project project2 = null;
        if (element instanceof PsiModifierListOwner) {
            project2 = ((PsiModifierListOwner)element).getProject();
            PsiFile containingFile = ((PsiModifierListOwner)element).getContainingFile();
            vFile = containingFile == null ? null : containingFile.getVirtualFile();
        } else if (element instanceof PsiDirectory) {
            project2 = ((PsiDirectory)element).getProject();
            vFile = ((PsiDirectory)element).getVirtualFile();
        }
        if (vFile != null && CompilerIconLayerProvider.isExcluded(vFile, project2)) {
            return PlatformIcons.EXCLUDED_FROM_COMPILE_ICON;
        }
        return null;
    }

    @NotNull
    public String getLayerDescription() {
        return CodeInsightBundle.message((String)"node.excluded.flag.tooltip", (Object[])new Object[0]);
    }

    public static boolean isExcluded(VirtualFile vFile, Project project2) {
        return vFile != null && ((FileIndexFacade)ServiceManager.getService((Project)project2, FileIndexFacade.class)).isInSource(vFile) && CompilerConfiguration.getInstance((Project)project2).isExcludedFromCompilation(vFile);
    }
}

