/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import org.jetbrains.annotations.NotNull;

public class CompileProjectAction
extends CompileActionBase {
    @Override
    protected void doAction(DataContext dataContext, final Project project2) {
        ProjectTaskManager.getInstance((Project)project2).rebuildAllModules(new ProjectTaskNotification(){

            public void finished(@NotNull ProjectTaskResult executionResult) {
                if (executionResult.isAborted() || project2.isDisposed()) {
                    return;
                }
                String text = CompileProjectAction.this.getTemplatePresentation().getText();
                LocalHistory.getInstance().putSystemLabel(project2, CompilerBundle.message((String)(executionResult.getErrors() == 0 ? "rebuild.lvcs.label.no.errors" : "rebuild.lvcs.label.with.errors"), (Object[])new Object[]{text}));
            }
        });
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        presentation.setEnabled(e.getProject() != null);
    }
}

