/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.CompilerExcludes;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.taskdefs.DirSet;
import com.intellij.compiler.ant.taskdefs.Exclude;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.compiler.ant.taskdefs.PatternSetRef;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ModuleChunkSourcePath
extends CompositeGenerator {
    private final VirtualFile[] mySourceRoots;
    private final VirtualFile[] myTestSourceRoots;

    public ModuleChunkSourcePath(Project project2, ModuleChunk chunk, GenerationOptions genOptions) {
        Path sourcePath = new Path(BuildProperties.getSourcepathProperty((String)chunk.getName()));
        Path testSourcePath = new Path(BuildProperties.getTestSourcepathProperty((String)chunk.getName()));
        PatternSet excludedFromCompilation = new PatternSet(BuildProperties.getExcludedFromCompilationProperty((String)chunk.getName()));
        String moduleChunkBasedirProperty = BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)chunk);
        Module[] modules = chunk.getModules();
        if (CompilerExcludes.isAvailable(project2)) {
            excludedFromCompilation.add((Generator)new PatternSetRef("compiler.excluded"));
        }
        ArrayList<VirtualFile> sourceRootFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> testSourceRootFiles = new ArrayList<VirtualFile>();
        for (Module module2 : modules) {
            ContentEntry[] contentEntries;
            String moduleName = module2.getName();
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
            ModuleFileIndex moduleFileIndex = rootManager.getFileIndex();
            PatternSet excludedFromModule = new PatternSet(BuildProperties.getExcludedFromModuleProperty((String)moduleName));
            excludedFromModule.add((Generator)new PatternSetRef("ignored.files"));
            for (ContentEntry contentEntry : contentEntries = rootManager.getContentEntries()) {
                VirtualFile[] sourceRoots;
                VirtualFile file2 = contentEntry.getFile();
                if (file2 == null || !file2.isInLocalFileSystem()) continue;
                VirtualFile dirSetRoot = this.getDirSetRoot(contentEntry);
                String dirSetRootRelativeToBasedir = GenerationUtils.toRelativePath((VirtualFile)dirSetRoot, (File)chunk.getBaseDir(), (String)moduleChunkBasedirProperty, (GenerationOptions)genOptions);
                DirSet sourcesDirSet = new DirSet(dirSetRootRelativeToBasedir);
                DirSet testSourcesDirSet = new DirSet(dirSetRootRelativeToBasedir);
                for (VirtualFile root : sourceRoots = contentEntry.getSourceFolderFiles()) {
                    if (!moduleFileIndex.isInContent(root)) continue;
                    ModuleChunkSourcePath.addExcludePatterns(module2, root, root, (CompositeGenerator)excludedFromModule, true);
                    Include include = new Include(VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)dirSetRoot, (char)'/'));
                    if (moduleFileIndex.isInTestSourceContent(root)) {
                        testSourcesDirSet.add((Generator)include);
                        testSourceRootFiles.add(root);
                        continue;
                    }
                    sourcesDirSet.add((Generator)include);
                    sourceRootFiles.add(root);
                }
                if (sourcesDirSet.getGeneratorCount() > 0) {
                    sourcePath.add((Generator)sourcesDirSet);
                }
                if (testSourcesDirSet.getGeneratorCount() <= 0) continue;
                testSourcePath.add((Generator)testSourcesDirSet);
            }
            if (excludedFromModule.getGeneratorCount() <= 0) continue;
            this.add((Generator)excludedFromModule);
            excludedFromCompilation.add((Generator)new PatternSetRef(BuildProperties.getExcludedFromModuleProperty((String)moduleName)));
        }
        this.mySourceRoots = VfsUtilCore.toVirtualFileArray(sourceRootFiles);
        this.myTestSourceRoots = VfsUtilCore.toVirtualFileArray(testSourceRootFiles);
        if (excludedFromCompilation.getGeneratorCount() > 0) {
            this.add((Generator)excludedFromCompilation, 1);
        }
        if (sourcePath.getGeneratorCount() > 0) {
            this.add((Generator)sourcePath, 1);
        }
        if (testSourcePath.getGeneratorCount() != 0) {
            this.add((Generator)testSourcePath, 1);
        }
    }

    public VirtualFile[] getSourceRoots() {
        return this.mySourceRoots;
    }

    public VirtualFile[] getTestSourceRoots() {
        return this.myTestSourceRoots;
    }

    private VirtualFile getDirSetRoot(ContentEntry contentEntry) {
        VirtualFile[] sourceFolderFiles;
        VirtualFile contentRoot = contentEntry.getFile();
        for (VirtualFile sourceFolderFile : sourceFolderFiles = contentEntry.getSourceFolderFiles()) {
            if (!contentRoot.equals(sourceFolderFile)) continue;
            return contentRoot.getParent();
        }
        return contentRoot;
    }

    private static void addExcludePatterns(Module module2, final VirtualFile root, VirtualFile dir, final CompositeGenerator generator, final boolean parentIncluded) {
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        final ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile dir) {
                if (!dir.isDirectory() || fileTypeManager.isFileIgnored(dir)) {
                    return false;
                }
                boolean isIncluded = moduleRootManager.getFileIndex().isInContent(dir);
                if (isIncluded != parentIncluded) {
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)root, (char)'/');
                    if (isIncluded) {
                        generator.add((Generator)new Include(relativePath + "/**"));
                    } else if (!ModuleChunkSourcePath.isExcludedByDefault(dir.getName())) {
                        generator.add((Generator)new Exclude(relativePath + "/**"));
                    }
                }
                return true;
            }
        });
    }

    private static boolean isExcludedByDefault(String name) {
        return "CVS".equals(name) || "SCCS".equals(name) || ".DS_Store".equals(name);
    }
}

