/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceImpl;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.Queue;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.index.CompilerIndices;

class CompilerReferenceReader {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceReader.class);
    private final CompilerBackwardReferenceIndex myIndex;
    private final File myBuildDir;

    private CompilerReferenceReader(File buildDir) {
        this.myIndex = new CompilerBackwardReferenceIndex(buildDir, true);
        this.myBuildDir = buildDir;
    }

    @Nullable
    TIntHashSet findReferentFileIds(@NotNull LightRef ref, boolean checkBaseClassAmbiguity) throws StorageException {
        LightRef.LightClassHierarchyElementDef hierarchyElement = ref instanceof LightRef.LightClassHierarchyElementDef ? (LightRef.LightClassHierarchyElementDef)ref : ((LightRef.LightMember)ref).getOwner();
        TIntHashSet set2 = new TIntHashSet();
        LightRef.NamedLightRef[] hierarchy = this.getWholeHierarchy(hierarchyElement, checkBaseClassAmbiguity);
        if (hierarchy == null) {
            return null;
        }
        for (LightRef.NamedLightRef aClass : hierarchy) {
            LightRef overriderUsage = ref.override(aClass.getName());
            this.addUsages(overriderUsage, set2);
        }
        return set2;
    }

    @NotNull
    Map<VirtualFile, Object[]> getDirectInheritors(@NotNull LightRef searchElement, @NotNull GlobalSearchScope searchScope, @NotNull GlobalSearchScope dirtyScope, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType searchType) throws StorageException {
        GlobalSearchScope effectiveSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)dirtyScope).intersectWith(searchScope);
        LanguageLightRefAdapter adapter = CompilerReferenceServiceImpl.findAdapterForFileType(fileType);
        LOG.assertTrue(adapter != null, (Object)("adapter is null for file type: " + fileType));
        Class<? extends LightRef> requiredLightRefClass = searchType.getRequiredClass(adapter);
        HashMap candidatesPerFile = new HashMap();
        this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)searchElement).forEach((fileId, defs) -> {
            List<LightRef> requiredCandidates = defs.stream().filter(requiredLightRefClass::isInstance).collect(Collectors.toList());
            if (requiredCandidates.isEmpty()) {
                return true;
            }
            VirtualFile file2 = this.findFile(fileId);
            if (file2 != null && effectiveSearchScope.contains(file2)) {
                candidatesPerFile.put(file2, searchType.convertToIds(requiredCandidates, this.myIndex.getByteSeqEum()));
            }
            return true;
        });
        return candidatesPerFile.isEmpty() ? Collections.emptyMap() : candidatesPerFile;
    }

    @NotNull
    NameEnumerator getNameEnumerator() {
        return this.myIndex.getByteSeqEum();
    }

    void close(boolean removeIndex) {
        this.myIndex.close();
        if (removeIndex) {
            CompilerBackwardReferenceIndex.removeIndexFiles((File)this.myBuildDir);
        }
    }

    static boolean exists(Project project2) {
        File buildDir = BuildManager.getInstance().getProjectSystemDirectory(project2);
        if (buildDir == null || CompilerBackwardReferenceIndex.versionDiffers((File)buildDir)) {
            return false;
        }
        return CompilerBackwardReferenceIndex.exist((File)buildDir);
    }

    static CompilerReferenceReader create(Project project2) {
        if (!CompilerReferenceReader.exists(project2)) {
            return null;
        }
        try {
            return new CompilerReferenceReader(BuildManager.getInstance().getProjectSystemDirectory(project2));
        }
        catch (RuntimeException e) {
            LOG.error("An exception while initialization of compiler reference index.", (Throwable)e);
            return null;
        }
    }

    private void addUsages(LightRef usage, final TIntHashSet sink) throws StorageException {
        this.myIndex.get(CompilerIndices.BACK_USAGES).getData((Object)usage).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

            public boolean perform(int id, Void value2) {
                VirtualFile file2 = CompilerReferenceReader.this.findFile(id);
                if (file2 != null) {
                    sink.add(((VirtualFileWithId)file2).getId());
                }
                return true;
            }
        });
    }

    private VirtualFile findFile(int id) {
        try {
            String path = this.myIndex.getFilePathEnumerator().valueOf(id);
            assert (path != null);
            return VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable(value="return null if the class hierarchy contains ambiguous qualified names")
    private LightRef.NamedLightRef[] getWholeHierarchy(LightRef.LightClassHierarchyElementDef hierarchyElement, boolean checkBaseClassAmbiguity) throws StorageException {
        THashSet result2 = new THashSet();
        Queue q = new Queue(10);
        q.addLast((Object)hierarchyElement);
        while (!q.isEmpty()) {
            LightRef.NamedLightRef curClass = (LightRef.NamedLightRef)q.pullFirst();
            if (!result2.add(curClass)) continue;
            if (checkBaseClassAmbiguity || curClass != hierarchyElement) {
                DefCount count = this.getDefinitionCount((LightRef)curClass);
                if (count == DefCount.NONE) {
                    String baseHierarchyElement = this.getNameEnumerator().getName(hierarchyElement.getName());
                    String curHierarchyElement = this.getNameEnumerator().getName(curClass.getName());
                    LOG.error("Can't get definition files for: " + curHierarchyElement + " base class: " + baseHierarchyElement);
                }
                if (count != DefCount.ONE) {
                    return null;
                }
            }
            this.myIndex.get(CompilerIndices.BACK_HIERARCHY).getData((Object)curClass).forEach((id, children2) -> {
                for (LightRef child : children2) {
                    if (!(child instanceof LightRef.LightClassHierarchyElementDef)) continue;
                    q.addLast((Object)((LightRef.LightClassHierarchyElementDef)child));
                }
                return true;
            });
        }
        return result2.toArray(new LightRef.NamedLightRef[result2.size()]);
    }

    @NotNull
    private DefCount getDefinitionCount(LightRef def) throws StorageException {
        final DefCount[] result2 = new DefCount[]{DefCount.NONE};
        this.myIndex.get(CompilerIndices.BACK_CLASS_DEF).getData((Object)def).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

            public boolean perform(int id, Void value2) {
                if (result2[0] == DefCount.NONE) {
                    result2[0] = DefCount.ONE;
                    return true;
                }
                if (result2[0] == DefCount.ONE) {
                    result2[0] = DefCount.MANY;
                    return true;
                }
                return false;
            }
        });
        return result2[0];
    }

    private static enum DefCount {
        NONE,
        ONE,
        MANY;

    }
}

