/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceImpl;
import com.intellij.compiler.backwardRefs.ExcludedFromCompileFilesUtil;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DirtyScopeHolder
extends UserDataHolderBase {
    private final CompilerReferenceServiceImpl myService;
    private final FileDocumentManager myFileDocManager;
    private final PsiDocumentManager myPsiDocManager;
    private final Object myLock = new Object();
    private final Set<Module> myVFSChangedModules = ContainerUtil.newHashSet();
    private final Set<Module> myChangedModulesDuringCompilation = ContainerUtil.newHashSet();
    private final List<ExcludeEntryDescription> myExcludedDescriptions = new SmartList();
    private boolean myCompilationPhase;
    private volatile GlobalSearchScope myExcludedFilesScope;
    private final Set<String> myCompilationAffectedModules = ContainerUtil.newConcurrentSet();

    public DirtyScopeHolder(@NotNull CompilerReferenceServiceImpl service, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager) {
        this.myService = service;
        this.myFileDocManager = fileDocumentManager;
        this.myPsiDocManager = psiDocumentManager;
        if (CompilerReferenceService.isEnabled()) {
            MessageBusConnection connect = service.getProject().getMessageBus().connect();
            connect.subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        if (DirtyScopeHolder.this.myCompilationPhase) {
                            DirtyScopeHolder.this.myExcludedDescriptions.add(description);
                        }
                    }
                }
            });
            connect.subscribe(CustomBuilderMessageHandler.TOPIC, (builderId, messageType, messageText) -> {
                if ("compiler.ref.index".equals(builderId)) {
                    this.myCompilationAffectedModules.add(messageText);
                }
            });
            connect.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void beforeRootsChange(ModuleRootEvent event) {
                    Object[] modules = ModuleManager.getInstance((Project)DirtyScopeHolder.this.myService.getProject()).getModules();
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        ContainerUtil.addAll((Collection)DirtyScopeHolder.this.myVFSChangedModules, (Object[])modules);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compilerActivityStarted() {
        ExcludeEntryDescription[] excludeEntryDescriptions = CompilerConfiguration.getInstance((Project)this.myService.getProject()).getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = true;
            Collections.addAll(this.myExcludedDescriptions, excludeEntryDescriptions);
            this.myExcludedFilesScope = null;
            this.myCompilationAffectedModules.clear();
        }
    }

    void upToDateChecked(boolean isUpToDate) {
        Module[] modules = (Module[])ReadAction.compute(() -> {
            Project project2 = this.myService.getProject();
            if (project2.isDisposed()) {
                return null;
            }
            return ModuleManager.getInstance((Project)project2).getModules();
        });
        if (modules == null) {
            return;
        }
        this.compilationFinished(() -> {
            if (!isUpToDate) {
                ContainerUtil.addAll(this.myVFSChangedModules, (Object[])modules);
            }
        });
    }

    void compilerActivityFinished() {
        List compiledModules = (List)ReadAction.compute(() -> {
            Project project2 = this.myService.getProject();
            if (project2.isDisposed()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myService.getProject());
            return this.myCompilationAffectedModules.stream().map(arg_0 -> ((ModuleManager)moduleManager).findModuleByName(arg_0)).collect(Collectors.toList());
        });
        this.compilationFinished(() -> {
            if (compiledModules == null) {
                return;
            }
            this.myVFSChangedModules.removeAll(compiledModules);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compilationFinished(Runnable action) {
        ExcludeEntryDescription[] descriptions;
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = false;
            action.run();
            this.myVFSChangedModules.addAll(this.myChangedModulesDuringCompilation);
            this.myChangedModulesDuringCompilation.clear();
            descriptions = this.myExcludedDescriptions.toArray(new ExcludeEntryDescription[this.myExcludedDescriptions.size()]);
            this.myExcludedDescriptions.clear();
        }
        this.myCompilationAffectedModules.clear();
        this.myExcludedFilesScope = ExcludedFromCompileFilesUtil.getExcludedFilesScope(descriptions, this.myService.getFileTypes(), this.myService.getProject(), this.myService.getFileIndex());
    }

    GlobalSearchScope getDirtyScope() {
        Project project2 = this.myService.getProject();
        return (GlobalSearchScope)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCompilationPhase) {
                    return GlobalSearchScope.allScope((Project)project2);
                }
                if (project2.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (GlobalSearchScope)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.calculateDirtyScope(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.getInstance(), this.myService}));
            }
        });
    }

    private GlobalSearchScope calculateDirtyScope() {
        Set<Module> dirtyModules = this.getAllDirtyModules();
        if (dirtyModules.isEmpty()) {
            return this.myExcludedFilesScope;
        }
        GlobalSearchScope dirtyModuleScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])dirtyModules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
        return dirtyModuleScope.union((SearchScope)this.myExcludedFilesScope);
    }

    @NotNull
    Set<Module> getAllDirtyModules() {
        THashSet dirtyModules = new THashSet(this.myVFSChangedModules);
        for (Document document : this.myFileDocManager.getUnsavedDocuments()) {
            Module m;
            VirtualFile file2 = this.myFileDocManager.getFile(document);
            if (file2 == null || (m = this.getModuleForSourceContentFile(file2)) == null) continue;
            dirtyModules.add(m);
        }
        for (Document document : this.myPsiDocManager.getUncommittedDocuments()) {
            Module m;
            VirtualFile file3;
            PsiFile psiFile = this.myPsiDocManager.getPsiFile(document);
            if (psiFile == null || (file3 = psiFile.getVirtualFile()) == null || (m = this.getModuleForSourceContentFile(file3)) == null) continue;
            dirtyModules.add(m);
        }
        return dirtyModules;
    }

    boolean contains(VirtualFile file2) {
        return this.getDirtyScope().contains(file2);
    }

    void installVFSListener() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                this.processChange(event.getFile());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                this.processChange(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                this.processChange(event.getFile());
            }

            public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
                if ("name".equals(event.getPropertyName()) && event.getFile().isDirectory() && event.getFile().isInLocalFileSystem()) {
                    String path = event.getFile().getPath();
                    for (Module module2 : ModuleManager.getInstance((Project)DirtyScopeHolder.this.myService.getProject()).getModules()) {
                        if (!FileUtil.isAncestor((String)path, (String)module2.getModuleFilePath(), (boolean)true)) continue;
                        this.addToDirtyModules(module2);
                    }
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if ("name".equals(event.getPropertyName()) || "symlink".equals(event.getPropertyName())) {
                    this.processChange(event.getFile());
                }
            }

            public void beforeContentsChange(@NotNull VirtualFileEvent event) {
                this.processChange(event.getFile());
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                this.processChange(event.getFile());
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                this.processChange(event.getFile());
            }

            private void processChange(VirtualFile file2) {
                this.fileChanged(file2);
            }

            private void fileChanged(VirtualFile file2) {
                Module module2 = DirtyScopeHolder.this.getModuleForSourceContentFile(file2);
                if (module2 != null) {
                    this.addToDirtyModules(module2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addToDirtyModules(Module module2) {
                Object object = DirtyScopeHolder.this.myLock;
                synchronized (object) {
                    if (DirtyScopeHolder.this.myCompilationPhase) {
                        DirtyScopeHolder.this.myChangedModulesDuringCompilation.add(module2);
                    } else {
                        DirtyScopeHolder.this.myVFSChangedModules.add(module2);
                    }
                }
            }
        }, (Disposable)this.myService.getProject());
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile file2) {
        if (this.myService.getFileIndex().isInSourceContent(file2) && this.myService.getFileTypes().contains(file2.getFileType())) {
            return this.myService.getFileIndex().getModuleForFile(file2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<Module> getAllDirtyModulesForTest() {
        Object object = this.myLock;
        synchronized (object) {
            return this.getAllDirtyModules();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DirtyScopeTestInfo getState() {
        Object object = this.myLock;
        synchronized (object) {
            Object[] vfsChangedModules = this.myVFSChangedModules.toArray(Module.EMPTY_ARRAY);
            ArrayList<Module> unsavedChangedModuleList = new ArrayList<Module>(this.getAllDirtyModules());
            ContainerUtil.removeAll(unsavedChangedModuleList, (Object[])vfsChangedModules);
            Module[] unsavedChangedModules = unsavedChangedModuleList.toArray(Module.EMPTY_ARRAY);
            ArrayList excludedFiles = this.myExcludedFilesScope instanceof Iterable ? ContainerUtil.newArrayList((Iterable)((Iterable)this.myExcludedFilesScope)) : Collections.emptyList();
            return new DirtyScopeTestInfo((Module[])vfsChangedModules, unsavedChangedModules, excludedFiles.toArray(VirtualFile.EMPTY_ARRAY), this.getDirtyScope());
        }
    }
}

