/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaCompilerElementRetriever {
    private static final Logger LOG = Logger.getInstance(JavaCompilerElementRetriever.class);
    private static final TokenSet FUN_EXPR = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LAMBDA_EXPRESSION, JavaElementType.METHOD_REF_EXPRESSION});

    @NotNull
    static PsiFunctionalExpression[] retrieveFunExpressionsByIndices(@NotNull TIntHashSet indices2, @NotNull PsiFileWithStubSupport psiFile) {
        boolean foreign;
        StubTree tree = psiFile.getStubTree();
        boolean bl = foreign = tree == null;
        if (foreign) {
            tree = ((PsiFileImpl)psiFile).calcStubTree();
        }
        Object[] result2 = new PsiFunctionalExpression[indices2.size()];
        int resIdx = 0;
        int funExprIdx = 0;
        for (StubElement element : tree.getPlainList()) {
            if (!FUN_EXPR.contains((IElementType)element.getStubType()) || !indices2.contains(funExprIdx++)) continue;
            result2[resIdx++] = (PsiFunctionalExpression)element.getPsi();
        }
        if (result2.length != resIdx) {
            CompilerReferenceServiceImpl compilerReferenceService = (CompilerReferenceServiceImpl)CompilerReferenceService.getInstance(psiFile.getProject());
            Set<Module> state = compilerReferenceService.getDirtyScopeHolder().getAllDirtyModules();
            VirtualFile file2 = psiFile.getVirtualFile();
            Module moduleForFile = ProjectFileIndex.getInstance((Project)psiFile.getProject()).getModuleForFile(file2);
            LOG.error("Compiler functional expression index doesn't match to stub index.\nFunctional expression indices: " + indices2 + "\nDoes the file belong to dirty scope?: " + state.contains(moduleForFile), new Attachment[]{new Attachment(psiFile.getName(), psiFile.getText())});
            return ContainerUtil.filter((Object[])result2, Objects::nonNull).toArray(PsiFunctionalExpression.EMPTY_ARRAY);
        }
        return result2;
    }

    @NotNull
    static PsiClass[] retrieveClassesByInternalNames(@NotNull String[] internalNames, @NotNull PsiNamedElement baseClass, @NotNull PsiFileWithStubSupport psiFile) {
        Collection<InternalClassMatcher> matchers = JavaCompilerElementRetriever.createClassMatcher(internalNames, baseClass);
        return (PsiClass[])ReadAction.compute(() -> JavaCompilerElementRetriever.retrieveMatchedClasses(psiFile, matchers).toArray(PsiClass.EMPTY_ARRAY));
    }

    private static List<PsiClass> retrieveMatchedClasses(PsiFileWithStubSupport psiFile, Collection<InternalClassMatcher> matchers) {
        boolean foreign;
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(matchers.size());
        StubTree tree = psiFile.getStubTree();
        boolean bl = foreign = tree == null;
        if (foreign) {
            tree = ((PsiFileImpl)psiFile).calcStubTree();
        }
        for (StubElement element : tree.getPlainList()) {
            if (!(element instanceof PsiClassStub) || !JavaCompilerElementRetriever.match((PsiClassStub)element, matchers)) continue;
            result2.add((PsiClass)((StubBase)element).getPsi());
        }
        return result2;
    }

    private static boolean match(PsiClassStub stub, Collection<InternalClassMatcher> matchers) {
        for (InternalClassMatcher matcher : matchers) {
            if (!matcher.matches(stub)) continue;
            if (matcher instanceof InternalClassMatcher.ByQualifiedName) {
                matchers.remove(matcher);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Collection<InternalClassMatcher> createClassMatcher(@NotNull String[] internalNames, @NotNull PsiNamedElement baseClass) {
        boolean matcherBySuperNameAdded = false;
        ArrayList<InternalClassMatcher> matchers = new ArrayList<InternalClassMatcher>(internalNames.length);
        String[] stringArray = internalNames;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String internalName = stringArray[n2];
            int curLast = internalName.length() - 1;
            while (true) {
                int lastIndex;
                if ((lastIndex = internalName.lastIndexOf(36, curLast)) > -1 && lastIndex < internalName.length() - 1) {
                    int followingIndex = lastIndex + 1;
                    boolean digit = Character.isDigit(internalName.charAt(followingIndex));
                    if (digit) {
                        if (curLast == internalName.length() - 1) {
                            int nextNonDigit = JavaCompilerElementRetriever.getNextNonDigitIndex(internalName, followingIndex);
                            if (nextNonDigit == -1) {
                                if (matcherBySuperNameAdded) break;
                                matcherBySuperNameAdded = true;
                                matchers.add(new InternalClassMatcher.BySuperName((String)ReadAction.compute(() -> baseClass.getName())));
                                break;
                            }
                            matchers.add(new InternalClassMatcher.ByName(internalName.substring(nextNonDigit)));
                        } else {
                            matchers.add(new InternalClassMatcher.ByName(StringUtil.getShortName((String)internalName, (char)'$')));
                            break;
                        }
                    }
                } else {
                    matchers.add(new InternalClassMatcher.ByQualifiedName(StringUtil.replace((String)internalName, (String)"$", (String)".")));
                    break;
                }
                curLast = lastIndex - 1;
            }
            ++n2;
        }
        return matchers;
    }

    private static int getNextNonDigitIndex(String name, int digitIndex) {
        for (int i2 = digitIndex + 1; i2 < name.length(); ++i2) {
            if (Character.isDigit(name.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    private static interface InternalClassMatcher {
        public boolean matches(PsiClassStub var1);

        public static class ByQualifiedName
        implements InternalClassMatcher {
            private final String myQName;

            public ByQualifiedName(String name) {
                this.myQName = name;
            }

            @Override
            public boolean matches(PsiClassStub stub) {
                return this.myQName.equals(stub.getQualifiedName());
            }
        }

        public static class ByName
        implements InternalClassMatcher {
            private final String myName;

            public ByName(String name) {
                this.myName = name;
            }

            @Override
            public boolean matches(PsiClassStub stub) {
                return this.myName.equals(stub.getName());
            }
        }

        public static class BySuperName
        implements InternalClassMatcher {
            private final String mySuperName;

            public BySuperName(String name) {
                this.mySuperName = name;
            }

            @Override
            public boolean matches(PsiClassStub stub) {
                return stub.isAnonymous() && this.mySuperName.equals(PsiNameHelper.getShortClassName((String)stub.getBaseClassReferenceText()));
            }
        }
    }
}

