/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntHashSet;
import java.util.stream.IntStream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerReferenceFindUsagesTestInfo {
    @Nullable
    private final TIntHashSet myFileIds;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;
    @NotNull
    private final Project myProject;

    public CompilerReferenceFindUsagesTestInfo(@Nullable TIntHashSet occurrencesIds, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo, @NotNull Project project2) {
        this.myFileIds = occurrencesIds;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
        this.myProject = project2;
    }

    @NotNull
    VirtualFile[] getFilesWithKnownOccurrences() {
        if (this.myFileIds == null) {
            throw new IllegalStateException();
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        return (VirtualFile[])IntStream.of(this.myFileIds.toArray()).mapToObj(id -> fileBasedIndex.findFileById(this.myProject, id)).filter(f -> !this.myDirtyScopeInfo.getDirtyScope().contains(f)).toArray(VirtualFile[]::new);
    }

    @NotNull
    Module[] getDirtyModules() {
        return this.myDirtyScopeInfo.getDirtyModules();
    }

    @NotNull
    Module[] getDirtyUnsavedModules() {
        return this.myDirtyScopeInfo.getDirtyUnsavedModules();
    }

    @NotNull
    VirtualFile[] getExcludedFiles() {
        return this.myDirtyScopeInfo.getExcludedFiles();
    }

    boolean isEnabled() {
        return this.myFileIds != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known occurrence files");
            node.add(knownOccurrences);
            for (VirtualFile file2 : this.getFilesWithKnownOccurrences()) {
                knownOccurrences.add(new DefaultMutableTreeNode(file2));
            }
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module2 : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module2));
            }
            DefaultMutableTreeNode unsavedDirtyModules = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(unsavedDirtyModules);
            for (Module module3 : this.getDirtyUnsavedModules()) {
                unsavedDirtyModules.add(new DefaultMutableTreeNode(module3));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }
}

