/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.compiler.classFilesIndex.chainsSearch.MaxSizeTreeSet;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodsChain;
import com.intellij.compiler.classFilesIndex.chainsSearch.ParametersMatcher;
import com.intellij.compiler.classFilesIndex.chainsSearch.SearchInitializer;
import com.intellij.compiler.classFilesIndex.chainsSearch.WeightAware;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.TargetType;
import com.intellij.compiler.classFilesIndex.impl.MethodIncompleteSignature;
import com.intellij.compiler.classFilesIndex.impl.MethodsUsageIndexReader;
import com.intellij.compiler.classFilesIndex.impl.UsageIndexValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChainsSearcher {
    private static final Logger LOG = Logger.getInstance(ChainsSearcher.class);
    private static final double NEXT_METHOD_IN_CHAIN_RATIO = 1.5;

    private ChainsSearcher() {
    }

    @NotNull
    public static List<MethodsChain> search(int pathMaximalLength, TargetType targetType, Set<String> contextQNames, int maxResultSize, ChainCompletionContext context, MethodsUsageIndexReader methodsUsageIndexReader) {
        SearchInitializer initializer = ChainsSearcher.createInitializer(targetType, context.getExcludedQNames(), methodsUsageIndexReader, context);
        if (initializer == null) {
            return Collections.emptyList();
        }
        return ChainsSearcher.search(methodsUsageIndexReader, initializer, contextQNames, pathMaximalLength, maxResultSize, targetType.getClassQName(), context);
    }

    @Nullable
    private static SearchInitializer createInitializer(TargetType target, Set<String> excludedParamsTypesQNames, MethodsUsageIndexReader methodsUsageIndexReader, ChainCompletionContext context) {
        TreeSet<UsageIndexValue> methods = methodsUsageIndexReader.getMethods(target.getClassQName());
        return new SearchInitializer(methods, target.getClassQName(), excludedParamsTypesQNames, context);
    }

    @NotNull
    private static List<MethodsChain> search(MethodsUsageIndexReader indexReader, SearchInitializer initializer, Set<String> toSet, int pathMaximalLength, int maxResultSize, String targetQName, ChainCompletionContext context) {
        HashSet<String> allExcludedNames = MethodChainsSearchUtil.joinToHashSet(context.getExcludedQNames(), targetQName);
        SearchInitializer.InitResult initResult = initializer.init(Collections.emptySet());
        LinkedHashMap<MethodIncompleteSignature, MethodsChain> knownDistance = initResult.getChains();
        List<WeightAware<MethodIncompleteSignature>> allInitialVertexes = initResult.getVertexes();
        LinkedList<WeightAware<Pair>> q = new LinkedList<WeightAware<Pair>>(ContainerUtil.map(allInitialVertexes, methodIncompleteSignatureWeightAware -> {
            MethodIncompleteSignature underlying = (MethodIncompleteSignature)methodIncompleteSignatureWeightAware.getUnderlying();
            return new WeightAware<Pair>(Pair.create((Object)underlying, (Object)new MethodsChain(context.resolveNotDeprecated(underlying), methodIncompleteSignatureWeightAware.getWeight(), underlying.getOwner())), methodIncompleteSignatureWeightAware.getWeight());
        }));
        int maxWeight = 0;
        for (MethodsChain methodsChain : knownDistance.values()) {
            if (methodsChain.getChainWeight() <= maxWeight) continue;
            maxWeight = methodsChain.getChainWeight();
        }
        ResultHolder result2 = new ResultHolder(context.getPsiManager());
        while (!q.isEmpty()) {
            Pair currentVertexUnderlying;
            MethodsChain currentVertexMethodsChain;
            ProgressManager.checkCanceled();
            WeightAware currentVertex = (WeightAware)q.poll();
            int currentVertexDistance = currentVertex.getWeight();
            if (currentVertexDistance != (currentVertexMethodsChain = (MethodsChain)knownDistance.get((currentVertexUnderlying = (Pair)currentVertex.getUnderlying()).getFirst())).getChainWeight()) continue;
            if (((MethodIncompleteSignature)((Pair)currentVertex.getUnderlying()).getFirst()).isStatic() || toSet.contains(((MethodIncompleteSignature)((Pair)currentVertex.getUnderlying()).getFirst()).getOwner())) {
                result2.add((MethodsChain)((Pair)currentVertex.getUnderlying()).getSecond());
                continue;
            }
            String currentReturnType = ((MethodIncompleteSignature)currentVertexUnderlying.getFirst()).getOwner();
            TreeSet<UsageIndexValue> nextMethods = indexReader.getMethods(currentReturnType);
            MaxSizeTreeSet<WeightAware<MethodIncompleteSignature>> currentSignatures = new MaxSizeTreeSet<WeightAware<MethodIncompleteSignature>>(maxResultSize);
            for (UsageIndexValue indexValue : nextMethods) {
                MethodIncompleteSignature methodInvocation;
                PsiMethod[] psiMethods;
                MethodIncompleteSignature vertex = indexValue.getMethodIncompleteSignature();
                int n = indexValue.getOccurrences();
                if (!vertex.isStatic() && vertex.getOwner().equals(targetQName)) continue;
                int vertexDistance = Math.min(currentVertexDistance, n);
                MethodsChain knownVertexMethodsChain = (MethodsChain)knownDistance.get(vertex);
                if (knownVertexMethodsChain != null && knownVertexMethodsChain.getChainWeight() >= vertexDistance) break;
                if (!currentSignatures.isEmpty() && ((WeightAware)currentSignatures.last()).getWeight() >= vertexDistance || currentVertexMethodsChain.size() >= pathMaximalLength - 1 || (psiMethods = context.resolveNotDeprecated(methodInvocation = indexValue.getMethodIncompleteSignature())).length == 0 || !MethodChainsSearchUtil.checkParametersForTypesQNames(psiMethods, allExcludedNames)) continue;
                MethodsChain newBestMethodsChain = currentVertexMethodsChain.addEdge(psiMethods, indexValue.getMethodIncompleteSignature().getOwner(), vertexDistance);
                currentSignatures.add(new WeightAware<MethodIncompleteSignature>(indexValue.getMethodIncompleteSignature(), vertexDistance));
                knownDistance.put(vertex, newBestMethodsChain);
            }
            boolean updated = false;
            if (!currentSignatures.isEmpty()) {
                boolean isBreak = false;
                for (WeightAware weightAware : currentSignatures) {
                    PsiMethod[] resolved = context.resolveNotDeprecated((MethodIncompleteSignature)weightAware.getUnderlying());
                    if (!isBreak && (double)weightAware.getWeight() * 1.5 > (double)currentVertex.getWeight()) {
                        boolean stopChain;
                        boolean bl = stopChain = ((MethodIncompleteSignature)weightAware.getUnderlying()).isStatic() || toSet.contains(((MethodIncompleteSignature)weightAware.getUnderlying()).getOwner());
                        if (stopChain) {
                            updated = true;
                            result2.add(((MethodsChain)((Pair)currentVertex.getUnderlying()).getSecond()).addEdge(resolved, ((MethodIncompleteSignature)weightAware.getUnderlying()).getOwner(), weightAware.getWeight()));
                            continue;
                        }
                        updated = true;
                        MethodsChain methodsChain = ((MethodsChain)currentVertexUnderlying.second).addEdge(resolved, ((MethodIncompleteSignature)weightAware.getUnderlying()).getOwner(), weightAware.getWeight());
                        q.add(new WeightAware<Pair>(Pair.create(weightAware.getUnderlying(), (Object)methodsChain), weightAware.getWeight()));
                        continue;
                    }
                    MethodsChain methodsChain = ((MethodsChain)currentVertexUnderlying.second).addEdge(resolved, ((MethodIncompleteSignature)weightAware.getUnderlying()).getOwner(), weightAware.getWeight());
                    ParametersMatcher.MatchResult parametersMatchResult = ParametersMatcher.matchParameters(methodsChain, context);
                    if (parametersMatchResult.noUnmatchedAndHasMatched() && parametersMatchResult.hasTarget()) {
                        updated = true;
                        q.addFirst(new WeightAware<Pair>(Pair.create(weightAware.getUnderlying(), (Object)methodsChain), weightAware.getWeight()));
                    }
                    isBreak = true;
                }
            }
            if (!(updated || !((MethodIncompleteSignature)((Pair)currentVertex.getUnderlying()).getFirst()).isStatic() && targetQName.equals(((MethodIncompleteSignature)((Pair)currentVertex.getUnderlying()).getFirst()).getOwner()))) {
                result2.add((MethodsChain)((Pair)currentVertex.getUnderlying()).getSecond());
            }
            if (result2.size() <= maxResultSize) continue;
            return result2.getResult();
        }
        return result2.getResult();
    }

    private static MethodsChain createChainFromFirstElement(MethodsChain chain, PsiClass newQualifierClass) {
        String qualifiedClassName = newQualifierClass.getQualifiedName();
        if (qualifiedClassName == null) {
            throw new IllegalArgumentException();
        }
        return new MethodsChain(chain.getFirst(), chain.getChainWeight(), qualifiedClassName);
    }

    private static class ResultHolder {
        private final List<MethodsChain> myResult;
        private final PsiManager myContext;

        private ResultHolder(PsiManager psiManager) {
            this.myContext = psiManager;
            this.myResult = new ArrayList<MethodsChain>();
        }

        public void add(MethodsChain newChain) {
            if (this.myResult.isEmpty()) {
                this.myResult.add(newChain);
                return;
            }
            boolean doAdd = true;
            Stack<Integer> indexesToRemove = new Stack<Integer>();
            block4: for (int i2 = 0; i2 < this.myResult.size(); ++i2) {
                MethodsChain chain = this.myResult.get(i2);
                MethodsChain.CompareResult r = MethodsChain.compare(chain, newChain, this.myContext);
                switch (r) {
                    case LEFT_CONTAINS_RIGHT: {
                        indexesToRemove.add(i2);
                        continue block4;
                    }
                    case RIGHT_CONTAINS_LEFT: 
                    case EQUAL: {
                        doAdd = false;
                        continue block4;
                    }
                }
            }
            while (!indexesToRemove.empty()) {
                this.myResult.remove((Integer)indexesToRemove.pop());
            }
            if (doAdd) {
                this.myResult.add(newChain);
            }
        }

        public List<MethodsChain> getRawResult() {
            return this.myResult;
        }

        public List<MethodsChain> getResult() {
            return ResultHolder.findSimilar(ResultHolder.reduceChainsSize(this.myResult, PsiManager.getInstance((Project)this.myContext.getProject())), this.myContext);
        }

        public int size() {
            return this.myResult.size();
        }

        private static List<MethodsChain> reduceChainsSize(List<MethodsChain> chains, PsiManager psiManager) {
            return ContainerUtil.map(chains, chain -> {
                Iterator<PsiMethod[]> chainIterator = chain.iterator();
                if (!chainIterator.hasNext()) {
                    LOG.error("empty chain");
                    return chain;
                }
                PsiMethod[] first = chainIterator.next();
                while (chainIterator.hasNext()) {
                    PsiMethod psiMethod = chainIterator.next()[0];
                    if (psiMethod.hasModifierProperty("static")) continue;
                    PsiClass current = psiMethod.getContainingClass();
                    if (current == null) {
                        LOG.error("containing class must be not null");
                        return chain;
                    }
                    PsiMethod[] currentMethods = current.findMethodsByName(first[0].getName(), true);
                    if (currentMethods.length == 0) continue;
                    for (PsiMethod f : first) {
                        PsiMethod[] fSupers = f.findDeepestSuperMethods();
                        PsiMethod fSuper = fSupers.length == 0 ? first[0] : fSupers[0];
                        for (PsiMethod currentMethod : currentMethods) {
                            if (psiManager.areElementsEquivalent((PsiElement)currentMethod, (PsiElement)fSuper)) {
                                return ChainsSearcher.createChainFromFirstElement(chain, currentMethod.getContainingClass());
                            }
                            for (PsiMethod method2 : currentMethod.findDeepestSuperMethods()) {
                                if (!psiManager.areElementsEquivalent((PsiElement)method2, (PsiElement)fSuper)) continue;
                                return ChainsSearcher.createChainFromFirstElement(chain, method2.getContainingClass());
                            }
                        }
                    }
                }
                return chain;
            });
        }

        private static List<MethodsChain> findSimilar(List<MethodsChain> chains, PsiManager psiManager) {
            ResultHolder resultHolder = new ResultHolder(psiManager);
            for (MethodsChain chain : chains) {
                resultHolder.add(chain);
            }
            return resultHolder.getRawResult();
        }
    }
}

