/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodChainsSearchUtil {
    private MethodChainsSearchUtil() {
    }

    @Nullable
    public static PsiMethod getMethodWithMinNotPrimitiveParameters(@NotNull PsiMethod[] methods, Set<String> excludedParamsQNames) {
        PsiMethod minMethod = null;
        int minParametersCount = Integer.MAX_VALUE;
        for (PsiMethod method2 : methods) {
            PsiParameterList parameterList = method2.getParameterList();
            boolean doContinue = false;
            int parametersCount = parameterList.getParametersCount();
            for (PsiParameter p : parameterList.getParameters()) {
                if (p.getType() instanceof PsiPrimitiveType) continue;
                if (excludedParamsQNames.contains(p.getType().getCanonicalText())) {
                    doContinue = true;
                    break;
                }
                ++parametersCount;
            }
            if (doContinue || parametersCount >= minParametersCount) continue;
            if (parametersCount == 0) {
                return method2;
            }
            minParametersCount = parametersCount;
            minMethod = method2;
        }
        return minMethod;
    }

    public static boolean checkParametersForTypesQNames(PsiMethod[] psiMethods, Set<String> excludedTypesQNames) {
        if (psiMethods.length == 0) {
            return true;
        }
        for (PsiMethod method2 : psiMethods) {
            boolean hasTargetInParams = false;
            for (PsiParameter param : method2.getParameterList().getParameters()) {
                String paramType = param.getType().getCanonicalText();
                if (!excludedTypesQNames.contains(paramType)) continue;
                hasTargetInParams = true;
                break;
            }
            if (hasTargetInParams) continue;
            return true;
        }
        return false;
    }

    public static <T> HashSet<T> joinToHashSet(Collection<T> collection, T ... items) {
        HashSet<T> result2 = new HashSet<T>();
        result2.addAll(collection);
        Collections.addAll(result2, items);
        return result2;
    }
}

